/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsecuretunneling.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsecuretunneling.model.IoTSecureTunnelingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenTunnelResponse
extends IoTSecureTunnelingResponse
implements ToCopyableBuilder<Builder, OpenTunnelResponse> {
    private static final SdkField<String> TUNNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tunnelId").getter(OpenTunnelResponse.getter(OpenTunnelResponse::tunnelId)).setter(OpenTunnelResponse.setter(Builder::tunnelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tunnelId").build()}).build();
    private static final SdkField<String> TUNNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tunnelArn").getter(OpenTunnelResponse.getter(OpenTunnelResponse::tunnelArn)).setter(OpenTunnelResponse.setter(Builder::tunnelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tunnelArn").build()}).build();
    private static final SdkField<String> SOURCE_ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceAccessToken").getter(OpenTunnelResponse.getter(OpenTunnelResponse::sourceAccessToken)).setter(OpenTunnelResponse.setter(Builder::sourceAccessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAccessToken").build()}).build();
    private static final SdkField<String> DESTINATION_ACCESS_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationAccessToken").getter(OpenTunnelResponse.getter(OpenTunnelResponse::destinationAccessToken)).setter(OpenTunnelResponse.setter(Builder::destinationAccessToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationAccessToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TUNNEL_ID_FIELD, TUNNEL_ARN_FIELD, SOURCE_ACCESS_TOKEN_FIELD, DESTINATION_ACCESS_TOKEN_FIELD));
    private final String tunnelId;
    private final String tunnelArn;
    private final String sourceAccessToken;
    private final String destinationAccessToken;

    private OpenTunnelResponse(BuilderImpl builder) {
        super(builder);
        this.tunnelId = builder.tunnelId;
        this.tunnelArn = builder.tunnelArn;
        this.sourceAccessToken = builder.sourceAccessToken;
        this.destinationAccessToken = builder.destinationAccessToken;
    }

    public final String tunnelId() {
        return this.tunnelId;
    }

    public final String tunnelArn() {
        return this.tunnelArn;
    }

    public final String sourceAccessToken() {
        return this.sourceAccessToken;
    }

    public final String destinationAccessToken() {
        return this.destinationAccessToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tunnelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAccessToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationAccessToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenTunnelResponse)) {
            return false;
        }
        OpenTunnelResponse other = (OpenTunnelResponse)((Object)obj);
        return Objects.equals(this.tunnelId(), other.tunnelId()) && Objects.equals(this.tunnelArn(), other.tunnelArn()) && Objects.equals(this.sourceAccessToken(), other.sourceAccessToken()) && Objects.equals(this.destinationAccessToken(), other.destinationAccessToken());
    }

    public final String toString() {
        return ToString.builder((String)"OpenTunnelResponse").add("TunnelId", (Object)this.tunnelId()).add("TunnelArn", (Object)this.tunnelArn()).add("SourceAccessToken", (Object)(this.sourceAccessToken() == null ? null : "*** Sensitive Data Redacted ***")).add("DestinationAccessToken", (Object)(this.destinationAccessToken() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tunnelId": {
                return Optional.ofNullable(clazz.cast(this.tunnelId()));
            }
            case "tunnelArn": {
                return Optional.ofNullable(clazz.cast(this.tunnelArn()));
            }
            case "sourceAccessToken": {
                return Optional.ofNullable(clazz.cast(this.sourceAccessToken()));
            }
            case "destinationAccessToken": {
                return Optional.ofNullable(clazz.cast(this.destinationAccessToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpenTunnelResponse, T> g) {
        return obj -> g.apply((OpenTunnelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSecureTunnelingResponse.BuilderImpl
    implements Builder {
        private String tunnelId;
        private String tunnelArn;
        private String sourceAccessToken;
        private String destinationAccessToken;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenTunnelResponse model) {
            super(model);
            this.tunnelId(model.tunnelId);
            this.tunnelArn(model.tunnelArn);
            this.sourceAccessToken(model.sourceAccessToken);
            this.destinationAccessToken(model.destinationAccessToken);
        }

        public final String getTunnelId() {
            return this.tunnelId;
        }

        public final void setTunnelId(String tunnelId) {
            this.tunnelId = tunnelId;
        }

        @Override
        @Transient
        public final Builder tunnelId(String tunnelId) {
            this.tunnelId = tunnelId;
            return this;
        }

        public final String getTunnelArn() {
            return this.tunnelArn;
        }

        public final void setTunnelArn(String tunnelArn) {
            this.tunnelArn = tunnelArn;
        }

        @Override
        @Transient
        public final Builder tunnelArn(String tunnelArn) {
            this.tunnelArn = tunnelArn;
            return this;
        }

        public final String getSourceAccessToken() {
            return this.sourceAccessToken;
        }

        public final void setSourceAccessToken(String sourceAccessToken) {
            this.sourceAccessToken = sourceAccessToken;
        }

        @Override
        @Transient
        public final Builder sourceAccessToken(String sourceAccessToken) {
            this.sourceAccessToken = sourceAccessToken;
            return this;
        }

        public final String getDestinationAccessToken() {
            return this.destinationAccessToken;
        }

        public final void setDestinationAccessToken(String destinationAccessToken) {
            this.destinationAccessToken = destinationAccessToken;
        }

        @Override
        @Transient
        public final Builder destinationAccessToken(String destinationAccessToken) {
            this.destinationAccessToken = destinationAccessToken;
            return this;
        }

        @Override
        public OpenTunnelResponse build() {
            return new OpenTunnelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSecureTunnelingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, OpenTunnelResponse> {
        public Builder tunnelId(String var1);

        public Builder tunnelArn(String var1);

        public Builder sourceAccessToken(String var1);

        public Builder destinationAccessToken(String var1);
    }
}

