/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsecuretunneling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A connection between a source computer and a destination device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Tunnel implements SdkPojo, Serializable, ToCopyableBuilder<Tunnel.Builder, Tunnel> {
    private static final SdkField<String> TUNNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Tunnel::tunnelId)).setter(setter(Builder::tunnelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tunnelId").build()).build();

    private static final SdkField<String> TUNNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Tunnel::tunnelArn)).setter(setter(Builder::tunnelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tunnelArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Tunnel::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<ConnectionState> SOURCE_CONNECTION_STATE_FIELD = SdkField
            .<ConnectionState> builder(MarshallingType.SDK_POJO).getter(getter(Tunnel::sourceConnectionState))
            .setter(setter(Builder::sourceConnectionState)).constructor(ConnectionState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceConnectionState").build())
            .build();

    private static final SdkField<ConnectionState> DESTINATION_CONNECTION_STATE_FIELD = SdkField
            .<ConnectionState> builder(MarshallingType.SDK_POJO)
            .getter(getter(Tunnel::destinationConnectionState))
            .setter(setter(Builder::destinationConnectionState))
            .constructor(ConnectionState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConnectionState").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Tunnel::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<DestinationConfig> DESTINATION_CONFIG_FIELD = SdkField
            .<DestinationConfig> builder(MarshallingType.SDK_POJO).getter(getter(Tunnel::destinationConfig))
            .setter(setter(Builder::destinationConfig)).constructor(DestinationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfig").build()).build();

    private static final SdkField<TimeoutConfig> TIMEOUT_CONFIG_FIELD = SdkField
            .<TimeoutConfig> builder(MarshallingType.SDK_POJO).getter(getter(Tunnel::timeoutConfig))
            .setter(setter(Builder::timeoutConfig)).constructor(TimeoutConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutConfig").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(Tunnel::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Tunnel::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Tunnel::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TUNNEL_ID_FIELD,
            TUNNEL_ARN_FIELD, STATUS_FIELD, SOURCE_CONNECTION_STATE_FIELD, DESTINATION_CONNECTION_STATE_FIELD, DESCRIPTION_FIELD,
            DESTINATION_CONFIG_FIELD, TIMEOUT_CONFIG_FIELD, TAGS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String tunnelId;

    private final String tunnelArn;

    private final String status;

    private final ConnectionState sourceConnectionState;

    private final ConnectionState destinationConnectionState;

    private final String description;

    private final DestinationConfig destinationConfig;

    private final TimeoutConfig timeoutConfig;

    private final List<Tag> tags;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private Tunnel(BuilderImpl builder) {
        this.tunnelId = builder.tunnelId;
        this.tunnelArn = builder.tunnelArn;
        this.status = builder.status;
        this.sourceConnectionState = builder.sourceConnectionState;
        this.destinationConnectionState = builder.destinationConnectionState;
        this.description = builder.description;
        this.destinationConfig = builder.destinationConfig;
        this.timeoutConfig = builder.timeoutConfig;
        this.tags = builder.tags;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * A unique alpha-numeric ID that identifies a tunnel.
     * </p>
     * 
     * @return A unique alpha-numeric ID that identifies a tunnel.
     */
    public String tunnelId() {
        return tunnelId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a tunnel. The tunnel ARN format is
     * <code>arn:aws:tunnel:&lt;region&gt;:&lt;account-id&gt;:tunnel/&lt;tunnel-id&gt;</code>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a tunnel. The tunnel ARN format is
     *         <code>arn:aws:tunnel:&lt;region&gt;:&lt;account-id&gt;:tunnel/&lt;tunnel-id&gt;</code>
     */
    public String tunnelArn() {
        return tunnelArn;
    }

    /**
     * <p>
     * The status of a tunnel. Valid values are: Open and Closed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TunnelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a tunnel. Valid values are: Open and Closed.
     * @see TunnelStatus
     */
    public TunnelStatus status() {
        return TunnelStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a tunnel. Valid values are: Open and Closed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TunnelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a tunnel. Valid values are: Open and Closed.
     * @see TunnelStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The connection state of the source application.
     * </p>
     * 
     * @return The connection state of the source application.
     */
    public ConnectionState sourceConnectionState() {
        return sourceConnectionState;
    }

    /**
     * <p>
     * The connection state of the destination application.
     * </p>
     * 
     * @return The connection state of the destination application.
     */
    public ConnectionState destinationConnectionState() {
        return destinationConnectionState;
    }

    /**
     * <p>
     * A description of the tunnel.
     * </p>
     * 
     * @return A description of the tunnel.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The destination configuration that specifies the thing name of the destination device and a service name that the
     * local proxy uses to connect to the destination application.
     * </p>
     * 
     * @return The destination configuration that specifies the thing name of the destination device and a service name
     *         that the local proxy uses to connect to the destination application.
     */
    public DestinationConfig destinationConfig() {
        return destinationConfig;
    }

    /**
     * <p>
     * Timeout configuration for the tunnel.
     * </p>
     * 
     * @return Timeout configuration for the tunnel.
     */
    public TimeoutConfig timeoutConfig() {
        return timeoutConfig;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tag metadata associated with the secure tunnel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tag metadata associated with the secure tunnel.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The time when the tunnel was created.
     * </p>
     * 
     * @return The time when the tunnel was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The last time the tunnel was updated.
     * </p>
     * 
     * @return The last time the tunnel was updated.
     */
    public Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tunnelId());
        hashCode = 31 * hashCode + Objects.hashCode(tunnelArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceConnectionState());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConnectionState());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tunnel)) {
            return false;
        }
        Tunnel other = (Tunnel) obj;
        return Objects.equals(tunnelId(), other.tunnelId()) && Objects.equals(tunnelArn(), other.tunnelArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(sourceConnectionState(), other.sourceConnectionState())
                && Objects.equals(destinationConnectionState(), other.destinationConnectionState())
                && Objects.equals(description(), other.description())
                && Objects.equals(destinationConfig(), other.destinationConfig())
                && Objects.equals(timeoutConfig(), other.timeoutConfig()) && Objects.equals(tags(), other.tags())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Tunnel").add("TunnelId", tunnelId()).add("TunnelArn", tunnelArn())
                .add("Status", statusAsString()).add("SourceConnectionState", sourceConnectionState())
                .add("DestinationConnectionState", destinationConnectionState()).add("Description", description())
                .add("DestinationConfig", destinationConfig()).add("TimeoutConfig", timeoutConfig()).add("Tags", tags())
                .add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tunnelId":
            return Optional.ofNullable(clazz.cast(tunnelId()));
        case "tunnelArn":
            return Optional.ofNullable(clazz.cast(tunnelArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "sourceConnectionState":
            return Optional.ofNullable(clazz.cast(sourceConnectionState()));
        case "destinationConnectionState":
            return Optional.ofNullable(clazz.cast(destinationConnectionState()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "destinationConfig":
            return Optional.ofNullable(clazz.cast(destinationConfig()));
        case "timeoutConfig":
            return Optional.ofNullable(clazz.cast(timeoutConfig()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Tunnel, T> g) {
        return obj -> g.apply((Tunnel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Tunnel> {
        /**
         * <p>
         * A unique alpha-numeric ID that identifies a tunnel.
         * </p>
         * 
         * @param tunnelId
         *        A unique alpha-numeric ID that identifies a tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelId(String tunnelId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a tunnel. The tunnel ARN format is
         * <code>arn:aws:tunnel:&lt;region&gt;:&lt;account-id&gt;:tunnel/&lt;tunnel-id&gt;</code>
         * </p>
         * 
         * @param tunnelArn
         *        The Amazon Resource Name (ARN) of a tunnel. The tunnel ARN format is
         *        <code>arn:aws:tunnel:&lt;region&gt;:&lt;account-id&gt;:tunnel/&lt;tunnel-id&gt;</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelArn(String tunnelArn);

        /**
         * <p>
         * The status of a tunnel. Valid values are: Open and Closed.
         * </p>
         * 
         * @param status
         *        The status of a tunnel. Valid values are: Open and Closed.
         * @see TunnelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TunnelStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a tunnel. Valid values are: Open and Closed.
         * </p>
         * 
         * @param status
         *        The status of a tunnel. Valid values are: Open and Closed.
         * @see TunnelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TunnelStatus
         */
        Builder status(TunnelStatus status);

        /**
         * <p>
         * The connection state of the source application.
         * </p>
         * 
         * @param sourceConnectionState
         *        The connection state of the source application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceConnectionState(ConnectionState sourceConnectionState);

        /**
         * <p>
         * The connection state of the source application.
         * </p>
         * This is a convenience that creates an instance of the {@link ConnectionState.Builder} avoiding the need to
         * create one manually via {@link ConnectionState#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectionState.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceConnectionState(ConnectionState)}.
         * 
         * @param sourceConnectionState
         *        a consumer that will call methods on {@link ConnectionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceConnectionState(ConnectionState)
         */
        default Builder sourceConnectionState(Consumer<ConnectionState.Builder> sourceConnectionState) {
            return sourceConnectionState(ConnectionState.builder().applyMutation(sourceConnectionState).build());
        }

        /**
         * <p>
         * The connection state of the destination application.
         * </p>
         * 
         * @param destinationConnectionState
         *        The connection state of the destination application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConnectionState(ConnectionState destinationConnectionState);

        /**
         * <p>
         * The connection state of the destination application.
         * </p>
         * This is a convenience that creates an instance of the {@link ConnectionState.Builder} avoiding the need to
         * create one manually via {@link ConnectionState#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectionState.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationConnectionState(ConnectionState)}.
         * 
         * @param destinationConnectionState
         *        a consumer that will call methods on {@link ConnectionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConnectionState(ConnectionState)
         */
        default Builder destinationConnectionState(Consumer<ConnectionState.Builder> destinationConnectionState) {
            return destinationConnectionState(ConnectionState.builder().applyMutation(destinationConnectionState).build());
        }

        /**
         * <p>
         * A description of the tunnel.
         * </p>
         * 
         * @param description
         *        A description of the tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The destination configuration that specifies the thing name of the destination device and a service name that
         * the local proxy uses to connect to the destination application.
         * </p>
         * 
         * @param destinationConfig
         *        The destination configuration that specifies the thing name of the destination device and a service
         *        name that the local proxy uses to connect to the destination application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfig(DestinationConfig destinationConfig);

        /**
         * <p>
         * The destination configuration that specifies the thing name of the destination device and a service name that
         * the local proxy uses to connect to the destination application.
         * </p>
         * This is a convenience that creates an instance of the {@link DestinationConfig.Builder} avoiding the need to
         * create one manually via {@link DestinationConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link DestinationConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #destinationConfig(DestinationConfig)}.
         * 
         * @param destinationConfig
         *        a consumer that will call methods on {@link DestinationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfig(DestinationConfig)
         */
        default Builder destinationConfig(Consumer<DestinationConfig.Builder> destinationConfig) {
            return destinationConfig(DestinationConfig.builder().applyMutation(destinationConfig).build());
        }

        /**
         * <p>
         * Timeout configuration for the tunnel.
         * </p>
         * 
         * @param timeoutConfig
         *        Timeout configuration for the tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutConfig(TimeoutConfig timeoutConfig);

        /**
         * <p>
         * Timeout configuration for the tunnel.
         * </p>
         * This is a convenience that creates an instance of the {@link TimeoutConfig.Builder} avoiding the need to
         * create one manually via {@link TimeoutConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimeoutConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #timeoutConfig(TimeoutConfig)}.
         * 
         * @param timeoutConfig
         *        a consumer that will call methods on {@link TimeoutConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeoutConfig(TimeoutConfig)
         */
        default Builder timeoutConfig(Consumer<TimeoutConfig.Builder> timeoutConfig) {
            return timeoutConfig(TimeoutConfig.builder().applyMutation(timeoutConfig).build());
        }

        /**
         * <p>
         * A list of tag metadata associated with the secure tunnel.
         * </p>
         * 
         * @param tags
         *        A list of tag metadata associated with the secure tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tag metadata associated with the secure tunnel.
         * </p>
         * 
         * @param tags
         *        A list of tag metadata associated with the secure tunnel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tag metadata associated with the secure tunnel.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The time when the tunnel was created.
         * </p>
         * 
         * @param createdAt
         *        The time when the tunnel was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The last time the tunnel was updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The last time the tunnel was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String tunnelId;

        private String tunnelArn;

        private String status;

        private ConnectionState sourceConnectionState;

        private ConnectionState destinationConnectionState;

        private String description;

        private DestinationConfig destinationConfig;

        private TimeoutConfig timeoutConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Tunnel model) {
            tunnelId(model.tunnelId);
            tunnelArn(model.tunnelArn);
            status(model.status);
            sourceConnectionState(model.sourceConnectionState);
            destinationConnectionState(model.destinationConnectionState);
            description(model.description);
            destinationConfig(model.destinationConfig);
            timeoutConfig(model.timeoutConfig);
            tags(model.tags);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getTunnelId() {
            return tunnelId;
        }

        @Override
        public final Builder tunnelId(String tunnelId) {
            this.tunnelId = tunnelId;
            return this;
        }

        public final void setTunnelId(String tunnelId) {
            this.tunnelId = tunnelId;
        }

        public final String getTunnelArn() {
            return tunnelArn;
        }

        @Override
        public final Builder tunnelArn(String tunnelArn) {
            this.tunnelArn = tunnelArn;
            return this;
        }

        public final void setTunnelArn(String tunnelArn) {
            this.tunnelArn = tunnelArn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TunnelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final ConnectionState.Builder getSourceConnectionState() {
            return sourceConnectionState != null ? sourceConnectionState.toBuilder() : null;
        }

        @Override
        public final Builder sourceConnectionState(ConnectionState sourceConnectionState) {
            this.sourceConnectionState = sourceConnectionState;
            return this;
        }

        public final void setSourceConnectionState(ConnectionState.BuilderImpl sourceConnectionState) {
            this.sourceConnectionState = sourceConnectionState != null ? sourceConnectionState.build() : null;
        }

        public final ConnectionState.Builder getDestinationConnectionState() {
            return destinationConnectionState != null ? destinationConnectionState.toBuilder() : null;
        }

        @Override
        public final Builder destinationConnectionState(ConnectionState destinationConnectionState) {
            this.destinationConnectionState = destinationConnectionState;
            return this;
        }

        public final void setDestinationConnectionState(ConnectionState.BuilderImpl destinationConnectionState) {
            this.destinationConnectionState = destinationConnectionState != null ? destinationConnectionState.build() : null;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final DestinationConfig.Builder getDestinationConfig() {
            return destinationConfig != null ? destinationConfig.toBuilder() : null;
        }

        @Override
        public final Builder destinationConfig(DestinationConfig destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        public final void setDestinationConfig(DestinationConfig.BuilderImpl destinationConfig) {
            this.destinationConfig = destinationConfig != null ? destinationConfig.build() : null;
        }

        public final TimeoutConfig.Builder getTimeoutConfig() {
            return timeoutConfig != null ? timeoutConfig.toBuilder() : null;
        }

        @Override
        public final Builder timeoutConfig(TimeoutConfig timeoutConfig) {
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        public final void setTimeoutConfig(TimeoutConfig.BuilderImpl timeoutConfig) {
            this.timeoutConfig = timeoutConfig != null ? timeoutConfig.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public Tunnel build() {
            return new Tunnel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
