/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsecuretunneling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloseTunnelRequest extends IoTSecureTunnelingRequest implements
        ToCopyableBuilder<CloseTunnelRequest.Builder, CloseTunnelRequest> {
    private static final SdkField<String> TUNNEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloseTunnelRequest::tunnelId)).setter(setter(Builder::tunnelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tunnelId").build()).build();

    private static final SdkField<Boolean> DELETE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CloseTunnelRequest::delete)).setter(setter(Builder::delete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("delete").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TUNNEL_ID_FIELD, DELETE_FIELD));

    private final String tunnelId;

    private final Boolean delete;

    private CloseTunnelRequest(BuilderImpl builder) {
        super(builder);
        this.tunnelId = builder.tunnelId;
        this.delete = builder.delete;
    }

    /**
     * <p>
     * The ID of the tunnel to close.
     * </p>
     * 
     * @return The ID of the tunnel to close.
     */
    public String tunnelId() {
        return tunnelId;
    }

    /**
     * <p>
     * When set to true, AWS IoT Secure Tunneling deletes the tunnel data immediately.
     * </p>
     * 
     * @return When set to true, AWS IoT Secure Tunneling deletes the tunnel data immediately.
     */
    public Boolean delete() {
        return delete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tunnelId());
        hashCode = 31 * hashCode + Objects.hashCode(delete());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloseTunnelRequest)) {
            return false;
        }
        CloseTunnelRequest other = (CloseTunnelRequest) obj;
        return Objects.equals(tunnelId(), other.tunnelId()) && Objects.equals(delete(), other.delete());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CloseTunnelRequest").add("TunnelId", tunnelId()).add("Delete", delete()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tunnelId":
            return Optional.ofNullable(clazz.cast(tunnelId()));
        case "delete":
            return Optional.ofNullable(clazz.cast(delete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloseTunnelRequest, T> g) {
        return obj -> g.apply((CloseTunnelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSecureTunnelingRequest.Builder, SdkPojo, CopyableBuilder<Builder, CloseTunnelRequest> {
        /**
         * <p>
         * The ID of the tunnel to close.
         * </p>
         * 
         * @param tunnelId
         *        The ID of the tunnel to close.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelId(String tunnelId);

        /**
         * <p>
         * When set to true, AWS IoT Secure Tunneling deletes the tunnel data immediately.
         * </p>
         * 
         * @param delete
         *        When set to true, AWS IoT Secure Tunneling deletes the tunnel data immediately.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delete(Boolean delete);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSecureTunnelingRequest.BuilderImpl implements Builder {
        private String tunnelId;

        private Boolean delete;

        private BuilderImpl() {
        }

        private BuilderImpl(CloseTunnelRequest model) {
            super(model);
            tunnelId(model.tunnelId);
            delete(model.delete);
        }

        public final String getTunnelId() {
            return tunnelId;
        }

        @Override
        public final Builder tunnelId(String tunnelId) {
            this.tunnelId = tunnelId;
            return this;
        }

        public final void setTunnelId(String tunnelId) {
            this.tunnelId = tunnelId;
        }

        public final Boolean getDelete() {
            return delete;
        }

        @Override
        public final Builder delete(Boolean delete) {
            this.delete = delete;
            return this;
        }

        public final void setDelete(Boolean delete) {
            this.delete = delete;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CloseTunnelRequest build() {
            return new CloseTunnelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
