/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotroborunner.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotroborunner.IotRoboRunnerClient;
import software.amazon.awssdk.services.iotroborunner.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsRequest;
import software.amazon.awssdk.services.iotroborunner.model.ListWorkerFleetsResponse;
import software.amazon.awssdk.services.iotroborunner.model.WorkerFleet;

public class ListWorkerFleetsIterable
implements SdkIterable<ListWorkerFleetsResponse> {
    private final IotRoboRunnerClient client;
    private final ListWorkerFleetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkerFleetsIterable(IotRoboRunnerClient client, ListWorkerFleetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkerFleetsResponseFetcher();
    }

    public Iterator<ListWorkerFleetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkerFleet> workerFleets() {
        Function<ListWorkerFleetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workerFleets() != null) {
                return response.workerFleets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkerFleetsResponseFetcher
    implements SyncPageFetcher<ListWorkerFleetsResponse> {
        private ListWorkerFleetsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkerFleetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkerFleetsResponse nextPage(ListWorkerFleetsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkerFleetsIterable.this.client.listWorkerFleets(ListWorkerFleetsIterable.this.firstRequest);
            }
            return ListWorkerFleetsIterable.this.client.listWorkerFleets((ListWorkerFleetsRequest)((Object)ListWorkerFleetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

