/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotroborunner.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A unit capable of performing tasks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Worker implements SdkPojo, Serializable, ToCopyableBuilder<Worker.Builder, Worker> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Worker::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Worker::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> FLEET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("fleet")
            .getter(getter(Worker::fleet)).setter(setter(Builder::fleet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleet").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(Worker::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(Worker::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Worker::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SITE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("site")
            .getter(getter(Worker::site)).setter(setter(Builder::site))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("site").build()).build();

    private static final SdkField<String> ADDITIONAL_TRANSIENT_PROPERTIES_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("additionalTransientProperties")
            .getter(getter(Worker::additionalTransientProperties))
            .setter(setter(Builder::additionalTransientProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalTransientProperties")
                    .build()).build();

    private static final SdkField<String> ADDITIONAL_FIXED_PROPERTIES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("additionalFixedProperties").getter(getter(Worker::additionalFixedProperties))
            .setter(setter(Builder::additionalFixedProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalFixedProperties").build())
            .build();

    private static final SdkField<VendorProperties> VENDOR_PROPERTIES_FIELD = SdkField
            .<VendorProperties> builder(MarshallingType.SDK_POJO).memberName("vendorProperties")
            .getter(getter(Worker::vendorProperties)).setter(setter(Builder::vendorProperties))
            .constructor(VendorProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vendorProperties").build()).build();

    private static final SdkField<PositionCoordinates> POSITION_FIELD = SdkField
            .<PositionCoordinates> builder(MarshallingType.SDK_POJO).memberName("position").getter(getter(Worker::position))
            .setter(setter(Builder::position)).constructor(PositionCoordinates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()).build();

    private static final SdkField<Orientation> ORIENTATION_FIELD = SdkField.<Orientation> builder(MarshallingType.SDK_POJO)
            .memberName("orientation").getter(getter(Worker::orientation)).setter(setter(Builder::orientation))
            .constructor(Orientation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orientation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            FLEET_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, NAME_FIELD, SITE_FIELD, ADDITIONAL_TRANSIENT_PROPERTIES_FIELD,
            ADDITIONAL_FIXED_PROPERTIES_FIELD, VENDOR_PROPERTIES_FIELD, POSITION_FIELD, ORIENTATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final String fleet;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String name;

    private final String site;

    private final String additionalTransientProperties;

    private final String additionalFixedProperties;

    private final VendorProperties vendorProperties;

    private final PositionCoordinates position;

    private final Orientation orientation;

    private Worker(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.fleet = builder.fleet;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.name = builder.name;
        this.site = builder.site;
        this.additionalTransientProperties = builder.additionalTransientProperties;
        this.additionalFixedProperties = builder.additionalFixedProperties;
        this.vendorProperties = builder.vendorProperties;
        this.position = builder.position;
        this.orientation = builder.orientation;
    }

    /**
     * Returns the value of the Arn property for this object.
     * 
     * @return The value of the Arn property for this object.
     */
    public final String arn() {
        return arn;
    }

    /**
     * Returns the value of the Id property for this object.
     * 
     * @return The value of the Id property for this object.
     */
    public final String id() {
        return id;
    }

    /**
     * Returns the value of the Fleet property for this object.
     * 
     * @return The value of the Fleet property for this object.
     */
    public final String fleet() {
        return fleet;
    }

    /**
     * Returns the value of the CreatedAt property for this object.
     * 
     * @return The value of the CreatedAt property for this object.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * Returns the value of the UpdatedAt property for this object.
     * 
     * @return The value of the UpdatedAt property for this object.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns the value of the Site property for this object.
     * 
     * @return The value of the Site property for this object.
     */
    public final String site() {
        return site;
    }

    /**
     * Returns the value of the AdditionalTransientProperties property for this object.
     * 
     * @return The value of the AdditionalTransientProperties property for this object.
     */
    public final String additionalTransientProperties() {
        return additionalTransientProperties;
    }

    /**
     * Returns the value of the AdditionalFixedProperties property for this object.
     * 
     * @return The value of the AdditionalFixedProperties property for this object.
     */
    public final String additionalFixedProperties() {
        return additionalFixedProperties;
    }

    /**
     * Returns the value of the VendorProperties property for this object.
     * 
     * @return The value of the VendorProperties property for this object.
     */
    public final VendorProperties vendorProperties() {
        return vendorProperties;
    }

    /**
     * Returns the value of the Position property for this object.
     * 
     * @return The value of the Position property for this object.
     */
    public final PositionCoordinates position() {
        return position;
    }

    /**
     * Returns the value of the Orientation property for this object.
     * 
     * @return The value of the Orientation property for this object.
     */
    public final Orientation orientation() {
        return orientation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(fleet());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(site());
        hashCode = 31 * hashCode + Objects.hashCode(additionalTransientProperties());
        hashCode = 31 * hashCode + Objects.hashCode(additionalFixedProperties());
        hashCode = 31 * hashCode + Objects.hashCode(vendorProperties());
        hashCode = 31 * hashCode + Objects.hashCode(position());
        hashCode = 31 * hashCode + Objects.hashCode(orientation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Worker)) {
            return false;
        }
        Worker other = (Worker) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id()) && Objects.equals(fleet(), other.fleet())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(name(), other.name()) && Objects.equals(site(), other.site())
                && Objects.equals(additionalTransientProperties(), other.additionalTransientProperties())
                && Objects.equals(additionalFixedProperties(), other.additionalFixedProperties())
                && Objects.equals(vendorProperties(), other.vendorProperties()) && Objects.equals(position(), other.position())
                && Objects.equals(orientation(), other.orientation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Worker").add("Arn", arn()).add("Id", id()).add("Fleet", fleet()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).add("Name", name()).add("Site", site())
                .add("AdditionalTransientProperties", additionalTransientProperties())
                .add("AdditionalFixedProperties", additionalFixedProperties()).add("VendorProperties", vendorProperties())
                .add("Position", position()).add("Orientation", orientation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "fleet":
            return Optional.ofNullable(clazz.cast(fleet()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "site":
            return Optional.ofNullable(clazz.cast(site()));
        case "additionalTransientProperties":
            return Optional.ofNullable(clazz.cast(additionalTransientProperties()));
        case "additionalFixedProperties":
            return Optional.ofNullable(clazz.cast(additionalFixedProperties()));
        case "vendorProperties":
            return Optional.ofNullable(clazz.cast(vendorProperties()));
        case "position":
            return Optional.ofNullable(clazz.cast(position()));
        case "orientation":
            return Optional.ofNullable(clazz.cast(orientation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Worker, T> g) {
        return obj -> g.apply((Worker) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Worker> {
        /**
         * Sets the value of the Arn property for this object.
         *
         * @param arn
         *        The new value for the Arn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Sets the value of the Id property for this object.
         *
         * @param id
         *        The new value for the Id property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * Sets the value of the Fleet property for this object.
         *
         * @param fleet
         *        The new value for the Fleet property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleet(String fleet);

        /**
         * Sets the value of the CreatedAt property for this object.
         *
         * @param createdAt
         *        The new value for the CreatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * Sets the value of the UpdatedAt property for this object.
         *
         * @param updatedAt
         *        The new value for the UpdatedAt property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * Sets the value of the Site property for this object.
         *
         * @param site
         *        The new value for the Site property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder site(String site);

        /**
         * Sets the value of the AdditionalTransientProperties property for this object.
         *
         * @param additionalTransientProperties
         *        The new value for the AdditionalTransientProperties property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalTransientProperties(String additionalTransientProperties);

        /**
         * Sets the value of the AdditionalFixedProperties property for this object.
         *
         * @param additionalFixedProperties
         *        The new value for the AdditionalFixedProperties property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalFixedProperties(String additionalFixedProperties);

        /**
         * Sets the value of the VendorProperties property for this object.
         *
         * @param vendorProperties
         *        The new value for the VendorProperties property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendorProperties(VendorProperties vendorProperties);

        /**
         * Sets the value of the VendorProperties property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VendorProperties.Builder} avoiding the
         * need to create one manually via {@link VendorProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VendorProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #vendorProperties(VendorProperties)}.
         * 
         * @param vendorProperties
         *        a consumer that will call methods on {@link VendorProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vendorProperties(VendorProperties)
         */
        default Builder vendorProperties(Consumer<VendorProperties.Builder> vendorProperties) {
            return vendorProperties(VendorProperties.builder().applyMutation(vendorProperties).build());
        }

        /**
         * Sets the value of the Position property for this object.
         *
         * @param position
         *        The new value for the Position property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(PositionCoordinates position);

        /**
         * Sets the value of the Position property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PositionCoordinates.Builder} avoiding the
         * need to create one manually via {@link PositionCoordinates#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PositionCoordinates.Builder#build()} is called immediately and
         * its result is passed to {@link #position(PositionCoordinates)}.
         * 
         * @param position
         *        a consumer that will call methods on {@link PositionCoordinates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #position(PositionCoordinates)
         */
        default Builder position(Consumer<PositionCoordinates.Builder> position) {
            return position(PositionCoordinates.builder().applyMutation(position).build());
        }

        /**
         * Sets the value of the Orientation property for this object.
         *
         * @param orientation
         *        The new value for the Orientation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orientation(Orientation orientation);

        /**
         * Sets the value of the Orientation property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Orientation.Builder} avoiding the need to
         * create one manually via {@link Orientation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Orientation.Builder#build()} is called immediately and its result
         * is passed to {@link #orientation(Orientation)}.
         * 
         * @param orientation
         *        a consumer that will call methods on {@link Orientation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orientation(Orientation)
         */
        default Builder orientation(Consumer<Orientation.Builder> orientation) {
            return orientation(Orientation.builder().applyMutation(orientation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String fleet;

        private Instant createdAt;

        private Instant updatedAt;

        private String name;

        private String site;

        private String additionalTransientProperties;

        private String additionalFixedProperties;

        private VendorProperties vendorProperties;

        private PositionCoordinates position;

        private Orientation orientation;

        private BuilderImpl() {
        }

        private BuilderImpl(Worker model) {
            arn(model.arn);
            id(model.id);
            fleet(model.fleet);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            name(model.name);
            site(model.site);
            additionalTransientProperties(model.additionalTransientProperties);
            additionalFixedProperties(model.additionalFixedProperties);
            vendorProperties(model.vendorProperties);
            position(model.position);
            orientation(model.orientation);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getFleet() {
            return fleet;
        }

        public final void setFleet(String fleet) {
            this.fleet = fleet;
        }

        @Override
        public final Builder fleet(String fleet) {
            this.fleet = fleet;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSite() {
            return site;
        }

        public final void setSite(String site) {
            this.site = site;
        }

        @Override
        public final Builder site(String site) {
            this.site = site;
            return this;
        }

        public final String getAdditionalTransientProperties() {
            return additionalTransientProperties;
        }

        public final void setAdditionalTransientProperties(String additionalTransientProperties) {
            this.additionalTransientProperties = additionalTransientProperties;
        }

        @Override
        public final Builder additionalTransientProperties(String additionalTransientProperties) {
            this.additionalTransientProperties = additionalTransientProperties;
            return this;
        }

        public final String getAdditionalFixedProperties() {
            return additionalFixedProperties;
        }

        public final void setAdditionalFixedProperties(String additionalFixedProperties) {
            this.additionalFixedProperties = additionalFixedProperties;
        }

        @Override
        public final Builder additionalFixedProperties(String additionalFixedProperties) {
            this.additionalFixedProperties = additionalFixedProperties;
            return this;
        }

        public final VendorProperties.Builder getVendorProperties() {
            return vendorProperties != null ? vendorProperties.toBuilder() : null;
        }

        public final void setVendorProperties(VendorProperties.BuilderImpl vendorProperties) {
            this.vendorProperties = vendorProperties != null ? vendorProperties.build() : null;
        }

        @Override
        public final Builder vendorProperties(VendorProperties vendorProperties) {
            this.vendorProperties = vendorProperties;
            return this;
        }

        public final PositionCoordinates.Builder getPosition() {
            return position != null ? position.toBuilder() : null;
        }

        public final void setPosition(PositionCoordinates.BuilderImpl position) {
            this.position = position != null ? position.build() : null;
        }

        @Override
        public final Builder position(PositionCoordinates position) {
            this.position = position;
            return this;
        }

        public final Orientation.Builder getOrientation() {
            return orientation != null ? orientation.toBuilder() : null;
        }

        public final void setOrientation(Orientation.BuilderImpl orientation) {
            this.orientation = orientation != null ? orientation.build() : null;
        }

        @Override
        public final Builder orientation(Orientation orientation) {
            this.orientation = orientation;
            return this;
        }

        @Override
        public Worker build() {
            return new Worker(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
