/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ConnectorDestinationSummary;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsResponse;

public class ListConnectorDestinationsIterable
implements SdkIterable<ListConnectorDestinationsResponse> {
    private final IotManagedIntegrationsClient client;
    private final ListConnectorDestinationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConnectorDestinationsIterable(IotManagedIntegrationsClient client, ListConnectorDestinationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConnectorDestinationsResponseFetcher();
    }

    public Iterator<ListConnectorDestinationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConnectorDestinationSummary> connectorDestinationList() {
        Function<ListConnectorDestinationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.connectorDestinationList() != null) {
                return response.connectorDestinationList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConnectorDestinationsResponseFetcher
    implements SyncPageFetcher<ListConnectorDestinationsResponse> {
        private ListConnectorDestinationsResponseFetcher() {
        }

        public boolean hasNextPage(ListConnectorDestinationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConnectorDestinationsResponse nextPage(ListConnectorDestinationsResponse previousPage) {
            if (previousPage == null) {
                return ListConnectorDestinationsIterable.this.client.listConnectorDestinations(ListConnectorDestinationsIterable.this.firstRequest);
            }
            return ListConnectorDestinationsIterable.this.client.listConnectorDestinations((ListConnectorDestinationsRequest)((Object)ListConnectorDestinationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

