/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeviceTypesCopier;
import software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCapabilityReportCluster;
import software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCapabilityReportClustersCopier;
import software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCapabilityReportEndpointClientClustersCopier;
import software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCapabilityReportEndpointPartsCopier;
import software.amazon.awssdk.services.iotmanagedintegrations.model.MatterCapabilityReportEndpointSemanticTagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MatterCapabilityReportEndpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MatterCapabilityReportEndpoint> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(MatterCapabilityReportEndpoint.getter(MatterCapabilityReportEndpoint::id)).setter(MatterCapabilityReportEndpoint.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<List<String>> DEVICE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deviceTypes").getter(MatterCapabilityReportEndpoint.getter(MatterCapabilityReportEndpoint::deviceTypes)).setter(MatterCapabilityReportEndpoint.setter(Builder::deviceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MatterCapabilityReportCluster>> CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("clusters").getter(MatterCapabilityReportEndpoint.getter(MatterCapabilityReportEndpoint::clusters)).setter(MatterCapabilityReportEndpoint.setter(Builder::clusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MatterCapabilityReportCluster::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PARTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parts").getter(MatterCapabilityReportEndpoint.getter(MatterCapabilityReportEndpoint::parts)).setter(MatterCapabilityReportEndpoint.setter(Builder::parts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SEMANTIC_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("semanticTags").getter(MatterCapabilityReportEndpoint.getter(MatterCapabilityReportEndpoint::semanticTags)).setter(MatterCapabilityReportEndpoint.setter(Builder::semanticTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("semanticTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CLIENT_CLUSTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("clientClusters").getter(MatterCapabilityReportEndpoint.getter(MatterCapabilityReportEndpoint::clientClusters)).setter(MatterCapabilityReportEndpoint.setter(Builder::clientClusters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientClusters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DEVICE_TYPES_FIELD, CLUSTERS_FIELD, PARTS_FIELD, SEMANTIC_TAGS_FIELD, CLIENT_CLUSTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MatterCapabilityReportEndpoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final List<String> deviceTypes;
    private final List<MatterCapabilityReportCluster> clusters;
    private final List<String> parts;
    private final List<String> semanticTags;
    private final List<String> clientClusters;

    private MatterCapabilityReportEndpoint(BuilderImpl builder) {
        this.id = builder.id;
        this.deviceTypes = builder.deviceTypes;
        this.clusters = builder.clusters;
        this.parts = builder.parts;
        this.semanticTags = builder.semanticTags;
        this.clientClusters = builder.clientClusters;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasDeviceTypes() {
        return this.deviceTypes != null && !(this.deviceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> deviceTypes() {
        return this.deviceTypes;
    }

    public final boolean hasClusters() {
        return this.clusters != null && !(this.clusters instanceof SdkAutoConstructList);
    }

    public final List<MatterCapabilityReportCluster> clusters() {
        return this.clusters;
    }

    public final boolean hasParts() {
        return this.parts != null && !(this.parts instanceof SdkAutoConstructList);
    }

    public final List<String> parts() {
        return this.parts;
    }

    public final boolean hasSemanticTags() {
        return this.semanticTags != null && !(this.semanticTags instanceof SdkAutoConstructList);
    }

    public final List<String> semanticTags() {
        return this.semanticTags;
    }

    public final boolean hasClientClusters() {
        return this.clientClusters != null && !(this.clientClusters instanceof SdkAutoConstructList);
    }

    public final List<String> clientClusters() {
        return this.clientClusters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeviceTypes() ? this.deviceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusters() ? this.clusters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParts() ? this.parts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSemanticTags() ? this.semanticTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientClusters() ? this.clientClusters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatterCapabilityReportEndpoint)) {
            return false;
        }
        MatterCapabilityReportEndpoint other = (MatterCapabilityReportEndpoint)obj;
        return Objects.equals(this.id(), other.id()) && this.hasDeviceTypes() == other.hasDeviceTypes() && Objects.equals(this.deviceTypes(), other.deviceTypes()) && this.hasClusters() == other.hasClusters() && Objects.equals(this.clusters(), other.clusters()) && this.hasParts() == other.hasParts() && Objects.equals(this.parts(), other.parts()) && this.hasSemanticTags() == other.hasSemanticTags() && Objects.equals(this.semanticTags(), other.semanticTags()) && this.hasClientClusters() == other.hasClientClusters() && Objects.equals(this.clientClusters(), other.clientClusters());
    }

    public final String toString() {
        return ToString.builder((String)"MatterCapabilityReportEndpoint").add("Id", (Object)this.id()).add("DeviceTypes", this.hasDeviceTypes() ? this.deviceTypes() : null).add("Clusters", this.hasClusters() ? this.clusters() : null).add("Parts", this.hasParts() ? this.parts() : null).add("SemanticTags", this.hasSemanticTags() ? this.semanticTags() : null).add("ClientClusters", this.hasClientClusters() ? this.clientClusters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "deviceTypes": {
                return Optional.ofNullable(clazz.cast(this.deviceTypes()));
            }
            case "clusters": {
                return Optional.ofNullable(clazz.cast(this.clusters()));
            }
            case "parts": {
                return Optional.ofNullable(clazz.cast(this.parts()));
            }
            case "semanticTags": {
                return Optional.ofNullable(clazz.cast(this.semanticTags()));
            }
            case "clientClusters": {
                return Optional.ofNullable(clazz.cast(this.clientClusters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("deviceTypes", DEVICE_TYPES_FIELD);
        map.put("clusters", CLUSTERS_FIELD);
        map.put("parts", PARTS_FIELD);
        map.put("semanticTags", SEMANTIC_TAGS_FIELD);
        map.put("clientClusters", CLIENT_CLUSTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MatterCapabilityReportEndpoint, T> g) {
        return obj -> g.apply((MatterCapabilityReportEndpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private List<String> deviceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<MatterCapabilityReportCluster> clusters = DefaultSdkAutoConstructList.getInstance();
        private List<String> parts = DefaultSdkAutoConstructList.getInstance();
        private List<String> semanticTags = DefaultSdkAutoConstructList.getInstance();
        private List<String> clientClusters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MatterCapabilityReportEndpoint model) {
            this.id(model.id);
            this.deviceTypes(model.deviceTypes);
            this.clusters(model.clusters);
            this.parts(model.parts);
            this.semanticTags(model.semanticTags);
            this.clientClusters(model.clientClusters);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Collection<String> getDeviceTypes() {
            if (this.deviceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deviceTypes;
        }

        public final void setDeviceTypes(Collection<String> deviceTypes) {
            this.deviceTypes = DeviceTypesCopier.copy(deviceTypes);
        }

        @Override
        public final Builder deviceTypes(Collection<String> deviceTypes) {
            this.deviceTypes = DeviceTypesCopier.copy(deviceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deviceTypes(String ... deviceTypes) {
            this.deviceTypes(Arrays.asList(deviceTypes));
            return this;
        }

        public final List<MatterCapabilityReportCluster.Builder> getClusters() {
            List<MatterCapabilityReportCluster.Builder> result = MatterCapabilityReportClustersCopier.copyToBuilder(this.clusters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusters(Collection<MatterCapabilityReportCluster.BuilderImpl> clusters) {
            this.clusters = MatterCapabilityReportClustersCopier.copyFromBuilder(clusters);
        }

        @Override
        public final Builder clusters(Collection<MatterCapabilityReportCluster> clusters) {
            this.clusters = MatterCapabilityReportClustersCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(MatterCapabilityReportCluster ... clusters) {
            this.clusters(Arrays.asList(clusters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(Consumer<MatterCapabilityReportCluster.Builder> ... clusters) {
            this.clusters(Stream.of(clusters).map(c -> (MatterCapabilityReportCluster)((MatterCapabilityReportCluster.Builder)MatterCapabilityReportCluster.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getParts() {
            if (this.parts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.parts;
        }

        public final void setParts(Collection<String> parts) {
            this.parts = MatterCapabilityReportEndpointPartsCopier.copy(parts);
        }

        @Override
        public final Builder parts(Collection<String> parts) {
            this.parts = MatterCapabilityReportEndpointPartsCopier.copy(parts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parts(String ... parts) {
            this.parts(Arrays.asList(parts));
            return this;
        }

        public final Collection<String> getSemanticTags() {
            if (this.semanticTags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.semanticTags;
        }

        public final void setSemanticTags(Collection<String> semanticTags) {
            this.semanticTags = MatterCapabilityReportEndpointSemanticTagsCopier.copy(semanticTags);
        }

        @Override
        public final Builder semanticTags(Collection<String> semanticTags) {
            this.semanticTags = MatterCapabilityReportEndpointSemanticTagsCopier.copy(semanticTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder semanticTags(String ... semanticTags) {
            this.semanticTags(Arrays.asList(semanticTags));
            return this;
        }

        public final Collection<String> getClientClusters() {
            if (this.clientClusters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.clientClusters;
        }

        public final void setClientClusters(Collection<String> clientClusters) {
            this.clientClusters = MatterCapabilityReportEndpointClientClustersCopier.copy(clientClusters);
        }

        @Override
        public final Builder clientClusters(Collection<String> clientClusters) {
            this.clientClusters = MatterCapabilityReportEndpointClientClustersCopier.copy(clientClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientClusters(String ... clientClusters) {
            this.clientClusters(Arrays.asList(clientClusters));
            return this;
        }

        public MatterCapabilityReportEndpoint build() {
            return new MatterCapabilityReportEndpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MatterCapabilityReportEndpoint> {
        public Builder id(String var1);

        public Builder deviceTypes(Collection<String> var1);

        public Builder deviceTypes(String ... var1);

        public Builder clusters(Collection<MatterCapabilityReportCluster> var1);

        public Builder clusters(MatterCapabilityReportCluster ... var1);

        public Builder clusters(Consumer<MatterCapabilityReportCluster.Builder> ... var1);

        public Builder parts(Collection<String> var1);

        public Builder parts(String ... var1);

        public Builder semanticTags(Collection<String> var1);

        public Builder semanticTags(String ... var1);

        public Builder clientClusters(Collection<String> var1);

        public Builder clientClusters(String ... var1);
    }
}

