/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.AssociationState;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAccountAssociationResponse
extends IotManagedIntegrationsResponse
implements ToCopyableBuilder<Builder, CreateAccountAssociationResponse> {
    private static final SdkField<String> O_AUTH_AUTHORIZATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OAuthAuthorizationUrl").getter(CreateAccountAssociationResponse.getter(CreateAccountAssociationResponse::oAuthAuthorizationUrl)).setter(CreateAccountAssociationResponse.setter(Builder::oAuthAuthorizationUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuthAuthorizationUrl").build()}).build();
    private static final SdkField<String> ACCOUNT_ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountAssociationId").getter(CreateAccountAssociationResponse.getter(CreateAccountAssociationResponse::accountAssociationId)).setter(CreateAccountAssociationResponse.setter(Builder::accountAssociationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountAssociationId").build()}).build();
    private static final SdkField<String> ASSOCIATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationState").getter(CreateAccountAssociationResponse.getter(CreateAccountAssociationResponse::associationStateAsString)).setter(CreateAccountAssociationResponse.setter(Builder::associationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationState").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(CreateAccountAssociationResponse.getter(CreateAccountAssociationResponse::arn)).setter(CreateAccountAssociationResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(O_AUTH_AUTHORIZATION_URL_FIELD, ACCOUNT_ASSOCIATION_ID_FIELD, ASSOCIATION_STATE_FIELD, ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAccountAssociationResponse.memberNameToFieldInitializer();
    private final String oAuthAuthorizationUrl;
    private final String accountAssociationId;
    private final String associationState;
    private final String arn;

    private CreateAccountAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.oAuthAuthorizationUrl = builder.oAuthAuthorizationUrl;
        this.accountAssociationId = builder.accountAssociationId;
        this.associationState = builder.associationState;
        this.arn = builder.arn;
    }

    public final String oAuthAuthorizationUrl() {
        return this.oAuthAuthorizationUrl;
    }

    public final String accountAssociationId() {
        return this.accountAssociationId;
    }

    public final AssociationState associationState() {
        return AssociationState.fromValue(this.associationState);
    }

    public final String associationStateAsString() {
        return this.associationState;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuthAuthorizationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccountAssociationResponse)) {
            return false;
        }
        CreateAccountAssociationResponse other = (CreateAccountAssociationResponse)((Object)obj);
        return Objects.equals(this.oAuthAuthorizationUrl(), other.oAuthAuthorizationUrl()) && Objects.equals(this.accountAssociationId(), other.accountAssociationId()) && Objects.equals(this.associationStateAsString(), other.associationStateAsString()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAccountAssociationResponse").add("OAuthAuthorizationUrl", (Object)(this.oAuthAuthorizationUrl() == null ? null : "*** Sensitive Data Redacted ***")).add("AccountAssociationId", (Object)this.accountAssociationId()).add("AssociationState", (Object)this.associationStateAsString()).add("Arn", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OAuthAuthorizationUrl": {
                return Optional.ofNullable(clazz.cast(this.oAuthAuthorizationUrl()));
            }
            case "AccountAssociationId": {
                return Optional.ofNullable(clazz.cast(this.accountAssociationId()));
            }
            case "AssociationState": {
                return Optional.ofNullable(clazz.cast(this.associationStateAsString()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("OAuthAuthorizationUrl", O_AUTH_AUTHORIZATION_URL_FIELD);
        map.put("AccountAssociationId", ACCOUNT_ASSOCIATION_ID_FIELD);
        map.put("AssociationState", ASSOCIATION_STATE_FIELD);
        map.put("Arn", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAccountAssociationResponse, T> g) {
        return obj -> g.apply((CreateAccountAssociationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsResponse.BuilderImpl
    implements Builder {
        private String oAuthAuthorizationUrl;
        private String accountAssociationId;
        private String associationState;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccountAssociationResponse model) {
            super(model);
            this.oAuthAuthorizationUrl(model.oAuthAuthorizationUrl);
            this.accountAssociationId(model.accountAssociationId);
            this.associationState(model.associationState);
            this.arn(model.arn);
        }

        public final String getOAuthAuthorizationUrl() {
            return this.oAuthAuthorizationUrl;
        }

        public final void setOAuthAuthorizationUrl(String oAuthAuthorizationUrl) {
            this.oAuthAuthorizationUrl = oAuthAuthorizationUrl;
        }

        @Override
        public final Builder oAuthAuthorizationUrl(String oAuthAuthorizationUrl) {
            this.oAuthAuthorizationUrl = oAuthAuthorizationUrl;
            return this;
        }

        public final String getAccountAssociationId() {
            return this.accountAssociationId;
        }

        public final void setAccountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
        }

        @Override
        public final Builder accountAssociationId(String accountAssociationId) {
            this.accountAssociationId = accountAssociationId;
            return this;
        }

        public final String getAssociationState() {
            return this.associationState;
        }

        public final void setAssociationState(String associationState) {
            this.associationState = associationState;
        }

        @Override
        public final Builder associationState(String associationState) {
            this.associationState = associationState;
            return this;
        }

        @Override
        public final Builder associationState(AssociationState associationState) {
            this.associationState(associationState == null ? null : associationState.toString());
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public CreateAccountAssociationResponse build() {
            return new CreateAccountAssociationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotManagedIntegrationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAccountAssociationResponse> {
        public Builder oAuthAuthorizationUrl(String var1);

        public Builder accountAssociationId(String var1);

        public Builder associationState(String var1);

        public Builder associationState(AssociationState var1);

        public Builder arn(String var1);
    }
}

