/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AuthType {
    OAUTH("OAUTH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AuthType> VALUE_MAP;
    private final String value;

    private AuthType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthType> knownValues() {
        EnumSet<AuthType> knownValues = EnumSet.allOf(AuthType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AuthType.class, AuthType::toString);
    }
}

