/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotjobsdataplane;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.iotjobsdataplane.IotJobsDataPlaneClient;
import software.amazon.awssdk.services.iotjobsdataplane.model.CertificateValidationException;
import software.amazon.awssdk.services.iotjobsdataplane.model.DescribeJobExecutionRequest;
import software.amazon.awssdk.services.iotjobsdataplane.model.DescribeJobExecutionResponse;
import software.amazon.awssdk.services.iotjobsdataplane.model.GetPendingJobExecutionsRequest;
import software.amazon.awssdk.services.iotjobsdataplane.model.GetPendingJobExecutionsResponse;
import software.amazon.awssdk.services.iotjobsdataplane.model.InvalidRequestException;
import software.amazon.awssdk.services.iotjobsdataplane.model.InvalidStateTransitionException;
import software.amazon.awssdk.services.iotjobsdataplane.model.IotJobsDataPlaneException;
import software.amazon.awssdk.services.iotjobsdataplane.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotjobsdataplane.model.ServiceUnavailableException;
import software.amazon.awssdk.services.iotjobsdataplane.model.StartNextPendingJobExecutionRequest;
import software.amazon.awssdk.services.iotjobsdataplane.model.StartNextPendingJobExecutionResponse;
import software.amazon.awssdk.services.iotjobsdataplane.model.TerminalStateException;
import software.amazon.awssdk.services.iotjobsdataplane.model.ThrottlingException;
import software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionRequest;
import software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionResponse;
import software.amazon.awssdk.services.iotjobsdataplane.transform.DescribeJobExecutionRequestMarshaller;
import software.amazon.awssdk.services.iotjobsdataplane.transform.GetPendingJobExecutionsRequestMarshaller;
import software.amazon.awssdk.services.iotjobsdataplane.transform.StartNextPendingJobExecutionRequestMarshaller;
import software.amazon.awssdk.services.iotjobsdataplane.transform.UpdateJobExecutionRequestMarshaller;

@SdkInternalApi
final class DefaultIotJobsDataPlaneClient
implements IotJobsDataPlaneClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultIotJobsDataPlaneClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "iot-jobs-data";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeJobExecutionResponse describeJobExecution(DescribeJobExecutionRequest describeJobExecutionRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, CertificateValidationException, TerminalStateException, AwsServiceException, SdkClientException, IotJobsDataPlaneException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeJobExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIotJobsDataPlaneClient.resolveMetricPublishers(this.clientConfiguration, describeJobExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Jobs Data Plane");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeJobExecution");
            DescribeJobExecutionResponse describeJobExecutionResponse = (DescribeJobExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeJobExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeJobExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeJobExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeJobExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotJobsDataPlaneClient.lambda$describeJobExecution$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPendingJobExecutionsResponse getPendingJobExecutions(GetPendingJobExecutionsRequest getPendingJobExecutionsRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, CertificateValidationException, AwsServiceException, SdkClientException, IotJobsDataPlaneException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPendingJobExecutionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIotJobsDataPlaneClient.resolveMetricPublishers(this.clientConfiguration, getPendingJobExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Jobs Data Plane");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPendingJobExecutions");
            GetPendingJobExecutionsResponse getPendingJobExecutionsResponse = (GetPendingJobExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPendingJobExecutions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPendingJobExecutionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPendingJobExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPendingJobExecutionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotJobsDataPlaneClient.lambda$getPendingJobExecutions$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartNextPendingJobExecutionResponse startNextPendingJobExecution(StartNextPendingJobExecutionRequest startNextPendingJobExecutionRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, CertificateValidationException, AwsServiceException, SdkClientException, IotJobsDataPlaneException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartNextPendingJobExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIotJobsDataPlaneClient.resolveMetricPublishers(this.clientConfiguration, startNextPendingJobExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Jobs Data Plane");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartNextPendingJobExecution");
            StartNextPendingJobExecutionResponse startNextPendingJobExecutionResponse = (StartNextPendingJobExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartNextPendingJobExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startNextPendingJobExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartNextPendingJobExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startNextPendingJobExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotJobsDataPlaneClient.lambda$startNextPendingJobExecution$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateJobExecutionResponse updateJobExecution(UpdateJobExecutionRequest updateJobExecutionRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, CertificateValidationException, InvalidStateTransitionException, AwsServiceException, SdkClientException, IotJobsDataPlaneException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateJobExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultIotJobsDataPlaneClient.resolveMetricPublishers(this.clientConfiguration, updateJobExecutionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IoT Jobs Data Plane");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateJobExecution");
            UpdateJobExecutionResponse updateJobExecutionResponse = (UpdateJobExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateJobExecution").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateJobExecutionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateJobExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateJobExecutionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultIotJobsDataPlaneClient.lambda$updateJobExecution$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(IotJobsDataPlaneException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").exceptionBuilderSupplier(InvalidStateTransitionException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TerminalStateException").exceptionBuilderSupplier(TerminalStateException::builder).httpStatusCode(Integer.valueOf(410)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(Integer.valueOf(503)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CertificateValidationException").exceptionBuilderSupplier(CertificateValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateJobExecution$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startNextPendingJobExecution$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPendingJobExecutions$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeJobExecution$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

