/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotjobsdataplane.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.iotjobsdataplane.model.DetailsMapCopier;
import software.amazon.awssdk.services.iotjobsdataplane.model.IotJobsDataPlaneRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartNextPendingJobExecutionRequest
extends IotJobsDataPlaneRequest
implements ToCopyableBuilder<Builder, StartNextPendingJobExecutionRequest> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartNextPendingJobExecutionRequest.getter(StartNextPendingJobExecutionRequest::thingName)).setter(StartNextPendingJobExecutionRequest.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("thingName").build()}).build();
    private static final SdkField<Map<String, String>> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(StartNextPendingJobExecutionRequest.getter(StartNextPendingJobExecutionRequest::statusDetails)).setter(StartNextPendingJobExecutionRequest.setter(Builder::statusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusDetails").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Long> STEP_TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(StartNextPendingJobExecutionRequest.getter(StartNextPendingJobExecutionRequest::stepTimeoutInMinutes)).setter(StartNextPendingJobExecutionRequest.setter(Builder::stepTimeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepTimeoutInMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD, STATUS_DETAILS_FIELD, STEP_TIMEOUT_IN_MINUTES_FIELD));
    private final String thingName;
    private final Map<String, String> statusDetails;
    private final Long stepTimeoutInMinutes;

    private StartNextPendingJobExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.statusDetails = builder.statusDetails;
        this.stepTimeoutInMinutes = builder.stepTimeoutInMinutes;
    }

    public String thingName() {
        return this.thingName;
    }

    public Map<String, String> statusDetails() {
        return this.statusDetails;
    }

    public Long stepTimeoutInMinutes() {
        return this.stepTimeoutInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepTimeoutInMinutes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartNextPendingJobExecutionRequest)) {
            return false;
        }
        StartNextPendingJobExecutionRequest other = (StartNextPendingJobExecutionRequest)((Object)obj);
        return Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.stepTimeoutInMinutes(), other.stepTimeoutInMinutes());
    }

    public String toString() {
        return ToString.builder((String)"StartNextPendingJobExecutionRequest").add("ThingName", (Object)this.thingName()).add("StatusDetails", this.statusDetails()).add("StepTimeoutInMinutes", (Object)this.stepTimeoutInMinutes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "statusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "stepTimeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.stepTimeoutInMinutes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartNextPendingJobExecutionRequest, T> g) {
        return obj -> g.apply((StartNextPendingJobExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotJobsDataPlaneRequest.BuilderImpl
    implements Builder {
        private String thingName;
        private Map<String, String> statusDetails = DefaultSdkAutoConstructMap.getInstance();
        private Long stepTimeoutInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(StartNextPendingJobExecutionRequest model) {
            super(model);
            this.thingName(model.thingName);
            this.statusDetails(model.statusDetails);
            this.stepTimeoutInMinutes(model.stepTimeoutInMinutes);
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final Map<String, String> getStatusDetails() {
            return this.statusDetails;
        }

        @Override
        public final Builder statusDetails(Map<String, String> statusDetails) {
            this.statusDetails = DetailsMapCopier.copy(statusDetails);
            return this;
        }

        public final void setStatusDetails(Map<String, String> statusDetails) {
            this.statusDetails = DetailsMapCopier.copy(statusDetails);
        }

        public final Long getStepTimeoutInMinutes() {
            return this.stepTimeoutInMinutes;
        }

        @Override
        public final Builder stepTimeoutInMinutes(Long stepTimeoutInMinutes) {
            this.stepTimeoutInMinutes = stepTimeoutInMinutes;
            return this;
        }

        public final void setStepTimeoutInMinutes(Long stepTimeoutInMinutes) {
            this.stepTimeoutInMinutes = stepTimeoutInMinutes;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartNextPendingJobExecutionRequest build() {
            return new StartNextPendingJobExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotJobsDataPlaneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartNextPendingJobExecutionRequest> {
        public Builder thingName(String var1);

        public Builder statusDetails(Map<String, String> var1);

        public Builder stepTimeoutInMinutes(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

