/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotjobsdataplane;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.iotjobsdataplane.IotJobsDataPlaneClient;
import software.amazon.awssdk.services.iotjobsdataplane.model.CertificateValidationException;
import software.amazon.awssdk.services.iotjobsdataplane.model.DescribeJobExecutionRequest;
import software.amazon.awssdk.services.iotjobsdataplane.model.DescribeJobExecutionResponse;
import software.amazon.awssdk.services.iotjobsdataplane.model.GetPendingJobExecutionsRequest;
import software.amazon.awssdk.services.iotjobsdataplane.model.GetPendingJobExecutionsResponse;
import software.amazon.awssdk.services.iotjobsdataplane.model.InvalidRequestException;
import software.amazon.awssdk.services.iotjobsdataplane.model.InvalidStateTransitionException;
import software.amazon.awssdk.services.iotjobsdataplane.model.IotJobsDataPlaneException;
import software.amazon.awssdk.services.iotjobsdataplane.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotjobsdataplane.model.ServiceUnavailableException;
import software.amazon.awssdk.services.iotjobsdataplane.model.StartNextPendingJobExecutionRequest;
import software.amazon.awssdk.services.iotjobsdataplane.model.StartNextPendingJobExecutionResponse;
import software.amazon.awssdk.services.iotjobsdataplane.model.TerminalStateException;
import software.amazon.awssdk.services.iotjobsdataplane.model.ThrottlingException;
import software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionRequest;
import software.amazon.awssdk.services.iotjobsdataplane.model.UpdateJobExecutionResponse;
import software.amazon.awssdk.services.iotjobsdataplane.transform.DescribeJobExecutionRequestMarshaller;
import software.amazon.awssdk.services.iotjobsdataplane.transform.GetPendingJobExecutionsRequestMarshaller;
import software.amazon.awssdk.services.iotjobsdataplane.transform.StartNextPendingJobExecutionRequestMarshaller;
import software.amazon.awssdk.services.iotjobsdataplane.transform.UpdateJobExecutionRequestMarshaller;

@SdkInternalApi
final class DefaultIotJobsDataPlaneClient
implements IotJobsDataPlaneClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultIotJobsDataPlaneClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "iot-jobs-data";
    }

    @Override
    public DescribeJobExecutionResponse describeJobExecution(DescribeJobExecutionRequest describeJobExecutionRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, CertificateValidationException, TerminalStateException, AwsServiceException, SdkClientException, IotJobsDataPlaneException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeJobExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DescribeJobExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeJobExecutionRequest).withMarshaller((Marshaller)new DescribeJobExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetPendingJobExecutionsResponse getPendingJobExecutions(GetPendingJobExecutionsRequest getPendingJobExecutionsRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, CertificateValidationException, AwsServiceException, SdkClientException, IotJobsDataPlaneException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPendingJobExecutionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetPendingJobExecutionsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getPendingJobExecutionsRequest).withMarshaller((Marshaller)new GetPendingJobExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public StartNextPendingJobExecutionResponse startNextPendingJobExecution(StartNextPendingJobExecutionRequest startNextPendingJobExecutionRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, CertificateValidationException, AwsServiceException, SdkClientException, IotJobsDataPlaneException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartNextPendingJobExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (StartNextPendingJobExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startNextPendingJobExecutionRequest).withMarshaller((Marshaller)new StartNextPendingJobExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateJobExecutionResponse updateJobExecution(UpdateJobExecutionRequest updateJobExecutionRequest) throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, CertificateValidationException, InvalidStateTransitionException, AwsServiceException, SdkClientException, IotJobsDataPlaneException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateJobExecutionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateJobExecutionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateJobExecutionRequest).withMarshaller((Marshaller)new UpdateJobExecutionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(IotJobsDataPlaneException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("InvalidStateTransitionException").exceptionBuilderSupplier(InvalidStateTransitionException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TerminalStateException").exceptionBuilderSupplier(TerminalStateException::builder).httpStatusCode(Integer.valueOf(410)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").exceptionBuilderSupplier(ServiceUnavailableException::builder).httpStatusCode(Integer.valueOf(503)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRequestException").exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CertificateValidationException").exceptionBuilderSupplier(CertificateValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

