/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VehicleState {
    CREATED("CREATED"),
    READY("READY"),
    HEALTHY("HEALTHY"),
    SUSPENDED("SUSPENDED"),
    DELETING("DELETING"),
    READY_FOR_CHECKIN("READY_FOR_CHECKIN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VehicleState> VALUE_MAP;
    private final String value;

    private VehicleState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VehicleState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VehicleState> knownValues() {
        EnumSet<VehicleState> knownValues = EnumSet.allOf(VehicleState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VehicleState.class, VehicleState::toString);
    }
}

