/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotfleetwise.model.ConditionBasedCollectionScheme;
import software.amazon.awssdk.services.iotfleetwise.model.TimeBasedCollectionScheme;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CollectionScheme
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CollectionScheme> {
    private static final SdkField<TimeBasedCollectionScheme> TIME_BASED_COLLECTION_SCHEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeBasedCollectionScheme").getter(CollectionScheme.getter(CollectionScheme::timeBasedCollectionScheme)).setter(CollectionScheme.setter(Builder::timeBasedCollectionScheme)).constructor(TimeBasedCollectionScheme::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeBasedCollectionScheme").build()}).build();
    private static final SdkField<ConditionBasedCollectionScheme> CONDITION_BASED_COLLECTION_SCHEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("conditionBasedCollectionScheme").getter(CollectionScheme.getter(CollectionScheme::conditionBasedCollectionScheme)).setter(CollectionScheme.setter(Builder::conditionBasedCollectionScheme)).constructor(ConditionBasedCollectionScheme::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionBasedCollectionScheme").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_BASED_COLLECTION_SCHEME_FIELD, CONDITION_BASED_COLLECTION_SCHEME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CollectionScheme.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final TimeBasedCollectionScheme timeBasedCollectionScheme;
    private final ConditionBasedCollectionScheme conditionBasedCollectionScheme;
    private final Type type;

    private CollectionScheme(BuilderImpl builder) {
        this.timeBasedCollectionScheme = builder.timeBasedCollectionScheme;
        this.conditionBasedCollectionScheme = builder.conditionBasedCollectionScheme;
        this.type = builder.type;
    }

    public final TimeBasedCollectionScheme timeBasedCollectionScheme() {
        return this.timeBasedCollectionScheme;
    }

    public final ConditionBasedCollectionScheme conditionBasedCollectionScheme() {
        return this.conditionBasedCollectionScheme;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeBasedCollectionScheme());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionBasedCollectionScheme());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollectionScheme)) {
            return false;
        }
        CollectionScheme other = (CollectionScheme)obj;
        return Objects.equals(this.timeBasedCollectionScheme(), other.timeBasedCollectionScheme()) && Objects.equals(this.conditionBasedCollectionScheme(), other.conditionBasedCollectionScheme());
    }

    public final String toString() {
        return ToString.builder((String)"CollectionScheme").add("TimeBasedCollectionScheme", (Object)this.timeBasedCollectionScheme()).add("ConditionBasedCollectionScheme", (Object)this.conditionBasedCollectionScheme()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "timeBasedCollectionScheme": {
                return Optional.ofNullable(clazz.cast(this.timeBasedCollectionScheme()));
            }
            case "conditionBasedCollectionScheme": {
                return Optional.ofNullable(clazz.cast(this.conditionBasedCollectionScheme()));
            }
        }
        return Optional.empty();
    }

    public static CollectionScheme fromTimeBasedCollectionScheme(TimeBasedCollectionScheme timeBasedCollectionScheme) {
        return (CollectionScheme)CollectionScheme.builder().timeBasedCollectionScheme(timeBasedCollectionScheme).build();
    }

    public static CollectionScheme fromTimeBasedCollectionScheme(Consumer<TimeBasedCollectionScheme.Builder> timeBasedCollectionScheme) {
        TimeBasedCollectionScheme.Builder builder = TimeBasedCollectionScheme.builder();
        timeBasedCollectionScheme.accept(builder);
        return CollectionScheme.fromTimeBasedCollectionScheme((TimeBasedCollectionScheme)builder.build());
    }

    public static CollectionScheme fromConditionBasedCollectionScheme(ConditionBasedCollectionScheme conditionBasedCollectionScheme) {
        return (CollectionScheme)CollectionScheme.builder().conditionBasedCollectionScheme(conditionBasedCollectionScheme).build();
    }

    public static CollectionScheme fromConditionBasedCollectionScheme(Consumer<ConditionBasedCollectionScheme.Builder> conditionBasedCollectionScheme) {
        ConditionBasedCollectionScheme.Builder builder = ConditionBasedCollectionScheme.builder();
        conditionBasedCollectionScheme.accept(builder);
        return CollectionScheme.fromConditionBasedCollectionScheme((ConditionBasedCollectionScheme)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("timeBasedCollectionScheme", TIME_BASED_COLLECTION_SCHEME_FIELD);
        map.put("conditionBasedCollectionScheme", CONDITION_BASED_COLLECTION_SCHEME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CollectionScheme, T> g) {
        return obj -> g.apply((CollectionScheme)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TIME_BASED_COLLECTION_SCHEME,
        CONDITION_BASED_COLLECTION_SCHEME,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private TimeBasedCollectionScheme timeBasedCollectionScheme;
        private ConditionBasedCollectionScheme conditionBasedCollectionScheme;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CollectionScheme model) {
            this.timeBasedCollectionScheme(model.timeBasedCollectionScheme);
            this.conditionBasedCollectionScheme(model.conditionBasedCollectionScheme);
        }

        public final TimeBasedCollectionScheme.Builder getTimeBasedCollectionScheme() {
            return this.timeBasedCollectionScheme != null ? this.timeBasedCollectionScheme.toBuilder() : null;
        }

        public final void setTimeBasedCollectionScheme(TimeBasedCollectionScheme.BuilderImpl timeBasedCollectionScheme) {
            TimeBasedCollectionScheme oldValue = this.timeBasedCollectionScheme;
            this.timeBasedCollectionScheme = timeBasedCollectionScheme != null ? timeBasedCollectionScheme.build() : null;
            this.handleUnionValueChange(Type.TIME_BASED_COLLECTION_SCHEME, oldValue, this.timeBasedCollectionScheme);
        }

        @Override
        public final Builder timeBasedCollectionScheme(TimeBasedCollectionScheme timeBasedCollectionScheme) {
            TimeBasedCollectionScheme oldValue = this.timeBasedCollectionScheme;
            this.timeBasedCollectionScheme = timeBasedCollectionScheme;
            this.handleUnionValueChange(Type.TIME_BASED_COLLECTION_SCHEME, oldValue, this.timeBasedCollectionScheme);
            return this;
        }

        public final ConditionBasedCollectionScheme.Builder getConditionBasedCollectionScheme() {
            return this.conditionBasedCollectionScheme != null ? this.conditionBasedCollectionScheme.toBuilder() : null;
        }

        public final void setConditionBasedCollectionScheme(ConditionBasedCollectionScheme.BuilderImpl conditionBasedCollectionScheme) {
            ConditionBasedCollectionScheme oldValue = this.conditionBasedCollectionScheme;
            this.conditionBasedCollectionScheme = conditionBasedCollectionScheme != null ? conditionBasedCollectionScheme.build() : null;
            this.handleUnionValueChange(Type.CONDITION_BASED_COLLECTION_SCHEME, oldValue, this.conditionBasedCollectionScheme);
        }

        @Override
        public final Builder conditionBasedCollectionScheme(ConditionBasedCollectionScheme conditionBasedCollectionScheme) {
            ConditionBasedCollectionScheme oldValue = this.conditionBasedCollectionScheme;
            this.conditionBasedCollectionScheme = conditionBasedCollectionScheme;
            this.handleUnionValueChange(Type.CONDITION_BASED_COLLECTION_SCHEME, oldValue, this.conditionBasedCollectionScheme);
            return this;
        }

        public CollectionScheme build() {
            return new CollectionScheme(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CollectionScheme> {
        public Builder timeBasedCollectionScheme(TimeBasedCollectionScheme var1);

        default public Builder timeBasedCollectionScheme(Consumer<TimeBasedCollectionScheme.Builder> timeBasedCollectionScheme) {
            return this.timeBasedCollectionScheme((TimeBasedCollectionScheme)((TimeBasedCollectionScheme.Builder)TimeBasedCollectionScheme.builder().applyMutation(timeBasedCollectionScheme)).build());
        }

        public Builder conditionBasedCollectionScheme(ConditionBasedCollectionScheme var1);

        default public Builder conditionBasedCollectionScheme(Consumer<ConditionBasedCollectionScheme.Builder> conditionBasedCollectionScheme) {
            return this.conditionBasedCollectionScheme((ConditionBasedCollectionScheme)((ConditionBasedCollectionScheme.Builder)ConditionBasedCollectionScheme.builder().applyMutation(conditionBasedCollectionScheme)).build());
        }
    }
}

