/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.BytesWrapper;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotfleetwise.model.ModelSignalsMapCopier;
import software.amazon.awssdk.services.iotfleetwise.model.NetworkFilesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CanDbcDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CanDbcDefinition> {
    private static final SdkField<String> NETWORK_INTERFACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("networkInterface").getter(CanDbcDefinition.getter(CanDbcDefinition::networkInterface)).setter(CanDbcDefinition.setter(Builder::networkInterface)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterface").build()}).build();
    private static final SdkField<List<SdkBytes>> CAN_DBC_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("canDbcFiles").getter(CanDbcDefinition.getter(CanDbcDefinition::canDbcFiles)).setter(CanDbcDefinition.setter(Builder::canDbcFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canDbcFiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> SIGNALS_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("signalsMap").getter(CanDbcDefinition.getter(CanDbcDefinition::signalsMap)).setter(CanDbcDefinition.setter(Builder::signalsMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalsMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_FIELD, CAN_DBC_FILES_FIELD, SIGNALS_MAP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CanDbcDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String networkInterface;
    private final List<SdkBytes> canDbcFiles;
    private final Map<String, String> signalsMap;

    private CanDbcDefinition(BuilderImpl builder) {
        this.networkInterface = builder.networkInterface;
        this.canDbcFiles = builder.canDbcFiles;
        this.signalsMap = builder.signalsMap;
    }

    public final String networkInterface() {
        return this.networkInterface;
    }

    public final boolean hasCanDbcFiles() {
        return this.canDbcFiles != null && !(this.canDbcFiles instanceof SdkAutoConstructList);
    }

    public final List<SdkBytes> canDbcFiles() {
        return this.canDbcFiles;
    }

    public final boolean hasSignalsMap() {
        return this.signalsMap != null && !(this.signalsMap instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> signalsMap() {
        return this.signalsMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterface());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCanDbcFiles() ? this.canDbcFiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSignalsMap() ? this.signalsMap() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanDbcDefinition)) {
            return false;
        }
        CanDbcDefinition other = (CanDbcDefinition)obj;
        return Objects.equals(this.networkInterface(), other.networkInterface()) && this.hasCanDbcFiles() == other.hasCanDbcFiles() && Objects.equals(this.canDbcFiles(), other.canDbcFiles()) && this.hasSignalsMap() == other.hasSignalsMap() && Objects.equals(this.signalsMap(), other.signalsMap());
    }

    public final String toString() {
        return ToString.builder((String)"CanDbcDefinition").add("NetworkInterface", (Object)this.networkInterface()).add("CanDbcFiles", this.hasCanDbcFiles() ? this.canDbcFiles() : null).add("SignalsMap", this.hasSignalsMap() ? this.signalsMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkInterface": {
                return Optional.ofNullable(clazz.cast(this.networkInterface()));
            }
            case "canDbcFiles": {
                return Optional.ofNullable(clazz.cast(this.canDbcFiles()));
            }
            case "signalsMap": {
                return Optional.ofNullable(clazz.cast(this.signalsMap()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("networkInterface", NETWORK_INTERFACE_FIELD);
        map.put("canDbcFiles", CAN_DBC_FILES_FIELD);
        map.put("signalsMap", SIGNALS_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CanDbcDefinition, T> g) {
        return obj -> g.apply((CanDbcDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkInterface;
        private List<SdkBytes> canDbcFiles = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> signalsMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CanDbcDefinition model) {
            this.networkInterface(model.networkInterface);
            this.canDbcFiles(model.canDbcFiles);
            this.signalsMap(model.signalsMap);
        }

        public final String getNetworkInterface() {
            return this.networkInterface;
        }

        public final void setNetworkInterface(String networkInterface) {
            this.networkInterface = networkInterface;
        }

        @Override
        public final Builder networkInterface(String networkInterface) {
            this.networkInterface = networkInterface;
            return this;
        }

        public final List<ByteBuffer> getCanDbcFiles() {
            if (this.canDbcFiles instanceof SdkAutoConstructList) {
                return null;
            }
            return this.canDbcFiles == null ? null : this.canDbcFiles.stream().map(BytesWrapper::asByteBuffer).collect(Collectors.toList());
        }

        public final void setCanDbcFiles(Collection<ByteBuffer> canDbcFiles) {
            this.canDbcFiles(canDbcFiles == null ? null : (Collection)canDbcFiles.stream().map(SdkBytes::fromByteBuffer).collect(Collectors.toList()));
        }

        @Override
        public final Builder canDbcFiles(Collection<SdkBytes> canDbcFiles) {
            this.canDbcFiles = NetworkFilesListCopier.copy(canDbcFiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder canDbcFiles(SdkBytes ... canDbcFiles) {
            this.canDbcFiles(Arrays.asList(canDbcFiles));
            return this;
        }

        public final Map<String, String> getSignalsMap() {
            if (this.signalsMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.signalsMap;
        }

        public final void setSignalsMap(Map<String, String> signalsMap) {
            this.signalsMap = ModelSignalsMapCopier.copy(signalsMap);
        }

        @Override
        public final Builder signalsMap(Map<String, String> signalsMap) {
            this.signalsMap = ModelSignalsMapCopier.copy(signalsMap);
            return this;
        }

        public CanDbcDefinition build() {
            return new CanDbcDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CanDbcDefinition> {
        public Builder networkInterface(String var1);

        public Builder canDbcFiles(Collection<SdkBytes> var1);

        public Builder canDbcFiles(SdkBytes ... var1);

        public Builder signalsMap(Map<String, String> var1);
    }
}

