/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleError;
import software.amazon.awssdk.services.iotfleetwise.model.CreateVehicleResponseItem;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseResponse;
import software.amazon.awssdk.services.iotfleetwise.model._createVehicleErrorsCopier;
import software.amazon.awssdk.services.iotfleetwise.model._createVehicleResponsesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCreateVehicleResponse
extends IoTFleetWiseResponse
implements ToCopyableBuilder<Builder, BatchCreateVehicleResponse> {
    private static final SdkField<List<CreateVehicleResponseItem>> VEHICLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vehicles").getter(BatchCreateVehicleResponse.getter(BatchCreateVehicleResponse::vehicles)).setter(BatchCreateVehicleResponse.setter(Builder::vehicles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vehicles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateVehicleResponseItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CreateVehicleError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchCreateVehicleResponse.getter(BatchCreateVehicleResponse::errors)).setter(BatchCreateVehicleResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CreateVehicleError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VEHICLES_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchCreateVehicleResponse.memberNameToFieldInitializer();
    private final List<CreateVehicleResponseItem> vehicles;
    private final List<CreateVehicleError> errors;

    private BatchCreateVehicleResponse(BuilderImpl builder) {
        super(builder);
        this.vehicles = builder.vehicles;
        this.errors = builder.errors;
    }

    public final boolean hasVehicles() {
        return this.vehicles != null && !(this.vehicles instanceof SdkAutoConstructList);
    }

    public final List<CreateVehicleResponseItem> vehicles() {
        return this.vehicles;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<CreateVehicleError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVehicles() ? this.vehicles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateVehicleResponse)) {
            return false;
        }
        BatchCreateVehicleResponse other = (BatchCreateVehicleResponse)((Object)obj);
        return this.hasVehicles() == other.hasVehicles() && Objects.equals(this.vehicles(), other.vehicles()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchCreateVehicleResponse").add("Vehicles", this.hasVehicles() ? this.vehicles() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vehicles": {
                return Optional.ofNullable(clazz.cast(this.vehicles()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vehicles", VEHICLES_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateVehicleResponse, T> g) {
        return obj -> g.apply((BatchCreateVehicleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseResponse.BuilderImpl
    implements Builder {
        private List<CreateVehicleResponseItem> vehicles = DefaultSdkAutoConstructList.getInstance();
        private List<CreateVehicleError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateVehicleResponse model) {
            super(model);
            this.vehicles(model.vehicles);
            this.errors(model.errors);
        }

        public final List<CreateVehicleResponseItem.Builder> getVehicles() {
            List<CreateVehicleResponseItem.Builder> result = _createVehicleResponsesCopier.copyToBuilder(this.vehicles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVehicles(Collection<CreateVehicleResponseItem.BuilderImpl> vehicles) {
            this.vehicles = _createVehicleResponsesCopier.copyFromBuilder(vehicles);
        }

        @Override
        public final Builder vehicles(Collection<CreateVehicleResponseItem> vehicles) {
            this.vehicles = _createVehicleResponsesCopier.copy(vehicles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vehicles(CreateVehicleResponseItem ... vehicles) {
            this.vehicles(Arrays.asList(vehicles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vehicles(Consumer<CreateVehicleResponseItem.Builder> ... vehicles) {
            this.vehicles(Stream.of(vehicles).map(c -> (CreateVehicleResponseItem)((CreateVehicleResponseItem.Builder)CreateVehicleResponseItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CreateVehicleError.Builder> getErrors() {
            List<CreateVehicleError.Builder> result = _createVehicleErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<CreateVehicleError.BuilderImpl> errors) {
            this.errors = _createVehicleErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<CreateVehicleError> errors) {
            this.errors = _createVehicleErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(CreateVehicleError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<CreateVehicleError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (CreateVehicleError)((CreateVehicleError.Builder)CreateVehicleError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchCreateVehicleResponse build() {
            return new BatchCreateVehicleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTFleetWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchCreateVehicleResponse> {
        public Builder vehicles(Collection<CreateVehicleResponseItem> var1);

        public Builder vehicles(CreateVehicleResponseItem ... var1);

        public Builder vehicles(Consumer<CreateVehicleResponseItem.Builder> ... var1);

        public Builder errors(Collection<CreateVehicleError> var1);

        public Builder errors(CreateVehicleError ... var1);

        public Builder errors(Consumer<CreateVehicleError.Builder> ... var1);
    }
}

