/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotfleetwise.model.TriggerMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConditionBasedCollectionScheme
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConditionBasedCollectionScheme> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("expression").getter(ConditionBasedCollectionScheme.getter(ConditionBasedCollectionScheme::expression)).setter(ConditionBasedCollectionScheme.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()}).build();
    private static final SdkField<Long> MINIMUM_TRIGGER_INTERVAL_MS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("minimumTriggerIntervalMs").getter(ConditionBasedCollectionScheme.getter(ConditionBasedCollectionScheme::minimumTriggerIntervalMs)).setter(ConditionBasedCollectionScheme.setter(Builder::minimumTriggerIntervalMs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumTriggerIntervalMs").build()}).build();
    private static final SdkField<String> TRIGGER_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("triggerMode").getter(ConditionBasedCollectionScheme.getter(ConditionBasedCollectionScheme::triggerModeAsString)).setter(ConditionBasedCollectionScheme.setter(Builder::triggerMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerMode").build()}).build();
    private static final SdkField<Integer> CONDITION_LANGUAGE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("conditionLanguageVersion").getter(ConditionBasedCollectionScheme.getter(ConditionBasedCollectionScheme::conditionLanguageVersion)).setter(ConditionBasedCollectionScheme.setter(Builder::conditionLanguageVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditionLanguageVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD, MINIMUM_TRIGGER_INTERVAL_MS_FIELD, TRIGGER_MODE_FIELD, CONDITION_LANGUAGE_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String expression;
    private final Long minimumTriggerIntervalMs;
    private final String triggerMode;
    private final Integer conditionLanguageVersion;

    private ConditionBasedCollectionScheme(BuilderImpl builder) {
        this.expression = builder.expression;
        this.minimumTriggerIntervalMs = builder.minimumTriggerIntervalMs;
        this.triggerMode = builder.triggerMode;
        this.conditionLanguageVersion = builder.conditionLanguageVersion;
    }

    public final String expression() {
        return this.expression;
    }

    public final Long minimumTriggerIntervalMs() {
        return this.minimumTriggerIntervalMs;
    }

    public final TriggerMode triggerMode() {
        return TriggerMode.fromValue(this.triggerMode);
    }

    public final String triggerModeAsString() {
        return this.triggerMode;
    }

    public final Integer conditionLanguageVersion() {
        return this.conditionLanguageVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumTriggerIntervalMs());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionLanguageVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionBasedCollectionScheme)) {
            return false;
        }
        ConditionBasedCollectionScheme other = (ConditionBasedCollectionScheme)obj;
        return Objects.equals(this.expression(), other.expression()) && Objects.equals(this.minimumTriggerIntervalMs(), other.minimumTriggerIntervalMs()) && Objects.equals(this.triggerModeAsString(), other.triggerModeAsString()) && Objects.equals(this.conditionLanguageVersion(), other.conditionLanguageVersion());
    }

    public final String toString() {
        return ToString.builder((String)"ConditionBasedCollectionScheme").add("Expression", (Object)(this.expression() == null ? null : "*** Sensitive Data Redacted ***")).add("MinimumTriggerIntervalMs", (Object)this.minimumTriggerIntervalMs()).add("TriggerMode", (Object)this.triggerModeAsString()).add("ConditionLanguageVersion", (Object)this.conditionLanguageVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "minimumTriggerIntervalMs": {
                return Optional.ofNullable(clazz.cast(this.minimumTriggerIntervalMs()));
            }
            case "triggerMode": {
                return Optional.ofNullable(clazz.cast(this.triggerModeAsString()));
            }
            case "conditionLanguageVersion": {
                return Optional.ofNullable(clazz.cast(this.conditionLanguageVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConditionBasedCollectionScheme, T> g) {
        return obj -> g.apply((ConditionBasedCollectionScheme)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String expression;
        private Long minimumTriggerIntervalMs;
        private String triggerMode;
        private Integer conditionLanguageVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionBasedCollectionScheme model) {
            this.expression(model.expression);
            this.minimumTriggerIntervalMs(model.minimumTriggerIntervalMs);
            this.triggerMode(model.triggerMode);
            this.conditionLanguageVersion(model.conditionLanguageVersion);
        }

        public final String getExpression() {
            return this.expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final Long getMinimumTriggerIntervalMs() {
            return this.minimumTriggerIntervalMs;
        }

        public final void setMinimumTriggerIntervalMs(Long minimumTriggerIntervalMs) {
            this.minimumTriggerIntervalMs = minimumTriggerIntervalMs;
        }

        @Override
        public final Builder minimumTriggerIntervalMs(Long minimumTriggerIntervalMs) {
            this.minimumTriggerIntervalMs = minimumTriggerIntervalMs;
            return this;
        }

        public final String getTriggerMode() {
            return this.triggerMode;
        }

        public final void setTriggerMode(String triggerMode) {
            this.triggerMode = triggerMode;
        }

        @Override
        public final Builder triggerMode(String triggerMode) {
            this.triggerMode = triggerMode;
            return this;
        }

        @Override
        public final Builder triggerMode(TriggerMode triggerMode) {
            this.triggerMode(triggerMode == null ? null : triggerMode.toString());
            return this;
        }

        public final Integer getConditionLanguageVersion() {
            return this.conditionLanguageVersion;
        }

        public final void setConditionLanguageVersion(Integer conditionLanguageVersion) {
            this.conditionLanguageVersion = conditionLanguageVersion;
        }

        @Override
        public final Builder conditionLanguageVersion(Integer conditionLanguageVersion) {
            this.conditionLanguageVersion = conditionLanguageVersion;
            return this;
        }

        public ConditionBasedCollectionScheme build() {
            return new ConditionBasedCollectionScheme(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConditionBasedCollectionScheme> {
        public Builder expression(String var1);

        public Builder minimumTriggerIntervalMs(Long var1);

        public Builder triggerMode(String var1);

        public Builder triggerMode(TriggerMode var1);

        public Builder conditionLanguageVersion(Integer var1);
    }
}

