/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.DefaultForUnmappedSignalsType;
import software.amazon.awssdk.services.iotfleetwise.model.FqnsCopier;
import software.amazon.awssdk.services.iotfleetwise.model.InterfaceIdsCopier;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ManifestStatus;
import software.amazon.awssdk.services.iotfleetwise.model.NetworkInterface;
import software.amazon.awssdk.services.iotfleetwise.model.NetworkInterfacesCopier;
import software.amazon.awssdk.services.iotfleetwise.model.SignalDecoder;
import software.amazon.awssdk.services.iotfleetwise.model.SignalDecodersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDecoderManifestRequest
extends IoTFleetWiseRequest
implements ToCopyableBuilder<Builder, UpdateDecoderManifestRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateDecoderManifestRequest.getter(UpdateDecoderManifestRequest::name)).setter(UpdateDecoderManifestRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateDecoderManifestRequest.getter(UpdateDecoderManifestRequest::description)).setter(UpdateDecoderManifestRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<SignalDecoder>> SIGNAL_DECODERS_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("signalDecodersToAdd").getter(UpdateDecoderManifestRequest.getter(UpdateDecoderManifestRequest::signalDecodersToAdd)).setter(UpdateDecoderManifestRequest.setter(Builder::signalDecodersToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalDecodersToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SignalDecoder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SignalDecoder>> SIGNAL_DECODERS_TO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("signalDecodersToUpdate").getter(UpdateDecoderManifestRequest.getter(UpdateDecoderManifestRequest::signalDecodersToUpdate)).setter(UpdateDecoderManifestRequest.setter(Builder::signalDecodersToUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalDecodersToUpdate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SignalDecoder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SIGNAL_DECODERS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("signalDecodersToRemove").getter(UpdateDecoderManifestRequest.getter(UpdateDecoderManifestRequest::signalDecodersToRemove)).setter(UpdateDecoderManifestRequest.setter(Builder::signalDecodersToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signalDecodersToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<NetworkInterface>> NETWORK_INTERFACES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("networkInterfacesToAdd").getter(UpdateDecoderManifestRequest.getter(UpdateDecoderManifestRequest::networkInterfacesToAdd)).setter(UpdateDecoderManifestRequest.setter(Builder::networkInterfacesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfacesToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<NetworkInterface>> NETWORK_INTERFACES_TO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("networkInterfacesToUpdate").getter(UpdateDecoderManifestRequest.getter(UpdateDecoderManifestRequest::networkInterfacesToUpdate)).setter(UpdateDecoderManifestRequest.setter(Builder::networkInterfacesToUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfacesToUpdate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NETWORK_INTERFACES_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("networkInterfacesToRemove").getter(UpdateDecoderManifestRequest.getter(UpdateDecoderManifestRequest::networkInterfacesToRemove)).setter(UpdateDecoderManifestRequest.setter(Builder::networkInterfacesToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfacesToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateDecoderManifestRequest.getter(UpdateDecoderManifestRequest::statusAsString)).setter(UpdateDecoderManifestRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> DEFAULT_FOR_UNMAPPED_SIGNALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultForUnmappedSignals").getter(UpdateDecoderManifestRequest.getter(UpdateDecoderManifestRequest::defaultForUnmappedSignalsAsString)).setter(UpdateDecoderManifestRequest.setter(Builder::defaultForUnmappedSignals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultForUnmappedSignals").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, SIGNAL_DECODERS_TO_ADD_FIELD, SIGNAL_DECODERS_TO_UPDATE_FIELD, SIGNAL_DECODERS_TO_REMOVE_FIELD, NETWORK_INTERFACES_TO_ADD_FIELD, NETWORK_INTERFACES_TO_UPDATE_FIELD, NETWORK_INTERFACES_TO_REMOVE_FIELD, STATUS_FIELD, DEFAULT_FOR_UNMAPPED_SIGNALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("signalDecodersToAdd", SIGNAL_DECODERS_TO_ADD_FIELD);
            this.put("signalDecodersToUpdate", SIGNAL_DECODERS_TO_UPDATE_FIELD);
            this.put("signalDecodersToRemove", SIGNAL_DECODERS_TO_REMOVE_FIELD);
            this.put("networkInterfacesToAdd", NETWORK_INTERFACES_TO_ADD_FIELD);
            this.put("networkInterfacesToUpdate", NETWORK_INTERFACES_TO_UPDATE_FIELD);
            this.put("networkInterfacesToRemove", NETWORK_INTERFACES_TO_REMOVE_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("defaultForUnmappedSignals", DEFAULT_FOR_UNMAPPED_SIGNALS_FIELD);
        }
    });
    private final String name;
    private final String description;
    private final List<SignalDecoder> signalDecodersToAdd;
    private final List<SignalDecoder> signalDecodersToUpdate;
    private final List<String> signalDecodersToRemove;
    private final List<NetworkInterface> networkInterfacesToAdd;
    private final List<NetworkInterface> networkInterfacesToUpdate;
    private final List<String> networkInterfacesToRemove;
    private final String status;
    private final String defaultForUnmappedSignals;

    private UpdateDecoderManifestRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.signalDecodersToAdd = builder.signalDecodersToAdd;
        this.signalDecodersToUpdate = builder.signalDecodersToUpdate;
        this.signalDecodersToRemove = builder.signalDecodersToRemove;
        this.networkInterfacesToAdd = builder.networkInterfacesToAdd;
        this.networkInterfacesToUpdate = builder.networkInterfacesToUpdate;
        this.networkInterfacesToRemove = builder.networkInterfacesToRemove;
        this.status = builder.status;
        this.defaultForUnmappedSignals = builder.defaultForUnmappedSignals;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasSignalDecodersToAdd() {
        return this.signalDecodersToAdd != null && !(this.signalDecodersToAdd instanceof SdkAutoConstructList);
    }

    public final List<SignalDecoder> signalDecodersToAdd() {
        return this.signalDecodersToAdd;
    }

    public final boolean hasSignalDecodersToUpdate() {
        return this.signalDecodersToUpdate != null && !(this.signalDecodersToUpdate instanceof SdkAutoConstructList);
    }

    public final List<SignalDecoder> signalDecodersToUpdate() {
        return this.signalDecodersToUpdate;
    }

    public final boolean hasSignalDecodersToRemove() {
        return this.signalDecodersToRemove != null && !(this.signalDecodersToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> signalDecodersToRemove() {
        return this.signalDecodersToRemove;
    }

    public final boolean hasNetworkInterfacesToAdd() {
        return this.networkInterfacesToAdd != null && !(this.networkInterfacesToAdd instanceof SdkAutoConstructList);
    }

    public final List<NetworkInterface> networkInterfacesToAdd() {
        return this.networkInterfacesToAdd;
    }

    public final boolean hasNetworkInterfacesToUpdate() {
        return this.networkInterfacesToUpdate != null && !(this.networkInterfacesToUpdate instanceof SdkAutoConstructList);
    }

    public final List<NetworkInterface> networkInterfacesToUpdate() {
        return this.networkInterfacesToUpdate;
    }

    public final boolean hasNetworkInterfacesToRemove() {
        return this.networkInterfacesToRemove != null && !(this.networkInterfacesToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> networkInterfacesToRemove() {
        return this.networkInterfacesToRemove;
    }

    public final ManifestStatus status() {
        return ManifestStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final DefaultForUnmappedSignalsType defaultForUnmappedSignals() {
        return DefaultForUnmappedSignalsType.fromValue(this.defaultForUnmappedSignals);
    }

    public final String defaultForUnmappedSignalsAsString() {
        return this.defaultForUnmappedSignals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSignalDecodersToAdd() ? this.signalDecodersToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSignalDecodersToUpdate() ? this.signalDecodersToUpdate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSignalDecodersToRemove() ? this.signalDecodersToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfacesToAdd() ? this.networkInterfacesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfacesToUpdate() ? this.networkInterfacesToUpdate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfacesToRemove() ? this.networkInterfacesToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultForUnmappedSignalsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDecoderManifestRequest)) {
            return false;
        }
        UpdateDecoderManifestRequest other = (UpdateDecoderManifestRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasSignalDecodersToAdd() == other.hasSignalDecodersToAdd() && Objects.equals(this.signalDecodersToAdd(), other.signalDecodersToAdd()) && this.hasSignalDecodersToUpdate() == other.hasSignalDecodersToUpdate() && Objects.equals(this.signalDecodersToUpdate(), other.signalDecodersToUpdate()) && this.hasSignalDecodersToRemove() == other.hasSignalDecodersToRemove() && Objects.equals(this.signalDecodersToRemove(), other.signalDecodersToRemove()) && this.hasNetworkInterfacesToAdd() == other.hasNetworkInterfacesToAdd() && Objects.equals(this.networkInterfacesToAdd(), other.networkInterfacesToAdd()) && this.hasNetworkInterfacesToUpdate() == other.hasNetworkInterfacesToUpdate() && Objects.equals(this.networkInterfacesToUpdate(), other.networkInterfacesToUpdate()) && this.hasNetworkInterfacesToRemove() == other.hasNetworkInterfacesToRemove() && Objects.equals(this.networkInterfacesToRemove(), other.networkInterfacesToRemove()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.defaultForUnmappedSignalsAsString(), other.defaultForUnmappedSignalsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDecoderManifestRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("SignalDecodersToAdd", this.hasSignalDecodersToAdd() ? this.signalDecodersToAdd() : null).add("SignalDecodersToUpdate", this.hasSignalDecodersToUpdate() ? this.signalDecodersToUpdate() : null).add("SignalDecodersToRemove", this.hasSignalDecodersToRemove() ? this.signalDecodersToRemove() : null).add("NetworkInterfacesToAdd", this.hasNetworkInterfacesToAdd() ? this.networkInterfacesToAdd() : null).add("NetworkInterfacesToUpdate", this.hasNetworkInterfacesToUpdate() ? this.networkInterfacesToUpdate() : null).add("NetworkInterfacesToRemove", this.hasNetworkInterfacesToRemove() ? this.networkInterfacesToRemove() : null).add("Status", (Object)this.statusAsString()).add("DefaultForUnmappedSignals", (Object)this.defaultForUnmappedSignalsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "signalDecodersToAdd": {
                return Optional.ofNullable(clazz.cast(this.signalDecodersToAdd()));
            }
            case "signalDecodersToUpdate": {
                return Optional.ofNullable(clazz.cast(this.signalDecodersToUpdate()));
            }
            case "signalDecodersToRemove": {
                return Optional.ofNullable(clazz.cast(this.signalDecodersToRemove()));
            }
            case "networkInterfacesToAdd": {
                return Optional.ofNullable(clazz.cast(this.networkInterfacesToAdd()));
            }
            case "networkInterfacesToUpdate": {
                return Optional.ofNullable(clazz.cast(this.networkInterfacesToUpdate()));
            }
            case "networkInterfacesToRemove": {
                return Optional.ofNullable(clazz.cast(this.networkInterfacesToRemove()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "defaultForUnmappedSignals": {
                return Optional.ofNullable(clazz.cast(this.defaultForUnmappedSignalsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDecoderManifestRequest, T> g) {
        return obj -> g.apply((UpdateDecoderManifestRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<SignalDecoder> signalDecodersToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<SignalDecoder> signalDecodersToUpdate = DefaultSdkAutoConstructList.getInstance();
        private List<String> signalDecodersToRemove = DefaultSdkAutoConstructList.getInstance();
        private List<NetworkInterface> networkInterfacesToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<NetworkInterface> networkInterfacesToUpdate = DefaultSdkAutoConstructList.getInstance();
        private List<String> networkInterfacesToRemove = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String defaultForUnmappedSignals;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDecoderManifestRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.signalDecodersToAdd(model.signalDecodersToAdd);
            this.signalDecodersToUpdate(model.signalDecodersToUpdate);
            this.signalDecodersToRemove(model.signalDecodersToRemove);
            this.networkInterfacesToAdd(model.networkInterfacesToAdd);
            this.networkInterfacesToUpdate(model.networkInterfacesToUpdate);
            this.networkInterfacesToRemove(model.networkInterfacesToRemove);
            this.status(model.status);
            this.defaultForUnmappedSignals(model.defaultForUnmappedSignals);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<SignalDecoder.Builder> getSignalDecodersToAdd() {
            List<SignalDecoder.Builder> result = SignalDecodersCopier.copyToBuilder(this.signalDecodersToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSignalDecodersToAdd(Collection<SignalDecoder.BuilderImpl> signalDecodersToAdd) {
            this.signalDecodersToAdd = SignalDecodersCopier.copyFromBuilder(signalDecodersToAdd);
        }

        @Override
        public final Builder signalDecodersToAdd(Collection<SignalDecoder> signalDecodersToAdd) {
            this.signalDecodersToAdd = SignalDecodersCopier.copy(signalDecodersToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalDecodersToAdd(SignalDecoder ... signalDecodersToAdd) {
            this.signalDecodersToAdd(Arrays.asList(signalDecodersToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalDecodersToAdd(Consumer<SignalDecoder.Builder> ... signalDecodersToAdd) {
            this.signalDecodersToAdd(Stream.of(signalDecodersToAdd).map(c -> (SignalDecoder)((SignalDecoder.Builder)SignalDecoder.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SignalDecoder.Builder> getSignalDecodersToUpdate() {
            List<SignalDecoder.Builder> result = SignalDecodersCopier.copyToBuilder(this.signalDecodersToUpdate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSignalDecodersToUpdate(Collection<SignalDecoder.BuilderImpl> signalDecodersToUpdate) {
            this.signalDecodersToUpdate = SignalDecodersCopier.copyFromBuilder(signalDecodersToUpdate);
        }

        @Override
        public final Builder signalDecodersToUpdate(Collection<SignalDecoder> signalDecodersToUpdate) {
            this.signalDecodersToUpdate = SignalDecodersCopier.copy(signalDecodersToUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalDecodersToUpdate(SignalDecoder ... signalDecodersToUpdate) {
            this.signalDecodersToUpdate(Arrays.asList(signalDecodersToUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalDecodersToUpdate(Consumer<SignalDecoder.Builder> ... signalDecodersToUpdate) {
            this.signalDecodersToUpdate(Stream.of(signalDecodersToUpdate).map(c -> (SignalDecoder)((SignalDecoder.Builder)SignalDecoder.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSignalDecodersToRemove() {
            if (this.signalDecodersToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.signalDecodersToRemove;
        }

        public final void setSignalDecodersToRemove(Collection<String> signalDecodersToRemove) {
            this.signalDecodersToRemove = FqnsCopier.copy(signalDecodersToRemove);
        }

        @Override
        public final Builder signalDecodersToRemove(Collection<String> signalDecodersToRemove) {
            this.signalDecodersToRemove = FqnsCopier.copy(signalDecodersToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signalDecodersToRemove(String ... signalDecodersToRemove) {
            this.signalDecodersToRemove(Arrays.asList(signalDecodersToRemove));
            return this;
        }

        public final List<NetworkInterface.Builder> getNetworkInterfacesToAdd() {
            List<NetworkInterface.Builder> result = NetworkInterfacesCopier.copyToBuilder(this.networkInterfacesToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfacesToAdd(Collection<NetworkInterface.BuilderImpl> networkInterfacesToAdd) {
            this.networkInterfacesToAdd = NetworkInterfacesCopier.copyFromBuilder(networkInterfacesToAdd);
        }

        @Override
        public final Builder networkInterfacesToAdd(Collection<NetworkInterface> networkInterfacesToAdd) {
            this.networkInterfacesToAdd = NetworkInterfacesCopier.copy(networkInterfacesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfacesToAdd(NetworkInterface ... networkInterfacesToAdd) {
            this.networkInterfacesToAdd(Arrays.asList(networkInterfacesToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfacesToAdd(Consumer<NetworkInterface.Builder> ... networkInterfacesToAdd) {
            this.networkInterfacesToAdd(Stream.of(networkInterfacesToAdd).map(c -> (NetworkInterface)((NetworkInterface.Builder)NetworkInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<NetworkInterface.Builder> getNetworkInterfacesToUpdate() {
            List<NetworkInterface.Builder> result = NetworkInterfacesCopier.copyToBuilder(this.networkInterfacesToUpdate);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfacesToUpdate(Collection<NetworkInterface.BuilderImpl> networkInterfacesToUpdate) {
            this.networkInterfacesToUpdate = NetworkInterfacesCopier.copyFromBuilder(networkInterfacesToUpdate);
        }

        @Override
        public final Builder networkInterfacesToUpdate(Collection<NetworkInterface> networkInterfacesToUpdate) {
            this.networkInterfacesToUpdate = NetworkInterfacesCopier.copy(networkInterfacesToUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfacesToUpdate(NetworkInterface ... networkInterfacesToUpdate) {
            this.networkInterfacesToUpdate(Arrays.asList(networkInterfacesToUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfacesToUpdate(Consumer<NetworkInterface.Builder> ... networkInterfacesToUpdate) {
            this.networkInterfacesToUpdate(Stream.of(networkInterfacesToUpdate).map(c -> (NetworkInterface)((NetworkInterface.Builder)NetworkInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getNetworkInterfacesToRemove() {
            if (this.networkInterfacesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.networkInterfacesToRemove;
        }

        public final void setNetworkInterfacesToRemove(Collection<String> networkInterfacesToRemove) {
            this.networkInterfacesToRemove = InterfaceIdsCopier.copy(networkInterfacesToRemove);
        }

        @Override
        public final Builder networkInterfacesToRemove(Collection<String> networkInterfacesToRemove) {
            this.networkInterfacesToRemove = InterfaceIdsCopier.copy(networkInterfacesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfacesToRemove(String ... networkInterfacesToRemove) {
            this.networkInterfacesToRemove(Arrays.asList(networkInterfacesToRemove));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ManifestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getDefaultForUnmappedSignals() {
            return this.defaultForUnmappedSignals;
        }

        public final void setDefaultForUnmappedSignals(String defaultForUnmappedSignals) {
            this.defaultForUnmappedSignals = defaultForUnmappedSignals;
        }

        @Override
        public final Builder defaultForUnmappedSignals(String defaultForUnmappedSignals) {
            this.defaultForUnmappedSignals = defaultForUnmappedSignals;
            return this;
        }

        @Override
        public final Builder defaultForUnmappedSignals(DefaultForUnmappedSignalsType defaultForUnmappedSignals) {
            this.defaultForUnmappedSignals(defaultForUnmappedSignals == null ? null : defaultForUnmappedSignals.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDecoderManifestRequest build() {
            return new UpdateDecoderManifestRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTFleetWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDecoderManifestRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder signalDecodersToAdd(Collection<SignalDecoder> var1);

        public Builder signalDecodersToAdd(SignalDecoder ... var1);

        public Builder signalDecodersToAdd(Consumer<SignalDecoder.Builder> ... var1);

        public Builder signalDecodersToUpdate(Collection<SignalDecoder> var1);

        public Builder signalDecodersToUpdate(SignalDecoder ... var1);

        public Builder signalDecodersToUpdate(Consumer<SignalDecoder.Builder> ... var1);

        public Builder signalDecodersToRemove(Collection<String> var1);

        public Builder signalDecodersToRemove(String ... var1);

        public Builder networkInterfacesToAdd(Collection<NetworkInterface> var1);

        public Builder networkInterfacesToAdd(NetworkInterface ... var1);

        public Builder networkInterfacesToAdd(Consumer<NetworkInterface.Builder> ... var1);

        public Builder networkInterfacesToUpdate(Collection<NetworkInterface> var1);

        public Builder networkInterfacesToUpdate(NetworkInterface ... var1);

        public Builder networkInterfacesToUpdate(Consumer<NetworkInterface.Builder> ... var1);

        public Builder networkInterfacesToRemove(Collection<String> var1);

        public Builder networkInterfacesToRemove(String ... var1);

        public Builder status(String var1);

        public Builder status(ManifestStatus var1);

        public Builder defaultForUnmappedSignals(String var1);

        public Builder defaultForUnmappedSignals(DefaultForUnmappedSignalsType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

