/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotfleetwise.model.PrimitiveMessageDefinition;
import software.amazon.awssdk.services.iotfleetwise.model.StructuredMessageDefinitionCopier;
import software.amazon.awssdk.services.iotfleetwise.model.StructuredMessageFieldNameAndDataTypePair;
import software.amazon.awssdk.services.iotfleetwise.model.StructuredMessageListDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StructuredMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StructuredMessage> {
    private static final SdkField<PrimitiveMessageDefinition> PRIMITIVE_MESSAGE_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("primitiveMessageDefinition").getter(StructuredMessage.getter(StructuredMessage::primitiveMessageDefinition)).setter(StructuredMessage.setter(Builder::primitiveMessageDefinition)).constructor(PrimitiveMessageDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primitiveMessageDefinition").build()}).build();
    private static final SdkField<StructuredMessageListDefinition> STRUCTURED_MESSAGE_LIST_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("structuredMessageListDefinition").getter(StructuredMessage.getter(StructuredMessage::structuredMessageListDefinition)).setter(StructuredMessage.setter(Builder::structuredMessageListDefinition)).constructor(StructuredMessageListDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("structuredMessageListDefinition").build()}).build();
    private static final SdkField<List<StructuredMessageFieldNameAndDataTypePair>> STRUCTURED_MESSAGE_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("structuredMessageDefinition").getter(StructuredMessage.getter(StructuredMessage::structuredMessageDefinition)).setter(StructuredMessage.setter(Builder::structuredMessageDefinition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("structuredMessageDefinition").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StructuredMessageFieldNameAndDataTypePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMITIVE_MESSAGE_DEFINITION_FIELD, STRUCTURED_MESSAGE_LIST_DEFINITION_FIELD, STRUCTURED_MESSAGE_DEFINITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("primitiveMessageDefinition", PRIMITIVE_MESSAGE_DEFINITION_FIELD);
            this.put("structuredMessageListDefinition", STRUCTURED_MESSAGE_LIST_DEFINITION_FIELD);
            this.put("structuredMessageDefinition", STRUCTURED_MESSAGE_DEFINITION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final PrimitiveMessageDefinition primitiveMessageDefinition;
    private final StructuredMessageListDefinition structuredMessageListDefinition;
    private final List<StructuredMessageFieldNameAndDataTypePair> structuredMessageDefinition;
    private final Type type;

    private StructuredMessage(BuilderImpl builder) {
        this.primitiveMessageDefinition = builder.primitiveMessageDefinition;
        this.structuredMessageListDefinition = builder.structuredMessageListDefinition;
        this.structuredMessageDefinition = builder.structuredMessageDefinition;
        this.type = builder.type;
    }

    public final PrimitiveMessageDefinition primitiveMessageDefinition() {
        return this.primitiveMessageDefinition;
    }

    public final StructuredMessageListDefinition structuredMessageListDefinition() {
        return this.structuredMessageListDefinition;
    }

    public final boolean hasStructuredMessageDefinition() {
        return this.structuredMessageDefinition != null && !(this.structuredMessageDefinition instanceof SdkAutoConstructList);
    }

    public final List<StructuredMessageFieldNameAndDataTypePair> structuredMessageDefinition() {
        return this.structuredMessageDefinition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.primitiveMessageDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.structuredMessageListDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStructuredMessageDefinition() ? this.structuredMessageDefinition() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StructuredMessage)) {
            return false;
        }
        StructuredMessage other = (StructuredMessage)obj;
        return Objects.equals(this.primitiveMessageDefinition(), other.primitiveMessageDefinition()) && Objects.equals(this.structuredMessageListDefinition(), other.structuredMessageListDefinition()) && this.hasStructuredMessageDefinition() == other.hasStructuredMessageDefinition() && Objects.equals(this.structuredMessageDefinition(), other.structuredMessageDefinition());
    }

    public final String toString() {
        return ToString.builder((String)"StructuredMessage").add("PrimitiveMessageDefinition", (Object)this.primitiveMessageDefinition()).add("StructuredMessageListDefinition", (Object)this.structuredMessageListDefinition()).add("StructuredMessageDefinition", this.hasStructuredMessageDefinition() ? this.structuredMessageDefinition() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "primitiveMessageDefinition": {
                return Optional.ofNullable(clazz.cast(this.primitiveMessageDefinition()));
            }
            case "structuredMessageListDefinition": {
                return Optional.ofNullable(clazz.cast(this.structuredMessageListDefinition()));
            }
            case "structuredMessageDefinition": {
                return Optional.ofNullable(clazz.cast(this.structuredMessageDefinition()));
            }
        }
        return Optional.empty();
    }

    public static StructuredMessage fromPrimitiveMessageDefinition(PrimitiveMessageDefinition primitiveMessageDefinition) {
        return (StructuredMessage)StructuredMessage.builder().primitiveMessageDefinition(primitiveMessageDefinition).build();
    }

    public static StructuredMessage fromPrimitiveMessageDefinition(Consumer<PrimitiveMessageDefinition.Builder> primitiveMessageDefinition) {
        PrimitiveMessageDefinition.Builder builder = PrimitiveMessageDefinition.builder();
        primitiveMessageDefinition.accept(builder);
        return StructuredMessage.fromPrimitiveMessageDefinition((PrimitiveMessageDefinition)builder.build());
    }

    public static StructuredMessage fromStructuredMessageListDefinition(StructuredMessageListDefinition structuredMessageListDefinition) {
        return (StructuredMessage)StructuredMessage.builder().structuredMessageListDefinition(structuredMessageListDefinition).build();
    }

    public static StructuredMessage fromStructuredMessageListDefinition(Consumer<StructuredMessageListDefinition.Builder> structuredMessageListDefinition) {
        StructuredMessageListDefinition.Builder builder = StructuredMessageListDefinition.builder();
        structuredMessageListDefinition.accept(builder);
        return StructuredMessage.fromStructuredMessageListDefinition((StructuredMessageListDefinition)builder.build());
    }

    public static StructuredMessage fromStructuredMessageDefinition(List<StructuredMessageFieldNameAndDataTypePair> structuredMessageDefinition) {
        return (StructuredMessage)StructuredMessage.builder().structuredMessageDefinition(structuredMessageDefinition).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StructuredMessage, T> g) {
        return obj -> g.apply((StructuredMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        PRIMITIVE_MESSAGE_DEFINITION,
        STRUCTURED_MESSAGE_LIST_DEFINITION,
        STRUCTURED_MESSAGE_DEFINITION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private PrimitiveMessageDefinition primitiveMessageDefinition;
        private StructuredMessageListDefinition structuredMessageListDefinition;
        private List<StructuredMessageFieldNameAndDataTypePair> structuredMessageDefinition = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(StructuredMessage model) {
            this.primitiveMessageDefinition(model.primitiveMessageDefinition);
            this.structuredMessageListDefinition(model.structuredMessageListDefinition);
            this.structuredMessageDefinition(model.structuredMessageDefinition);
        }

        public final PrimitiveMessageDefinition.Builder getPrimitiveMessageDefinition() {
            return this.primitiveMessageDefinition != null ? this.primitiveMessageDefinition.toBuilder() : null;
        }

        public final void setPrimitiveMessageDefinition(PrimitiveMessageDefinition.BuilderImpl primitiveMessageDefinition) {
            PrimitiveMessageDefinition oldValue = this.primitiveMessageDefinition;
            this.primitiveMessageDefinition = primitiveMessageDefinition != null ? primitiveMessageDefinition.build() : null;
            this.handleUnionValueChange(Type.PRIMITIVE_MESSAGE_DEFINITION, oldValue, this.primitiveMessageDefinition);
        }

        @Override
        public final Builder primitiveMessageDefinition(PrimitiveMessageDefinition primitiveMessageDefinition) {
            PrimitiveMessageDefinition oldValue = this.primitiveMessageDefinition;
            this.primitiveMessageDefinition = primitiveMessageDefinition;
            this.handleUnionValueChange(Type.PRIMITIVE_MESSAGE_DEFINITION, oldValue, this.primitiveMessageDefinition);
            return this;
        }

        public final StructuredMessageListDefinition.Builder getStructuredMessageListDefinition() {
            return this.structuredMessageListDefinition != null ? this.structuredMessageListDefinition.toBuilder() : null;
        }

        public final void setStructuredMessageListDefinition(StructuredMessageListDefinition.BuilderImpl structuredMessageListDefinition) {
            StructuredMessageListDefinition oldValue = this.structuredMessageListDefinition;
            this.structuredMessageListDefinition = structuredMessageListDefinition != null ? structuredMessageListDefinition.build() : null;
            this.handleUnionValueChange(Type.STRUCTURED_MESSAGE_LIST_DEFINITION, oldValue, this.structuredMessageListDefinition);
        }

        @Override
        public final Builder structuredMessageListDefinition(StructuredMessageListDefinition structuredMessageListDefinition) {
            StructuredMessageListDefinition oldValue = this.structuredMessageListDefinition;
            this.structuredMessageListDefinition = structuredMessageListDefinition;
            this.handleUnionValueChange(Type.STRUCTURED_MESSAGE_LIST_DEFINITION, oldValue, this.structuredMessageListDefinition);
            return this;
        }

        public final List<StructuredMessageFieldNameAndDataTypePair.Builder> getStructuredMessageDefinition() {
            List<StructuredMessageFieldNameAndDataTypePair.Builder> result = StructuredMessageDefinitionCopier.copyToBuilder(this.structuredMessageDefinition);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStructuredMessageDefinition(Collection<StructuredMessageFieldNameAndDataTypePair.BuilderImpl> structuredMessageDefinition) {
            List<StructuredMessageFieldNameAndDataTypePair> oldValue = this.structuredMessageDefinition;
            this.structuredMessageDefinition = StructuredMessageDefinitionCopier.copyFromBuilder(structuredMessageDefinition);
            this.handleUnionValueChange(Type.STRUCTURED_MESSAGE_DEFINITION, oldValue, this.structuredMessageDefinition);
        }

        @Override
        public final Builder structuredMessageDefinition(Collection<StructuredMessageFieldNameAndDataTypePair> structuredMessageDefinition) {
            List<StructuredMessageFieldNameAndDataTypePair> oldValue = this.structuredMessageDefinition;
            this.structuredMessageDefinition = StructuredMessageDefinitionCopier.copy(structuredMessageDefinition);
            this.handleUnionValueChange(Type.STRUCTURED_MESSAGE_DEFINITION, oldValue, this.structuredMessageDefinition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder structuredMessageDefinition(StructuredMessageFieldNameAndDataTypePair ... structuredMessageDefinition) {
            this.structuredMessageDefinition(Arrays.asList(structuredMessageDefinition));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder structuredMessageDefinition(Consumer<StructuredMessageFieldNameAndDataTypePair.Builder> ... structuredMessageDefinition) {
            this.structuredMessageDefinition(Stream.of(structuredMessageDefinition).map(c -> (StructuredMessageFieldNameAndDataTypePair)((StructuredMessageFieldNameAndDataTypePair.Builder)StructuredMessageFieldNameAndDataTypePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public StructuredMessage build() {
            return new StructuredMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StructuredMessage> {
        public Builder primitiveMessageDefinition(PrimitiveMessageDefinition var1);

        default public Builder primitiveMessageDefinition(Consumer<PrimitiveMessageDefinition.Builder> primitiveMessageDefinition) {
            return this.primitiveMessageDefinition((PrimitiveMessageDefinition)((PrimitiveMessageDefinition.Builder)PrimitiveMessageDefinition.builder().applyMutation(primitiveMessageDefinition)).build());
        }

        public Builder structuredMessageListDefinition(StructuredMessageListDefinition var1);

        default public Builder structuredMessageListDefinition(Consumer<StructuredMessageListDefinition.Builder> structuredMessageListDefinition) {
            return this.structuredMessageListDefinition((StructuredMessageListDefinition)((StructuredMessageListDefinition.Builder)StructuredMessageListDefinition.builder().applyMutation(structuredMessageListDefinition)).build());
        }

        public Builder structuredMessageDefinition(Collection<StructuredMessageFieldNameAndDataTypePair> var1);

        public Builder structuredMessageDefinition(StructuredMessageFieldNameAndDataTypePair ... var1);

        public Builder structuredMessageDefinition(Consumer<StructuredMessageFieldNameAndDataTypePair.Builder> ... var1);
    }
}

