/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotfleetwise.model.DataPartitionStorageOptions;
import software.amazon.awssdk.services.iotfleetwise.model.DataPartitionUploadOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataPartition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataPartition> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(DataPartition.getter(DataPartition::id)).setter(DataPartition.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<DataPartitionStorageOptions> STORAGE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storageOptions").getter(DataPartition.getter(DataPartition::storageOptions)).setter(DataPartition.setter(Builder::storageOptions)).constructor(DataPartitionStorageOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageOptions").build()}).build();
    private static final SdkField<DataPartitionUploadOptions> UPLOAD_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("uploadOptions").getter(DataPartition.getter(DataPartition::uploadOptions)).setter(DataPartition.setter(Builder::uploadOptions)).constructor(DataPartitionUploadOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STORAGE_OPTIONS_FIELD, UPLOAD_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("id", ID_FIELD);
            this.put("storageOptions", STORAGE_OPTIONS_FIELD);
            this.put("uploadOptions", UPLOAD_OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String id;
    private final DataPartitionStorageOptions storageOptions;
    private final DataPartitionUploadOptions uploadOptions;

    private DataPartition(BuilderImpl builder) {
        this.id = builder.id;
        this.storageOptions = builder.storageOptions;
        this.uploadOptions = builder.uploadOptions;
    }

    public final String id() {
        return this.id;
    }

    public final DataPartitionStorageOptions storageOptions() {
        return this.storageOptions;
    }

    public final DataPartitionUploadOptions uploadOptions() {
        return this.uploadOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataPartition)) {
            return false;
        }
        DataPartition other = (DataPartition)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.storageOptions(), other.storageOptions()) && Objects.equals(this.uploadOptions(), other.uploadOptions());
    }

    public final String toString() {
        return ToString.builder((String)"DataPartition").add("Id", (Object)this.id()).add("StorageOptions", (Object)this.storageOptions()).add("UploadOptions", (Object)this.uploadOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "storageOptions": {
                return Optional.ofNullable(clazz.cast(this.storageOptions()));
            }
            case "uploadOptions": {
                return Optional.ofNullable(clazz.cast(this.uploadOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataPartition, T> g) {
        return obj -> g.apply((DataPartition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private DataPartitionStorageOptions storageOptions;
        private DataPartitionUploadOptions uploadOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DataPartition model) {
            this.id(model.id);
            this.storageOptions(model.storageOptions);
            this.uploadOptions(model.uploadOptions);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final DataPartitionStorageOptions.Builder getStorageOptions() {
            return this.storageOptions != null ? this.storageOptions.toBuilder() : null;
        }

        public final void setStorageOptions(DataPartitionStorageOptions.BuilderImpl storageOptions) {
            this.storageOptions = storageOptions != null ? storageOptions.build() : null;
        }

        @Override
        public final Builder storageOptions(DataPartitionStorageOptions storageOptions) {
            this.storageOptions = storageOptions;
            return this;
        }

        public final DataPartitionUploadOptions.Builder getUploadOptions() {
            return this.uploadOptions != null ? this.uploadOptions.toBuilder() : null;
        }

        public final void setUploadOptions(DataPartitionUploadOptions.BuilderImpl uploadOptions) {
            this.uploadOptions = uploadOptions != null ? uploadOptions.build() : null;
        }

        @Override
        public final Builder uploadOptions(DataPartitionUploadOptions uploadOptions) {
            this.uploadOptions = uploadOptions;
            return this;
        }

        public DataPartition build() {
            return new DataPartition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataPartition> {
        public Builder id(String var1);

        public Builder storageOptions(DataPartitionStorageOptions var1);

        default public Builder storageOptions(Consumer<DataPartitionStorageOptions.Builder> storageOptions) {
            return this.storageOptions((DataPartitionStorageOptions)((DataPartitionStorageOptions.Builder)DataPartitionStorageOptions.builder().applyMutation(storageOptions)).build());
        }

        public Builder uploadOptions(DataPartitionUploadOptions var1);

        default public Builder uploadOptions(Consumer<DataPartitionUploadOptions.Builder> uploadOptions) {
            return this.uploadOptions((DataPartitionUploadOptions)((DataPartitionUploadOptions.Builder)DataPartitionUploadOptions.builder().applyMutation(uploadOptions)).build());
        }
    }
}

