/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NodeDataEncoding {
    BINARY("BINARY"),
    TYPED("TYPED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NodeDataEncoding> VALUE_MAP;
    private final String value;

    private NodeDataEncoding(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NodeDataEncoding fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NodeDataEncoding> knownValues() {
        EnumSet<NodeDataEncoding> knownValues = EnumSet.allOf(NodeDataEncoding.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NodeDataEncoding.class, NodeDataEncoding::toString);
    }
}

