/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseRequest;
import software.amazon.awssdk.services.iotfleetwise.model.StateTemplateDataExtraDimensionNodePathListCopier;
import software.amazon.awssdk.services.iotfleetwise.model.StateTemplateMetadataExtraDimensionNodePathListCopier;
import software.amazon.awssdk.services.iotfleetwise.model.StateTemplatePropertiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStateTemplateRequest
extends IoTFleetWiseRequest
implements ToCopyableBuilder<Builder, UpdateStateTemplateRequest> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(UpdateStateTemplateRequest.getter(UpdateStateTemplateRequest::identifier)).setter(UpdateStateTemplateRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateStateTemplateRequest.getter(UpdateStateTemplateRequest::description)).setter(UpdateStateTemplateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> STATE_TEMPLATE_PROPERTIES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stateTemplatePropertiesToAdd").getter(UpdateStateTemplateRequest.getter(UpdateStateTemplateRequest::stateTemplatePropertiesToAdd)).setter(UpdateStateTemplateRequest.setter(Builder::stateTemplatePropertiesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateTemplatePropertiesToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATE_TEMPLATE_PROPERTIES_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stateTemplatePropertiesToRemove").getter(UpdateStateTemplateRequest.getter(UpdateStateTemplateRequest::stateTemplatePropertiesToRemove)).setter(UpdateStateTemplateRequest.setter(Builder::stateTemplatePropertiesToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateTemplatePropertiesToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DATA_EXTRA_DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataExtraDimensions").getter(UpdateStateTemplateRequest.getter(UpdateStateTemplateRequest::dataExtraDimensions)).setter(UpdateStateTemplateRequest.setter(Builder::dataExtraDimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataExtraDimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> METADATA_EXTRA_DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metadataExtraDimensions").getter(UpdateStateTemplateRequest.getter(UpdateStateTemplateRequest::metadataExtraDimensions)).setter(UpdateStateTemplateRequest.setter(Builder::metadataExtraDimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadataExtraDimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, DESCRIPTION_FIELD, STATE_TEMPLATE_PROPERTIES_TO_ADD_FIELD, STATE_TEMPLATE_PROPERTIES_TO_REMOVE_FIELD, DATA_EXTRA_DIMENSIONS_FIELD, METADATA_EXTRA_DIMENSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("identifier", IDENTIFIER_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("stateTemplatePropertiesToAdd", STATE_TEMPLATE_PROPERTIES_TO_ADD_FIELD);
            this.put("stateTemplatePropertiesToRemove", STATE_TEMPLATE_PROPERTIES_TO_REMOVE_FIELD);
            this.put("dataExtraDimensions", DATA_EXTRA_DIMENSIONS_FIELD);
            this.put("metadataExtraDimensions", METADATA_EXTRA_DIMENSIONS_FIELD);
        }
    });
    private final String identifier;
    private final String description;
    private final List<String> stateTemplatePropertiesToAdd;
    private final List<String> stateTemplatePropertiesToRemove;
    private final List<String> dataExtraDimensions;
    private final List<String> metadataExtraDimensions;

    private UpdateStateTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.identifier = builder.identifier;
        this.description = builder.description;
        this.stateTemplatePropertiesToAdd = builder.stateTemplatePropertiesToAdd;
        this.stateTemplatePropertiesToRemove = builder.stateTemplatePropertiesToRemove;
        this.dataExtraDimensions = builder.dataExtraDimensions;
        this.metadataExtraDimensions = builder.metadataExtraDimensions;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasStateTemplatePropertiesToAdd() {
        return this.stateTemplatePropertiesToAdd != null && !(this.stateTemplatePropertiesToAdd instanceof SdkAutoConstructList);
    }

    public final List<String> stateTemplatePropertiesToAdd() {
        return this.stateTemplatePropertiesToAdd;
    }

    public final boolean hasStateTemplatePropertiesToRemove() {
        return this.stateTemplatePropertiesToRemove != null && !(this.stateTemplatePropertiesToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> stateTemplatePropertiesToRemove() {
        return this.stateTemplatePropertiesToRemove;
    }

    public final boolean hasDataExtraDimensions() {
        return this.dataExtraDimensions != null && !(this.dataExtraDimensions instanceof SdkAutoConstructList);
    }

    public final List<String> dataExtraDimensions() {
        return this.dataExtraDimensions;
    }

    public final boolean hasMetadataExtraDimensions() {
        return this.metadataExtraDimensions != null && !(this.metadataExtraDimensions instanceof SdkAutoConstructList);
    }

    public final List<String> metadataExtraDimensions() {
        return this.metadataExtraDimensions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStateTemplatePropertiesToAdd() ? this.stateTemplatePropertiesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStateTemplatePropertiesToRemove() ? this.stateTemplatePropertiesToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataExtraDimensions() ? this.dataExtraDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadataExtraDimensions() ? this.metadataExtraDimensions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStateTemplateRequest)) {
            return false;
        }
        UpdateStateTemplateRequest other = (UpdateStateTemplateRequest)((Object)obj);
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.description(), other.description()) && this.hasStateTemplatePropertiesToAdd() == other.hasStateTemplatePropertiesToAdd() && Objects.equals(this.stateTemplatePropertiesToAdd(), other.stateTemplatePropertiesToAdd()) && this.hasStateTemplatePropertiesToRemove() == other.hasStateTemplatePropertiesToRemove() && Objects.equals(this.stateTemplatePropertiesToRemove(), other.stateTemplatePropertiesToRemove()) && this.hasDataExtraDimensions() == other.hasDataExtraDimensions() && Objects.equals(this.dataExtraDimensions(), other.dataExtraDimensions()) && this.hasMetadataExtraDimensions() == other.hasMetadataExtraDimensions() && Objects.equals(this.metadataExtraDimensions(), other.metadataExtraDimensions());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStateTemplateRequest").add("Identifier", (Object)this.identifier()).add("Description", (Object)this.description()).add("StateTemplatePropertiesToAdd", this.hasStateTemplatePropertiesToAdd() ? this.stateTemplatePropertiesToAdd() : null).add("StateTemplatePropertiesToRemove", this.hasStateTemplatePropertiesToRemove() ? this.stateTemplatePropertiesToRemove() : null).add("DataExtraDimensions", this.hasDataExtraDimensions() ? this.dataExtraDimensions() : null).add("MetadataExtraDimensions", this.hasMetadataExtraDimensions() ? this.metadataExtraDimensions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "stateTemplatePropertiesToAdd": {
                return Optional.ofNullable(clazz.cast(this.stateTemplatePropertiesToAdd()));
            }
            case "stateTemplatePropertiesToRemove": {
                return Optional.ofNullable(clazz.cast(this.stateTemplatePropertiesToRemove()));
            }
            case "dataExtraDimensions": {
                return Optional.ofNullable(clazz.cast(this.dataExtraDimensions()));
            }
            case "metadataExtraDimensions": {
                return Optional.ofNullable(clazz.cast(this.metadataExtraDimensions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateStateTemplateRequest, T> g) {
        return obj -> g.apply((UpdateStateTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseRequest.BuilderImpl
    implements Builder {
        private String identifier;
        private String description;
        private List<String> stateTemplatePropertiesToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> stateTemplatePropertiesToRemove = DefaultSdkAutoConstructList.getInstance();
        private List<String> dataExtraDimensions = DefaultSdkAutoConstructList.getInstance();
        private List<String> metadataExtraDimensions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStateTemplateRequest model) {
            super(model);
            this.identifier(model.identifier);
            this.description(model.description);
            this.stateTemplatePropertiesToAdd(model.stateTemplatePropertiesToAdd);
            this.stateTemplatePropertiesToRemove(model.stateTemplatePropertiesToRemove);
            this.dataExtraDimensions(model.dataExtraDimensions);
            this.metadataExtraDimensions(model.metadataExtraDimensions);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getStateTemplatePropertiesToAdd() {
            if (this.stateTemplatePropertiesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stateTemplatePropertiesToAdd;
        }

        public final void setStateTemplatePropertiesToAdd(Collection<String> stateTemplatePropertiesToAdd) {
            this.stateTemplatePropertiesToAdd = StateTemplatePropertiesCopier.copy(stateTemplatePropertiesToAdd);
        }

        @Override
        public final Builder stateTemplatePropertiesToAdd(Collection<String> stateTemplatePropertiesToAdd) {
            this.stateTemplatePropertiesToAdd = StateTemplatePropertiesCopier.copy(stateTemplatePropertiesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateTemplatePropertiesToAdd(String ... stateTemplatePropertiesToAdd) {
            this.stateTemplatePropertiesToAdd(Arrays.asList(stateTemplatePropertiesToAdd));
            return this;
        }

        public final Collection<String> getStateTemplatePropertiesToRemove() {
            if (this.stateTemplatePropertiesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stateTemplatePropertiesToRemove;
        }

        public final void setStateTemplatePropertiesToRemove(Collection<String> stateTemplatePropertiesToRemove) {
            this.stateTemplatePropertiesToRemove = StateTemplatePropertiesCopier.copy(stateTemplatePropertiesToRemove);
        }

        @Override
        public final Builder stateTemplatePropertiesToRemove(Collection<String> stateTemplatePropertiesToRemove) {
            this.stateTemplatePropertiesToRemove = StateTemplatePropertiesCopier.copy(stateTemplatePropertiesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stateTemplatePropertiesToRemove(String ... stateTemplatePropertiesToRemove) {
            this.stateTemplatePropertiesToRemove(Arrays.asList(stateTemplatePropertiesToRemove));
            return this;
        }

        public final Collection<String> getDataExtraDimensions() {
            if (this.dataExtraDimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataExtraDimensions;
        }

        public final void setDataExtraDimensions(Collection<String> dataExtraDimensions) {
            this.dataExtraDimensions = StateTemplateDataExtraDimensionNodePathListCopier.copy(dataExtraDimensions);
        }

        @Override
        public final Builder dataExtraDimensions(Collection<String> dataExtraDimensions) {
            this.dataExtraDimensions = StateTemplateDataExtraDimensionNodePathListCopier.copy(dataExtraDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataExtraDimensions(String ... dataExtraDimensions) {
            this.dataExtraDimensions(Arrays.asList(dataExtraDimensions));
            return this;
        }

        public final Collection<String> getMetadataExtraDimensions() {
            if (this.metadataExtraDimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metadataExtraDimensions;
        }

        public final void setMetadataExtraDimensions(Collection<String> metadataExtraDimensions) {
            this.metadataExtraDimensions = StateTemplateMetadataExtraDimensionNodePathListCopier.copy(metadataExtraDimensions);
        }

        @Override
        public final Builder metadataExtraDimensions(Collection<String> metadataExtraDimensions) {
            this.metadataExtraDimensions = StateTemplateMetadataExtraDimensionNodePathListCopier.copy(metadataExtraDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataExtraDimensions(String ... metadataExtraDimensions) {
            this.metadataExtraDimensions(Arrays.asList(metadataExtraDimensions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStateTemplateRequest build() {
            return new UpdateStateTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTFleetWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStateTemplateRequest> {
        public Builder identifier(String var1);

        public Builder description(String var1);

        public Builder stateTemplatePropertiesToAdd(Collection<String> var1);

        public Builder stateTemplatePropertiesToAdd(String ... var1);

        public Builder stateTemplatePropertiesToRemove(Collection<String> var1);

        public Builder stateTemplatePropertiesToRemove(String ... var1);

        public Builder dataExtraDimensions(Collection<String> var1);

        public Builder dataExtraDimensions(String ... var1);

        public Builder metadataExtraDimensions(Collection<String> var1);

        public Builder metadataExtraDimensions(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

