/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.InvalidSignal;
import software.amazon.awssdk.services.iotfleetwise.model.InvalidSignalsCopier;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvalidSignalsException
extends IoTFleetWiseException
implements ToCopyableBuilder<Builder, InvalidSignalsException> {
    private static final SdkField<List<InvalidSignal>> INVALID_SIGNALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("invalidSignals").getter(InvalidSignalsException.getter(InvalidSignalsException::invalidSignals)).setter(InvalidSignalsException.setter(Builder::invalidSignals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invalidSignals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InvalidSignal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVALID_SIGNALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("invalidSignals", INVALID_SIGNALS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<InvalidSignal> invalidSignals;

    private InvalidSignalsException(BuilderImpl builder) {
        super(builder);
        this.invalidSignals = builder.invalidSignals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public boolean hasInvalidSignals() {
        return this.invalidSignals != null && !(this.invalidSignals instanceof SdkAutoConstructList);
    }

    public List<InvalidSignal> invalidSignals() {
        return this.invalidSignals;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InvalidSignalsException, T> g) {
        return obj -> g.apply((InvalidSignalsException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseException.BuilderImpl
    implements Builder {
        private List<InvalidSignal> invalidSignals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidSignalsException model) {
            super(model);
            this.invalidSignals(model.invalidSignals);
        }

        public final List<InvalidSignal.Builder> getInvalidSignals() {
            List<InvalidSignal.Builder> result = InvalidSignalsCopier.copyToBuilder(this.invalidSignals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvalidSignals(Collection<InvalidSignal.BuilderImpl> invalidSignals) {
            this.invalidSignals = InvalidSignalsCopier.copyFromBuilder(invalidSignals);
        }

        @Override
        public final Builder invalidSignals(Collection<InvalidSignal> invalidSignals) {
            this.invalidSignals = InvalidSignalsCopier.copy(invalidSignals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidSignals(InvalidSignal ... invalidSignals) {
            this.invalidSignals(Arrays.asList(invalidSignals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidSignals(Consumer<InvalidSignal.Builder> ... invalidSignals) {
            this.invalidSignals(Stream.of(invalidSignals).map(c -> (InvalidSignal)((InvalidSignal.Builder)InvalidSignal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public InvalidSignalsException build() {
            return new InvalidSignalsException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvalidSignalsException>,
    IoTFleetWiseException.Builder {
        public Builder invalidSignals(Collection<InvalidSignal> var1);

        public Builder invalidSignals(InvalidSignal ... var1);

        public Builder invalidSignals(Consumer<InvalidSignal.Builder> ... var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);
    }
}

