/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NodeDataType {
    INT8("INT8"),
    UINT8("UINT8"),
    INT16("INT16"),
    UINT16("UINT16"),
    INT32("INT32"),
    UINT32("UINT32"),
    INT64("INT64"),
    UINT64("UINT64"),
    BOOLEAN("BOOLEAN"),
    FLOAT("FLOAT"),
    DOUBLE("DOUBLE"),
    STRING("STRING"),
    UNIX_TIMESTAMP("UNIX_TIMESTAMP"),
    INT8_ARRAY("INT8_ARRAY"),
    UINT8_ARRAY("UINT8_ARRAY"),
    INT16_ARRAY("INT16_ARRAY"),
    UINT16_ARRAY("UINT16_ARRAY"),
    INT32_ARRAY("INT32_ARRAY"),
    UINT32_ARRAY("UINT32_ARRAY"),
    INT64_ARRAY("INT64_ARRAY"),
    UINT64_ARRAY("UINT64_ARRAY"),
    BOOLEAN_ARRAY("BOOLEAN_ARRAY"),
    FLOAT_ARRAY("FLOAT_ARRAY"),
    DOUBLE_ARRAY("DOUBLE_ARRAY"),
    STRING_ARRAY("STRING_ARRAY"),
    UNIX_TIMESTAMP_ARRAY("UNIX_TIMESTAMP_ARRAY"),
    UNKNOWN("UNKNOWN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NodeDataType> VALUE_MAP;
    private final String value;

    private NodeDataType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NodeDataType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NodeDataType> knownValues() {
        EnumSet<NodeDataType> knownValues = EnumSet.allOf(NodeDataType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NodeDataType.class, NodeDataType::toString);
    }
}

