/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class InvalidNetworkInterfacesCopier {
    static List<InvalidNetworkInterface> copy(Collection<? extends InvalidNetworkInterface> invalidNetworkInterfacesParam) {
        List<InvalidNetworkInterface> list;
        if (invalidNetworkInterfacesParam == null || invalidNetworkInterfacesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<InvalidNetworkInterface> modifiableList = new ArrayList<>();
            invalidNetworkInterfacesParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<InvalidNetworkInterface> copyFromBuilder(
            Collection<? extends InvalidNetworkInterface.Builder> invalidNetworkInterfacesParam) {
        List<InvalidNetworkInterface> list;
        if (invalidNetworkInterfacesParam == null || invalidNetworkInterfacesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<InvalidNetworkInterface> modifiableList = new ArrayList<>();
            invalidNetworkInterfacesParam.forEach(entry -> {
                InvalidNetworkInterface member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<InvalidNetworkInterface.Builder> copyToBuilder(
            Collection<? extends InvalidNetworkInterface> invalidNetworkInterfacesParam) {
        List<InvalidNetworkInterface.Builder> list;
        if (invalidNetworkInterfacesParam == null || invalidNetworkInterfacesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<InvalidNetworkInterface.Builder> modifiableList = new ArrayList<>();
            invalidNetworkInterfacesParam.forEach(entry -> {
                InvalidNetworkInterface.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
