/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A group of signals that are defined in a hierarchical structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Branch implements SdkPojo, Serializable, ToCopyableBuilder<Branch.Builder, Branch> {
    private static final SdkField<String> FULLY_QUALIFIED_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fullyQualifiedName").getter(getter(Branch::fullyQualifiedName))
            .setter(setter(Builder::fullyQualifiedName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fullyQualifiedName").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Branch::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DEPRECATION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deprecationMessage").getter(getter(Branch::deprecationMessage))
            .setter(setter(Builder::deprecationMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deprecationMessage").build())
            .build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(Branch::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FULLY_QUALIFIED_NAME_FIELD,
            DESCRIPTION_FIELD, DEPRECATION_MESSAGE_FIELD, COMMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fullyQualifiedName;

    private final String description;

    private final String deprecationMessage;

    private final String comment;

    private Branch(BuilderImpl builder) {
        this.fullyQualifiedName = builder.fullyQualifiedName;
        this.description = builder.description;
        this.deprecationMessage = builder.deprecationMessage;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * The fully qualified name of the branch. For example, the fully qualified name of a branch might be
     * <code>Vehicle.Body.Engine</code>.
     * </p>
     * 
     * @return The fully qualified name of the branch. For example, the fully qualified name of a branch might be
     *         <code>Vehicle.Body.Engine</code>.
     */
    public final String fullyQualifiedName() {
        return fullyQualifiedName;
    }

    /**
     * <p>
     * A brief description of the branch.
     * </p>
     * 
     * @return A brief description of the branch.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The deprecation message for the node or the branch that was moved or deleted.
     * </p>
     * 
     * @return The deprecation message for the node or the branch that was moved or deleted.
     */
    public final String deprecationMessage() {
        return deprecationMessage;
    }

    /**
     * <p>
     * A comment in addition to the description.
     * </p>
     * 
     * @return A comment in addition to the description.
     */
    public final String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fullyQualifiedName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deprecationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Branch)) {
            return false;
        }
        Branch other = (Branch) obj;
        return Objects.equals(fullyQualifiedName(), other.fullyQualifiedName())
                && Objects.equals(description(), other.description())
                && Objects.equals(deprecationMessage(), other.deprecationMessage()) && Objects.equals(comment(), other.comment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Branch").add("FullyQualifiedName", fullyQualifiedName()).add("Description", description())
                .add("DeprecationMessage", deprecationMessage()).add("Comment", comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fullyQualifiedName":
            return Optional.ofNullable(clazz.cast(fullyQualifiedName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "deprecationMessage":
            return Optional.ofNullable(clazz.cast(deprecationMessage()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Branch, T> g) {
        return obj -> g.apply((Branch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Branch> {
        /**
         * <p>
         * The fully qualified name of the branch. For example, the fully qualified name of a branch might be
         * <code>Vehicle.Body.Engine</code>.
         * </p>
         * 
         * @param fullyQualifiedName
         *        The fully qualified name of the branch. For example, the fully qualified name of a branch might be
         *        <code>Vehicle.Body.Engine</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullyQualifiedName(String fullyQualifiedName);

        /**
         * <p>
         * A brief description of the branch.
         * </p>
         * 
         * @param description
         *        A brief description of the branch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The deprecation message for the node or the branch that was moved or deleted.
         * </p>
         * 
         * @param deprecationMessage
         *        The deprecation message for the node or the branch that was moved or deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deprecationMessage(String deprecationMessage);

        /**
         * <p>
         * A comment in addition to the description.
         * </p>
         * 
         * @param comment
         *        A comment in addition to the description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);
    }

    static final class BuilderImpl implements Builder {
        private String fullyQualifiedName;

        private String description;

        private String deprecationMessage;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(Branch model) {
            fullyQualifiedName(model.fullyQualifiedName);
            description(model.description);
            deprecationMessage(model.deprecationMessage);
            comment(model.comment);
        }

        public final String getFullyQualifiedName() {
            return fullyQualifiedName;
        }

        public final void setFullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public final Builder fullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDeprecationMessage() {
            return deprecationMessage;
        }

        public final void setDeprecationMessage(String deprecationMessage) {
            this.deprecationMessage = deprecationMessage;
        }

        @Override
        public final Builder deprecationMessage(String deprecationMessage) {
            this.deprecationMessage = deprecationMessage;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public Branch build() {
            return new Branch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
