/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotfleethub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of information about a AWS IoT Device Management web application.
 * </p>
 * <note>
 * <p>
 * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationSummary.Builder, ApplicationSummary> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationId").getter(getter(ApplicationSummary::applicationId)).setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()).build();

    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationName").getter(getter(ApplicationSummary::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()).build();

    private static final SdkField<String> APPLICATION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationDescription").getter(getter(ApplicationSummary::applicationDescription))
            .setter(setter(Builder::applicationDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationDescription").build())
            .build();

    private static final SdkField<String> APPLICATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationUrl").getter(getter(ApplicationSummary::applicationUrl))
            .setter(setter(Builder::applicationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationUrl").build()).build();

    private static final SdkField<Long> APPLICATION_CREATION_DATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("applicationCreationDate").getter(getter(ApplicationSummary::applicationCreationDate))
            .setter(setter(Builder::applicationCreationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationCreationDate").build())
            .build();

    private static final SdkField<Long> APPLICATION_LAST_UPDATE_DATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("applicationLastUpdateDate").getter(getter(ApplicationSummary::applicationLastUpdateDate))
            .setter(setter(Builder::applicationLastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationLastUpdateDate").build())
            .build();

    private static final SdkField<String> APPLICATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationState").getter(getter(ApplicationSummary::applicationStateAsString))
            .setter(setter(Builder::applicationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD,
            APPLICATION_NAME_FIELD, APPLICATION_DESCRIPTION_FIELD, APPLICATION_URL_FIELD, APPLICATION_CREATION_DATE_FIELD,
            APPLICATION_LAST_UPDATE_DATE_FIELD, APPLICATION_STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationId;

    private final String applicationName;

    private final String applicationDescription;

    private final String applicationUrl;

    private final Long applicationCreationDate;

    private final Long applicationLastUpdateDate;

    private final String applicationState;

    private ApplicationSummary(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.applicationName = builder.applicationName;
        this.applicationDescription = builder.applicationDescription;
        this.applicationUrl = builder.applicationUrl;
        this.applicationCreationDate = builder.applicationCreationDate;
        this.applicationLastUpdateDate = builder.applicationLastUpdateDate;
        this.applicationState = builder.applicationState;
    }

    /**
     * <p>
     * The unique Id of the web application.
     * </p>
     * 
     * @return The unique Id of the web application.
     */
    public final String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The name of the web application.
     * </p>
     * 
     * @return The name of the web application.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * An optional description of the web application.
     * </p>
     * 
     * @return An optional description of the web application.
     */
    public final String applicationDescription() {
        return applicationDescription;
    }

    /**
     * <p>
     * The URL of the web application.
     * </p>
     * 
     * @return The URL of the web application.
     */
    public final String applicationUrl() {
        return applicationUrl;
    }

    /**
     * <p>
     * The date (in Unix epoch time) when the web application was created.
     * </p>
     * 
     * @return The date (in Unix epoch time) when the web application was created.
     */
    public final Long applicationCreationDate() {
        return applicationCreationDate;
    }

    /**
     * <p>
     * The date (in Unix epoch time) when the web application was last updated.
     * </p>
     * 
     * @return The date (in Unix epoch time) when the web application was last updated.
     */
    public final Long applicationLastUpdateDate() {
        return applicationLastUpdateDate;
    }

    /**
     * <p>
     * The current state of the web application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationState}
     * will return {@link ApplicationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationStateAsString}.
     * </p>
     * 
     * @return The current state of the web application.
     * @see ApplicationState
     */
    public final ApplicationState applicationState() {
        return ApplicationState.fromValue(applicationState);
    }

    /**
     * <p>
     * The current state of the web application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applicationState}
     * will return {@link ApplicationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #applicationStateAsString}.
     * </p>
     * 
     * @return The current state of the web application.
     * @see ApplicationState
     */
    public final String applicationStateAsString() {
        return applicationState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(applicationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(applicationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(applicationCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(applicationLastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(applicationStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSummary)) {
            return false;
        }
        ApplicationSummary other = (ApplicationSummary) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(applicationDescription(), other.applicationDescription())
                && Objects.equals(applicationUrl(), other.applicationUrl())
                && Objects.equals(applicationCreationDate(), other.applicationCreationDate())
                && Objects.equals(applicationLastUpdateDate(), other.applicationLastUpdateDate())
                && Objects.equals(applicationStateAsString(), other.applicationStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApplicationSummary").add("ApplicationId", applicationId())
                .add("ApplicationName", applicationName()).add("ApplicationDescription", applicationDescription())
                .add("ApplicationUrl", applicationUrl()).add("ApplicationCreationDate", applicationCreationDate())
                .add("ApplicationLastUpdateDate", applicationLastUpdateDate())
                .add("ApplicationState", applicationStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "applicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "applicationDescription":
            return Optional.ofNullable(clazz.cast(applicationDescription()));
        case "applicationUrl":
            return Optional.ofNullable(clazz.cast(applicationUrl()));
        case "applicationCreationDate":
            return Optional.ofNullable(clazz.cast(applicationCreationDate()));
        case "applicationLastUpdateDate":
            return Optional.ofNullable(clazz.cast(applicationLastUpdateDate()));
        case "applicationState":
            return Optional.ofNullable(clazz.cast(applicationStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSummary, T> g) {
        return obj -> g.apply((ApplicationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationSummary> {
        /**
         * <p>
         * The unique Id of the web application.
         * </p>
         * 
         * @param applicationId
         *        The unique Id of the web application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The name of the web application.
         * </p>
         * 
         * @param applicationName
         *        The name of the web application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * An optional description of the web application.
         * </p>
         * 
         * @param applicationDescription
         *        An optional description of the web application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationDescription(String applicationDescription);

        /**
         * <p>
         * The URL of the web application.
         * </p>
         * 
         * @param applicationUrl
         *        The URL of the web application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationUrl(String applicationUrl);

        /**
         * <p>
         * The date (in Unix epoch time) when the web application was created.
         * </p>
         * 
         * @param applicationCreationDate
         *        The date (in Unix epoch time) when the web application was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationCreationDate(Long applicationCreationDate);

        /**
         * <p>
         * The date (in Unix epoch time) when the web application was last updated.
         * </p>
         * 
         * @param applicationLastUpdateDate
         *        The date (in Unix epoch time) when the web application was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationLastUpdateDate(Long applicationLastUpdateDate);

        /**
         * <p>
         * The current state of the web application.
         * </p>
         * 
         * @param applicationState
         *        The current state of the web application.
         * @see ApplicationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationState
         */
        Builder applicationState(String applicationState);

        /**
         * <p>
         * The current state of the web application.
         * </p>
         * 
         * @param applicationState
         *        The current state of the web application.
         * @see ApplicationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplicationState
         */
        Builder applicationState(ApplicationState applicationState);
    }

    static final class BuilderImpl implements Builder {
        private String applicationId;

        private String applicationName;

        private String applicationDescription;

        private String applicationUrl;

        private Long applicationCreationDate;

        private Long applicationLastUpdateDate;

        private String applicationState;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSummary model) {
            applicationId(model.applicationId);
            applicationName(model.applicationName);
            applicationDescription(model.applicationDescription);
            applicationUrl(model.applicationUrl);
            applicationCreationDate(model.applicationCreationDate);
            applicationLastUpdateDate(model.applicationLastUpdateDate);
            applicationState(model.applicationState);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getApplicationDescription() {
            return applicationDescription;
        }

        public final void setApplicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        @Override
        public final Builder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public final String getApplicationUrl() {
            return applicationUrl;
        }

        public final void setApplicationUrl(String applicationUrl) {
            this.applicationUrl = applicationUrl;
        }

        @Override
        public final Builder applicationUrl(String applicationUrl) {
            this.applicationUrl = applicationUrl;
            return this;
        }

        public final Long getApplicationCreationDate() {
            return applicationCreationDate;
        }

        public final void setApplicationCreationDate(Long applicationCreationDate) {
            this.applicationCreationDate = applicationCreationDate;
        }

        @Override
        public final Builder applicationCreationDate(Long applicationCreationDate) {
            this.applicationCreationDate = applicationCreationDate;
            return this;
        }

        public final Long getApplicationLastUpdateDate() {
            return applicationLastUpdateDate;
        }

        public final void setApplicationLastUpdateDate(Long applicationLastUpdateDate) {
            this.applicationLastUpdateDate = applicationLastUpdateDate;
        }

        @Override
        public final Builder applicationLastUpdateDate(Long applicationLastUpdateDate) {
            this.applicationLastUpdateDate = applicationLastUpdateDate;
            return this;
        }

        public final String getApplicationState() {
            return applicationState;
        }

        public final void setApplicationState(String applicationState) {
            this.applicationState = applicationState;
        }

        @Override
        public final Builder applicationState(String applicationState) {
            this.applicationState = applicationState;
            return this;
        }

        @Override
        public final Builder applicationState(ApplicationState applicationState) {
            this.applicationState(applicationState == null ? null : applicationState.toString());
            return this;
        }

        @Override
        public ApplicationSummary build() {
            return new ApplicationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
