/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information needed to evaluate data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleEvaluation implements SdkPojo, Serializable, ToCopyableBuilder<RuleEvaluation.Builder, RuleEvaluation> {
    private static final SdkField<SimpleRuleEvaluation> SIMPLE_RULE_EVALUATION_FIELD = SdkField
            .<SimpleRuleEvaluation> builder(MarshallingType.SDK_POJO).memberName("simpleRuleEvaluation")
            .getter(getter(RuleEvaluation::simpleRuleEvaluation)).setter(setter(Builder::simpleRuleEvaluation))
            .constructor(SimpleRuleEvaluation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("simpleRuleEvaluation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIMPLE_RULE_EVALUATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SimpleRuleEvaluation simpleRuleEvaluation;

    private RuleEvaluation(BuilderImpl builder) {
        this.simpleRuleEvaluation = builder.simpleRuleEvaluation;
    }

    /**
     * <p>
     * Information needed to compare two values with a comparison operator.
     * </p>
     * 
     * @return Information needed to compare two values with a comparison operator.
     */
    public final SimpleRuleEvaluation simpleRuleEvaluation() {
        return simpleRuleEvaluation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(simpleRuleEvaluation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleEvaluation)) {
            return false;
        }
        RuleEvaluation other = (RuleEvaluation) obj;
        return Objects.equals(simpleRuleEvaluation(), other.simpleRuleEvaluation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleEvaluation").add("SimpleRuleEvaluation", simpleRuleEvaluation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "simpleRuleEvaluation":
            return Optional.ofNullable(clazz.cast(simpleRuleEvaluation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("simpleRuleEvaluation", SIMPLE_RULE_EVALUATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleEvaluation, T> g) {
        return obj -> g.apply((RuleEvaluation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleEvaluation> {
        /**
         * <p>
         * Information needed to compare two values with a comparison operator.
         * </p>
         * 
         * @param simpleRuleEvaluation
         *        Information needed to compare two values with a comparison operator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder simpleRuleEvaluation(SimpleRuleEvaluation simpleRuleEvaluation);

        /**
         * <p>
         * Information needed to compare two values with a comparison operator.
         * </p>
         * This is a convenience method that creates an instance of the {@link SimpleRuleEvaluation.Builder} avoiding
         * the need to create one manually via {@link SimpleRuleEvaluation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SimpleRuleEvaluation.Builder#build()} is called immediately and
         * its result is passed to {@link #simpleRuleEvaluation(SimpleRuleEvaluation)}.
         * 
         * @param simpleRuleEvaluation
         *        a consumer that will call methods on {@link SimpleRuleEvaluation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #simpleRuleEvaluation(SimpleRuleEvaluation)
         */
        default Builder simpleRuleEvaluation(Consumer<SimpleRuleEvaluation.Builder> simpleRuleEvaluation) {
            return simpleRuleEvaluation(SimpleRuleEvaluation.builder().applyMutation(simpleRuleEvaluation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SimpleRuleEvaluation simpleRuleEvaluation;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleEvaluation model) {
            simpleRuleEvaluation(model.simpleRuleEvaluation);
        }

        public final SimpleRuleEvaluation.Builder getSimpleRuleEvaluation() {
            return simpleRuleEvaluation != null ? simpleRuleEvaluation.toBuilder() : null;
        }

        public final void setSimpleRuleEvaluation(SimpleRuleEvaluation.BuilderImpl simpleRuleEvaluation) {
            this.simpleRuleEvaluation = simpleRuleEvaluation != null ? simpleRuleEvaluation.build() : null;
        }

        @Override
        public final Builder simpleRuleEvaluation(SimpleRuleEvaluation simpleRuleEvaluation) {
            this.simpleRuleEvaluation = simpleRuleEvaluation;
            return this;
        }

        @Override
        public RuleEvaluation build() {
            return new RuleEvaluation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
