/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information used to delete the detector model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDetectorRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<DeleteDetectorRequest.Builder, DeleteDetectorRequest> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageId").getter(getter(DeleteDetectorRequest::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageId").build()).build();

    private static final SdkField<String> DETECTOR_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorModelName").getter(getter(DeleteDetectorRequest::detectorModelName))
            .setter(setter(Builder::detectorModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelName").build()).build();

    private static final SdkField<String> KEY_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyValue").getter(getter(DeleteDetectorRequest::keyValue)).setter(setter(Builder::keyValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD,
            DETECTOR_MODEL_NAME_FIELD, KEY_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String messageId;

    private final String detectorModelName;

    private final String keyValue;

    private DeleteDetectorRequest(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.detectorModelName = builder.detectorModelName;
        this.keyValue = builder.keyValue;
    }

    /**
     * <p>
     * The ID to assign to the <code>DeleteDetectorRequest</code>. Each <code>"messageId"</code> must be unique within
     * each batch sent.
     * </p>
     * 
     * @return The ID to assign to the <code>DeleteDetectorRequest</code>. Each <code>"messageId"</code> must be unique
     *         within each batch sent.
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * <p>
     * The name of the detector model that was used to create the detector instance.
     * </p>
     * 
     * @return The name of the detector model that was used to create the detector instance.
     */
    public final String detectorModelName() {
        return detectorModelName;
    }

    /**
     * <p>
     * The value of the <a href=
     * "https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateDetectorModel.html#iotevents-CreateDetectorModel-request-key"
     * >key</a> used to identify the detector.
     * </p>
     * 
     * @return The value of the <a href=
     *         "https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateDetectorModel.html#iotevents-CreateDetectorModel-request-key"
     *         >key</a> used to identify the detector.
     */
    public final String keyValue() {
        return keyValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(detectorModelName());
        hashCode = 31 * hashCode + Objects.hashCode(keyValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDetectorRequest)) {
            return false;
        }
        DeleteDetectorRequest other = (DeleteDetectorRequest) obj;
        return Objects.equals(messageId(), other.messageId()) && Objects.equals(detectorModelName(), other.detectorModelName())
                && Objects.equals(keyValue(), other.keyValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDetectorRequest").add("MessageId", messageId())
                .add("DetectorModelName", detectorModelName()).add("KeyValue", keyValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "messageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "detectorModelName":
            return Optional.ofNullable(clazz.cast(detectorModelName()));
        case "keyValue":
            return Optional.ofNullable(clazz.cast(keyValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("messageId", MESSAGE_ID_FIELD);
        map.put("detectorModelName", DETECTOR_MODEL_NAME_FIELD);
        map.put("keyValue", KEY_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteDetectorRequest, T> g) {
        return obj -> g.apply((DeleteDetectorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeleteDetectorRequest> {
        /**
         * <p>
         * The ID to assign to the <code>DeleteDetectorRequest</code>. Each <code>"messageId"</code> must be unique
         * within each batch sent.
         * </p>
         * 
         * @param messageId
         *        The ID to assign to the <code>DeleteDetectorRequest</code>. Each <code>"messageId"</code> must be
         *        unique within each batch sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * The name of the detector model that was used to create the detector instance.
         * </p>
         * 
         * @param detectorModelName
         *        The name of the detector model that was used to create the detector instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorModelName(String detectorModelName);

        /**
         * <p>
         * The value of the <a href=
         * "https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateDetectorModel.html#iotevents-CreateDetectorModel-request-key"
         * >key</a> used to identify the detector.
         * </p>
         * 
         * @param keyValue
         *        The value of the <a href=
         *        "https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateDetectorModel.html#iotevents-CreateDetectorModel-request-key"
         *        >key</a> used to identify the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyValue(String keyValue);
    }

    static final class BuilderImpl implements Builder {
        private String messageId;

        private String detectorModelName;

        private String keyValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDetectorRequest model) {
            messageId(model.messageId);
            detectorModelName(model.detectorModelName);
            keyValue(model.keyValue);
        }

        public final String getMessageId() {
            return messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final String getDetectorModelName() {
            return detectorModelName;
        }

        public final void setDetectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
        }

        @Override
        public final Builder detectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
            return this;
        }

        public final String getKeyValue() {
            return keyValue;
        }

        public final void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        @Override
        public final Builder keyValue(String keyValue) {
            this.keyValue = keyValue;
            return this;
        }

        @Override
        public DeleteDetectorRequest build() {
            return new DeleteDetectorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
