/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchEnableAlarmRequest extends IotEventsDataRequest implements
        ToCopyableBuilder<BatchEnableAlarmRequest.Builder, BatchEnableAlarmRequest> {
    private static final SdkField<List<EnableAlarmActionRequest>> ENABLE_ACTION_REQUESTS_FIELD = SdkField
            .<List<EnableAlarmActionRequest>> builder(MarshallingType.LIST)
            .memberName("enableActionRequests")
            .getter(getter(BatchEnableAlarmRequest::enableActionRequests))
            .setter(setter(Builder::enableActionRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableActionRequests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnableAlarmActionRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnableAlarmActionRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_ACTION_REQUESTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<EnableAlarmActionRequest> enableActionRequests;

    private BatchEnableAlarmRequest(BuilderImpl builder) {
        super(builder);
        this.enableActionRequests = builder.enableActionRequests;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnableActionRequests property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnableActionRequests() {
        return enableActionRequests != null && !(enableActionRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of enable action requests. You can specify up to 10 requests per operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnableActionRequests} method.
     * </p>
     * 
     * @return The list of enable action requests. You can specify up to 10 requests per operation.
     */
    public final List<EnableAlarmActionRequest> enableActionRequests() {
        return enableActionRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEnableActionRequests() ? enableActionRequests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchEnableAlarmRequest)) {
            return false;
        }
        BatchEnableAlarmRequest other = (BatchEnableAlarmRequest) obj;
        return hasEnableActionRequests() == other.hasEnableActionRequests()
                && Objects.equals(enableActionRequests(), other.enableActionRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchEnableAlarmRequest")
                .add("EnableActionRequests", hasEnableActionRequests() ? enableActionRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enableActionRequests":
            return Optional.ofNullable(clazz.cast(enableActionRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enableActionRequests", ENABLE_ACTION_REQUESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchEnableAlarmRequest, T> g) {
        return obj -> g.apply((BatchEnableAlarmRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IotEventsDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchEnableAlarmRequest> {
        /**
         * <p>
         * The list of enable action requests. You can specify up to 10 requests per operation.
         * </p>
         * 
         * @param enableActionRequests
         *        The list of enable action requests. You can specify up to 10 requests per operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableActionRequests(Collection<EnableAlarmActionRequest> enableActionRequests);

        /**
         * <p>
         * The list of enable action requests. You can specify up to 10 requests per operation.
         * </p>
         * 
         * @param enableActionRequests
         *        The list of enable action requests. You can specify up to 10 requests per operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableActionRequests(EnableAlarmActionRequest... enableActionRequests);

        /**
         * <p>
         * The list of enable action requests. You can specify up to 10 requests per operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ioteventsdata.model.EnableAlarmActionRequest.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.ioteventsdata.model.EnableAlarmActionRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ioteventsdata.model.EnableAlarmActionRequest.Builder#build()} is
         * called immediately and its result is passed to {@link #enableActionRequests(List<EnableAlarmActionRequest>)}.
         * 
         * @param enableActionRequests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ioteventsdata.model.EnableAlarmActionRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enableActionRequests(java.util.Collection<EnableAlarmActionRequest>)
         */
        Builder enableActionRequests(Consumer<EnableAlarmActionRequest.Builder>... enableActionRequests);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotEventsDataRequest.BuilderImpl implements Builder {
        private List<EnableAlarmActionRequest> enableActionRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchEnableAlarmRequest model) {
            super(model);
            enableActionRequests(model.enableActionRequests);
        }

        public final List<EnableAlarmActionRequest.Builder> getEnableActionRequests() {
            List<EnableAlarmActionRequest.Builder> result = EnableAlarmActionRequestsCopier
                    .copyToBuilder(this.enableActionRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnableActionRequests(Collection<EnableAlarmActionRequest.BuilderImpl> enableActionRequests) {
            this.enableActionRequests = EnableAlarmActionRequestsCopier.copyFromBuilder(enableActionRequests);
        }

        @Override
        public final Builder enableActionRequests(Collection<EnableAlarmActionRequest> enableActionRequests) {
            this.enableActionRequests = EnableAlarmActionRequestsCopier.copy(enableActionRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableActionRequests(EnableAlarmActionRequest... enableActionRequests) {
            enableActionRequests(Arrays.asList(enableActionRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableActionRequests(Consumer<EnableAlarmActionRequest.Builder>... enableActionRequests) {
            enableActionRequests(Stream.of(enableActionRequests)
                    .map(c -> EnableAlarmActionRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchEnableAlarmRequest build() {
            return new BatchEnableAlarmRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
