/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information needed to acknowledge the alarm.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcknowledgeAlarmActionRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<AcknowledgeAlarmActionRequest.Builder, AcknowledgeAlarmActionRequest> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestId").getter(getter(AcknowledgeAlarmActionRequest::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()).build();

    private static final SdkField<String> ALARM_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alarmModelName").getter(getter(AcknowledgeAlarmActionRequest::alarmModelName))
            .setter(setter(Builder::alarmModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelName").build()).build();

    private static final SdkField<String> KEY_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyValue").getter(getter(AcknowledgeAlarmActionRequest::keyValue)).setter(setter(Builder::keyValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyValue").build()).build();

    private static final SdkField<String> NOTE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("note")
            .getter(getter(AcknowledgeAlarmActionRequest::note)).setter(setter(Builder::note))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("note").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            ALARM_MODEL_NAME_FIELD, KEY_VALUE_FIELD, NOTE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String requestIdValue;

    private final String alarmModelName;

    private final String keyValue;

    private final String note;

    private AcknowledgeAlarmActionRequest(BuilderImpl builder) {
        this.requestIdValue = builder.requestIdValue;
        this.alarmModelName = builder.alarmModelName;
        this.keyValue = builder.keyValue;
        this.note = builder.note;
    }

    /**
     * <p>
     * The request ID. Each ID must be unique within each batch.
     * </p>
     * 
     * @return The request ID. Each ID must be unique within each batch.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * <p>
     * The name of the alarm model.
     * </p>
     * 
     * @return The name of the alarm model.
     */
    public final String alarmModelName() {
        return alarmModelName;
    }

    /**
     * <p>
     * The value of the key used as a filter to select only the alarms associated with the <a href=
     * "https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key"
     * >key</a>.
     * </p>
     * 
     * @return The value of the key used as a filter to select only the alarms associated with the <a href=
     *         "https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key"
     *         >key</a>.
     */
    public final String keyValue() {
        return keyValue;
    }

    /**
     * <p>
     * The note that you can leave when you acknowledge the alarm.
     * </p>
     * 
     * @return The note that you can leave when you acknowledge the alarm.
     */
    public final String note() {
        return note;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(alarmModelName());
        hashCode = 31 * hashCode + Objects.hashCode(keyValue());
        hashCode = 31 * hashCode + Objects.hashCode(note());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcknowledgeAlarmActionRequest)) {
            return false;
        }
        AcknowledgeAlarmActionRequest other = (AcknowledgeAlarmActionRequest) obj;
        return Objects.equals(requestId(), other.requestId()) && Objects.equals(alarmModelName(), other.alarmModelName())
                && Objects.equals(keyValue(), other.keyValue()) && Objects.equals(note(), other.note());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcknowledgeAlarmActionRequest").add("RequestId", requestId())
                .add("AlarmModelName", alarmModelName()).add("KeyValue", keyValue()).add("Note", note()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "alarmModelName":
            return Optional.ofNullable(clazz.cast(alarmModelName()));
        case "keyValue":
            return Optional.ofNullable(clazz.cast(keyValue()));
        case "note":
            return Optional.ofNullable(clazz.cast(note()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("alarmModelName", ALARM_MODEL_NAME_FIELD);
        map.put("keyValue", KEY_VALUE_FIELD);
        map.put("note", NOTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AcknowledgeAlarmActionRequest, T> g) {
        return obj -> g.apply((AcknowledgeAlarmActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AcknowledgeAlarmActionRequest> {
        /**
         * <p>
         * The request ID. Each ID must be unique within each batch.
         * </p>
         * 
         * @param requestIdValue
         *        The request ID. Each ID must be unique within each batch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * The name of the alarm model.
         * </p>
         * 
         * @param alarmModelName
         *        The name of the alarm model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmModelName(String alarmModelName);

        /**
         * <p>
         * The value of the key used as a filter to select only the alarms associated with the <a href=
         * "https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key"
         * >key</a>.
         * </p>
         * 
         * @param keyValue
         *        The value of the key used as a filter to select only the alarms associated with the <a href=
         *        "https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key"
         *        >key</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyValue(String keyValue);

        /**
         * <p>
         * The note that you can leave when you acknowledge the alarm.
         * </p>
         * 
         * @param note
         *        The note that you can leave when you acknowledge the alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder note(String note);
    }

    static final class BuilderImpl implements Builder {
        private String requestIdValue;

        private String alarmModelName;

        private String keyValue;

        private String note;

        private BuilderImpl() {
        }

        private BuilderImpl(AcknowledgeAlarmActionRequest model) {
            requestId(model.requestIdValue);
            alarmModelName(model.alarmModelName);
            keyValue(model.keyValue);
            note(model.note);
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final String getAlarmModelName() {
            return alarmModelName;
        }

        public final void setAlarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
        }

        @Override
        public final Builder alarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
            return this;
        }

        public final String getKeyValue() {
            return keyValue;
        }

        public final void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        @Override
        public final Builder keyValue(String keyValue) {
            this.keyValue = keyValue;
            return this;
        }

        public final String getNote() {
            return note;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        @Override
        public final Builder note(String note) {
            this.note = note;
            return this;
        }

        @Override
        public AcknowledgeAlarmActionRequest build() {
            return new AcknowledgeAlarmActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
