/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ioteventsdata.model.AlarmStateName;
import software.amazon.awssdk.services.ioteventsdata.model.CustomerAction;
import software.amazon.awssdk.services.ioteventsdata.model.RuleEvaluation;
import software.amazon.awssdk.services.ioteventsdata.model.SystemEvent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlarmState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlarmState> {
    private static final SdkField<String> STATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateName").getter(AlarmState.getter(AlarmState::stateNameAsString)).setter(AlarmState.setter(Builder::stateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateName").build()}).build();
    private static final SdkField<RuleEvaluation> RULE_EVALUATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ruleEvaluation").getter(AlarmState.getter(AlarmState::ruleEvaluation)).setter(AlarmState.setter(Builder::ruleEvaluation)).constructor(RuleEvaluation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleEvaluation").build()}).build();
    private static final SdkField<CustomerAction> CUSTOMER_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customerAction").getter(AlarmState.getter(AlarmState::customerAction)).setter(AlarmState.setter(Builder::customerAction)).constructor(CustomerAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerAction").build()}).build();
    private static final SdkField<SystemEvent> SYSTEM_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("systemEvent").getter(AlarmState.getter(AlarmState::systemEvent)).setter(AlarmState.setter(Builder::systemEvent)).constructor(SystemEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemEvent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_NAME_FIELD, RULE_EVALUATION_FIELD, CUSTOMER_ACTION_FIELD, SYSTEM_EVENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AlarmState.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String stateName;
    private final RuleEvaluation ruleEvaluation;
    private final CustomerAction customerAction;
    private final SystemEvent systemEvent;

    private AlarmState(BuilderImpl builder) {
        this.stateName = builder.stateName;
        this.ruleEvaluation = builder.ruleEvaluation;
        this.customerAction = builder.customerAction;
        this.systemEvent = builder.systemEvent;
    }

    public final AlarmStateName stateName() {
        return AlarmStateName.fromValue(this.stateName);
    }

    public final String stateNameAsString() {
        return this.stateName;
    }

    public final RuleEvaluation ruleEvaluation() {
        return this.ruleEvaluation;
    }

    public final CustomerAction customerAction() {
        return this.customerAction;
    }

    public final SystemEvent systemEvent() {
        return this.systemEvent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleEvaluation());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemEvent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmState)) {
            return false;
        }
        AlarmState other = (AlarmState)obj;
        return Objects.equals(this.stateNameAsString(), other.stateNameAsString()) && Objects.equals(this.ruleEvaluation(), other.ruleEvaluation()) && Objects.equals(this.customerAction(), other.customerAction()) && Objects.equals(this.systemEvent(), other.systemEvent());
    }

    public final String toString() {
        return ToString.builder((String)"AlarmState").add("StateName", (Object)this.stateNameAsString()).add("RuleEvaluation", (Object)this.ruleEvaluation()).add("CustomerAction", (Object)this.customerAction()).add("SystemEvent", (Object)this.systemEvent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stateName": {
                return Optional.ofNullable(clazz.cast(this.stateNameAsString()));
            }
            case "ruleEvaluation": {
                return Optional.ofNullable(clazz.cast(this.ruleEvaluation()));
            }
            case "customerAction": {
                return Optional.ofNullable(clazz.cast(this.customerAction()));
            }
            case "systemEvent": {
                return Optional.ofNullable(clazz.cast(this.systemEvent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("stateName", STATE_NAME_FIELD);
        map.put("ruleEvaluation", RULE_EVALUATION_FIELD);
        map.put("customerAction", CUSTOMER_ACTION_FIELD);
        map.put("systemEvent", SYSTEM_EVENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AlarmState, T> g) {
        return obj -> g.apply((AlarmState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stateName;
        private RuleEvaluation ruleEvaluation;
        private CustomerAction customerAction;
        private SystemEvent systemEvent;

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmState model) {
            this.stateName(model.stateName);
            this.ruleEvaluation(model.ruleEvaluation);
            this.customerAction(model.customerAction);
            this.systemEvent(model.systemEvent);
        }

        public final String getStateName() {
            return this.stateName;
        }

        public final void setStateName(String stateName) {
            this.stateName = stateName;
        }

        @Override
        public final Builder stateName(String stateName) {
            this.stateName = stateName;
            return this;
        }

        @Override
        public final Builder stateName(AlarmStateName stateName) {
            this.stateName(stateName == null ? null : stateName.toString());
            return this;
        }

        public final RuleEvaluation.Builder getRuleEvaluation() {
            return this.ruleEvaluation != null ? this.ruleEvaluation.toBuilder() : null;
        }

        public final void setRuleEvaluation(RuleEvaluation.BuilderImpl ruleEvaluation) {
            this.ruleEvaluation = ruleEvaluation != null ? ruleEvaluation.build() : null;
        }

        @Override
        public final Builder ruleEvaluation(RuleEvaluation ruleEvaluation) {
            this.ruleEvaluation = ruleEvaluation;
            return this;
        }

        public final CustomerAction.Builder getCustomerAction() {
            return this.customerAction != null ? this.customerAction.toBuilder() : null;
        }

        public final void setCustomerAction(CustomerAction.BuilderImpl customerAction) {
            this.customerAction = customerAction != null ? customerAction.build() : null;
        }

        @Override
        public final Builder customerAction(CustomerAction customerAction) {
            this.customerAction = customerAction;
            return this;
        }

        public final SystemEvent.Builder getSystemEvent() {
            return this.systemEvent != null ? this.systemEvent.toBuilder() : null;
        }

        public final void setSystemEvent(SystemEvent.BuilderImpl systemEvent) {
            this.systemEvent = systemEvent != null ? systemEvent.build() : null;
        }

        @Override
        public final Builder systemEvent(SystemEvent systemEvent) {
            this.systemEvent = systemEvent;
            return this;
        }

        public AlarmState build() {
            return new AlarmState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlarmState> {
        public Builder stateName(String var1);

        public Builder stateName(AlarmStateName var1);

        public Builder ruleEvaluation(RuleEvaluation var1);

        default public Builder ruleEvaluation(Consumer<RuleEvaluation.Builder> ruleEvaluation) {
            return this.ruleEvaluation((RuleEvaluation)((RuleEvaluation.Builder)RuleEvaluation.builder().applyMutation(ruleEvaluation)).build());
        }

        public Builder customerAction(CustomerAction var1);

        default public Builder customerAction(Consumer<CustomerAction.Builder> customerAction) {
            return this.customerAction((CustomerAction)((CustomerAction.Builder)CustomerAction.builder().applyMutation(customerAction)).build());
        }

        public Builder systemEvent(SystemEvent var1);

        default public Builder systemEvent(Consumer<SystemEvent.Builder> systemEvent) {
            return this.systemEvent((SystemEvent)((SystemEvent.Builder)SystemEvent.builder().applyMutation(systemEvent)).build());
        }
    }
}

