/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ioteventsdata.model.DetectorSummariesCopier;
import software.amazon.awssdk.services.ioteventsdata.model.DetectorSummary;
import software.amazon.awssdk.services.ioteventsdata.model.IotEventsDataResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDetectorsResponse
extends IotEventsDataResponse
implements ToCopyableBuilder<Builder, ListDetectorsResponse> {
    private static final SdkField<List<DetectorSummary>> DETECTOR_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("detectorSummaries").getter(ListDetectorsResponse.getter(ListDetectorsResponse::detectorSummaries)).setter(ListDetectorsResponse.setter(Builder::detectorSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DetectorSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDetectorsResponse.getter(ListDetectorsResponse::nextToken)).setter(ListDetectorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDetectorsResponse.memberNameToFieldInitializer();
    private final List<DetectorSummary> detectorSummaries;
    private final String nextToken;

    private ListDetectorsResponse(BuilderImpl builder) {
        super(builder);
        this.detectorSummaries = builder.detectorSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDetectorSummaries() {
        return this.detectorSummaries != null && !(this.detectorSummaries instanceof SdkAutoConstructList);
    }

    public final List<DetectorSummary> detectorSummaries() {
        return this.detectorSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetectorSummaries() ? this.detectorSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDetectorsResponse)) {
            return false;
        }
        ListDetectorsResponse other = (ListDetectorsResponse)((Object)obj);
        return this.hasDetectorSummaries() == other.hasDetectorSummaries() && Objects.equals(this.detectorSummaries(), other.detectorSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDetectorsResponse").add("DetectorSummaries", this.hasDetectorSummaries() ? this.detectorSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detectorSummaries": {
                return Optional.ofNullable(clazz.cast(this.detectorSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("detectorSummaries", DETECTOR_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDetectorsResponse, T> g) {
        return obj -> g.apply((ListDetectorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotEventsDataResponse.BuilderImpl
    implements Builder {
        private List<DetectorSummary> detectorSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDetectorsResponse model) {
            super(model);
            this.detectorSummaries(model.detectorSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<DetectorSummary.Builder> getDetectorSummaries() {
            List<DetectorSummary.Builder> result = DetectorSummariesCopier.copyToBuilder(this.detectorSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDetectorSummaries(Collection<DetectorSummary.BuilderImpl> detectorSummaries) {
            this.detectorSummaries = DetectorSummariesCopier.copyFromBuilder(detectorSummaries);
        }

        @Override
        public final Builder detectorSummaries(Collection<DetectorSummary> detectorSummaries) {
            this.detectorSummaries = DetectorSummariesCopier.copy(detectorSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectorSummaries(DetectorSummary ... detectorSummaries) {
            this.detectorSummaries(Arrays.asList(detectorSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectorSummaries(Consumer<DetectorSummary.Builder> ... detectorSummaries) {
            this.detectorSummaries(Stream.of(detectorSummaries).map(c -> (DetectorSummary)((DetectorSummary.Builder)DetectorSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDetectorsResponse build() {
            return new ListDetectorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotEventsDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDetectorsResponse> {
        public Builder detectorSummaries(Collection<DetectorSummary> var1);

        public Builder detectorSummaries(DetectorSummary ... var1);

        public Builder detectorSummaries(Consumer<DetectorSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

