/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ioteventsdata.model.ComparisonOperator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SimpleRuleEvaluation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SimpleRuleEvaluation> {
    private static final SdkField<String> INPUT_PROPERTY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputPropertyValue").getter(SimpleRuleEvaluation.getter(SimpleRuleEvaluation::inputPropertyValue)).setter(SimpleRuleEvaluation.setter(Builder::inputPropertyValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputPropertyValue").build()}).build();
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operator").getter(SimpleRuleEvaluation.getter(SimpleRuleEvaluation::operatorAsString)).setter(SimpleRuleEvaluation.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()}).build();
    private static final SdkField<String> THRESHOLD_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thresholdValue").getter(SimpleRuleEvaluation.getter(SimpleRuleEvaluation::thresholdValue)).setter(SimpleRuleEvaluation.setter(Builder::thresholdValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thresholdValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_PROPERTY_VALUE_FIELD, OPERATOR_FIELD, THRESHOLD_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String inputPropertyValue;
    private final String operator;
    private final String thresholdValue;

    private SimpleRuleEvaluation(BuilderImpl builder) {
        this.inputPropertyValue = builder.inputPropertyValue;
        this.operator = builder.operator;
        this.thresholdValue = builder.thresholdValue;
    }

    public final String inputPropertyValue() {
        return this.inputPropertyValue;
    }

    public final ComparisonOperator operator() {
        return ComparisonOperator.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public final String thresholdValue() {
        return this.thresholdValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputPropertyValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.thresholdValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SimpleRuleEvaluation)) {
            return false;
        }
        SimpleRuleEvaluation other = (SimpleRuleEvaluation)obj;
        return Objects.equals(this.inputPropertyValue(), other.inputPropertyValue()) && Objects.equals(this.operatorAsString(), other.operatorAsString()) && Objects.equals(this.thresholdValue(), other.thresholdValue());
    }

    public final String toString() {
        return ToString.builder((String)"SimpleRuleEvaluation").add("InputPropertyValue", (Object)this.inputPropertyValue()).add("Operator", (Object)this.operatorAsString()).add("ThresholdValue", (Object)this.thresholdValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputPropertyValue": {
                return Optional.ofNullable(clazz.cast(this.inputPropertyValue()));
            }
            case "operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
            case "thresholdValue": {
                return Optional.ofNullable(clazz.cast(this.thresholdValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SimpleRuleEvaluation, T> g) {
        return obj -> g.apply((SimpleRuleEvaluation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputPropertyValue;
        private String operator;
        private String thresholdValue;

        private BuilderImpl() {
        }

        private BuilderImpl(SimpleRuleEvaluation model) {
            this.inputPropertyValue(model.inputPropertyValue);
            this.operator(model.operator);
            this.thresholdValue(model.thresholdValue);
        }

        public final String getInputPropertyValue() {
            return this.inputPropertyValue;
        }

        public final void setInputPropertyValue(String inputPropertyValue) {
            this.inputPropertyValue = inputPropertyValue;
        }

        @Override
        public final Builder inputPropertyValue(String inputPropertyValue) {
            this.inputPropertyValue = inputPropertyValue;
            return this;
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(ComparisonOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final String getThresholdValue() {
            return this.thresholdValue;
        }

        public final void setThresholdValue(String thresholdValue) {
            this.thresholdValue = thresholdValue;
        }

        @Override
        public final Builder thresholdValue(String thresholdValue) {
            this.thresholdValue = thresholdValue;
            return this;
        }

        public SimpleRuleEvaluation build() {
            return new SimpleRuleEvaluation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SimpleRuleEvaluation> {
        public Builder inputPropertyValue(String var1);

        public Builder operator(String var1);

        public Builder operator(ComparisonOperator var1);

        public Builder thresholdValue(String var1);
    }
}

