/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ioteventsdata.model.EventType;
import software.amazon.awssdk.services.ioteventsdata.model.StateChangeConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SystemEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SystemEvent> {
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventType").getter(SystemEvent.getter(SystemEvent::eventTypeAsString)).setter(SystemEvent.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()}).build();
    private static final SdkField<StateChangeConfiguration> STATE_CHANGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("stateChangeConfiguration").getter(SystemEvent.getter(SystemEvent::stateChangeConfiguration)).setter(SystemEvent.setter(Builder::stateChangeConfiguration)).constructor(StateChangeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateChangeConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_FIELD, STATE_CHANGE_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String eventType;
    private final StateChangeConfiguration stateChangeConfiguration;

    private SystemEvent(BuilderImpl builder) {
        this.eventType = builder.eventType;
        this.stateChangeConfiguration = builder.stateChangeConfiguration;
    }

    public final EventType eventType() {
        return EventType.fromValue(this.eventType);
    }

    public final String eventTypeAsString() {
        return this.eventType;
    }

    public final StateChangeConfiguration stateChangeConfiguration() {
        return this.stateChangeConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemEvent)) {
            return false;
        }
        SystemEvent other = (SystemEvent)obj;
        return Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(this.stateChangeConfiguration(), other.stateChangeConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"SystemEvent").add("EventType", (Object)this.eventTypeAsString()).add("StateChangeConfiguration", (Object)this.stateChangeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "stateChangeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.stateChangeConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SystemEvent, T> g) {
        return obj -> g.apply((SystemEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventType;
        private StateChangeConfiguration stateChangeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SystemEvent model) {
            this.eventType(model.eventType);
            this.stateChangeConfiguration(model.stateChangeConfiguration);
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(EventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final StateChangeConfiguration.Builder getStateChangeConfiguration() {
            return this.stateChangeConfiguration != null ? this.stateChangeConfiguration.toBuilder() : null;
        }

        public final void setStateChangeConfiguration(StateChangeConfiguration.BuilderImpl stateChangeConfiguration) {
            this.stateChangeConfiguration = stateChangeConfiguration != null ? stateChangeConfiguration.build() : null;
        }

        @Override
        public final Builder stateChangeConfiguration(StateChangeConfiguration stateChangeConfiguration) {
            this.stateChangeConfiguration = stateChangeConfiguration;
            return this;
        }

        public SystemEvent build() {
            return new SystemEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SystemEvent> {
        public Builder eventType(String var1);

        public Builder eventType(EventType var1);

        public Builder stateChangeConfiguration(StateChangeConfiguration var1);

        default public Builder stateChangeConfiguration(Consumer<StateChangeConfiguration.Builder> stateChangeConfiguration) {
            return this.stateChangeConfiguration((StateChangeConfiguration)((StateChangeConfiguration.Builder)StateChangeConfiguration.builder().applyMutation(stateChangeConfiguration)).build());
        }
    }
}

