/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ioteventsdata.model.IotEventsDataRequest;
import software.amazon.awssdk.services.ioteventsdata.model.ResetAlarmActionRequest;
import software.amazon.awssdk.services.ioteventsdata.model.ResetAlarmActionRequestsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchResetAlarmRequest
extends IotEventsDataRequest
implements ToCopyableBuilder<Builder, BatchResetAlarmRequest> {
    private static final SdkField<List<ResetAlarmActionRequest>> RESET_ACTION_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resetActionRequests").getter(BatchResetAlarmRequest.getter(BatchResetAlarmRequest::resetActionRequests)).setter(BatchResetAlarmRequest.setter(Builder::resetActionRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resetActionRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResetAlarmActionRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESET_ACTION_REQUESTS_FIELD));
    private final List<ResetAlarmActionRequest> resetActionRequests;

    private BatchResetAlarmRequest(BuilderImpl builder) {
        super(builder);
        this.resetActionRequests = builder.resetActionRequests;
    }

    public final boolean hasResetActionRequests() {
        return this.resetActionRequests != null && !(this.resetActionRequests instanceof SdkAutoConstructList);
    }

    public final List<ResetAlarmActionRequest> resetActionRequests() {
        return this.resetActionRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResetActionRequests() ? this.resetActionRequests() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchResetAlarmRequest)) {
            return false;
        }
        BatchResetAlarmRequest other = (BatchResetAlarmRequest)((Object)obj);
        return this.hasResetActionRequests() == other.hasResetActionRequests() && Objects.equals(this.resetActionRequests(), other.resetActionRequests());
    }

    public final String toString() {
        return ToString.builder((String)"BatchResetAlarmRequest").add("ResetActionRequests", this.hasResetActionRequests() ? this.resetActionRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resetActionRequests": {
                return Optional.ofNullable(clazz.cast(this.resetActionRequests()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchResetAlarmRequest, T> g) {
        return obj -> g.apply((BatchResetAlarmRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotEventsDataRequest.BuilderImpl
    implements Builder {
        private List<ResetAlarmActionRequest> resetActionRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchResetAlarmRequest model) {
            super(model);
            this.resetActionRequests(model.resetActionRequests);
        }

        public final List<ResetAlarmActionRequest.Builder> getResetActionRequests() {
            List<ResetAlarmActionRequest.Builder> result = ResetAlarmActionRequestsCopier.copyToBuilder(this.resetActionRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResetActionRequests(Collection<ResetAlarmActionRequest.BuilderImpl> resetActionRequests) {
            this.resetActionRequests = ResetAlarmActionRequestsCopier.copyFromBuilder(resetActionRequests);
        }

        @Override
        @Transient
        public final Builder resetActionRequests(Collection<ResetAlarmActionRequest> resetActionRequests) {
            this.resetActionRequests = ResetAlarmActionRequestsCopier.copy(resetActionRequests);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resetActionRequests(ResetAlarmActionRequest ... resetActionRequests) {
            this.resetActionRequests(Arrays.asList(resetActionRequests));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resetActionRequests(Consumer<ResetAlarmActionRequest.Builder> ... resetActionRequests) {
            this.resetActionRequests(Stream.of(resetActionRequests).map(c -> (ResetAlarmActionRequest)((ResetAlarmActionRequest.Builder)ResetAlarmActionRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchResetAlarmRequest build() {
            return new BatchResetAlarmRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotEventsDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchResetAlarmRequest> {
        public Builder resetActionRequests(Collection<ResetAlarmActionRequest> var1);

        public Builder resetActionRequests(ResetAlarmActionRequest ... var1);

        public Builder resetActionRequests(Consumer<ResetAlarmActionRequest.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

