/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ioteventsdata.model.IotEventsDataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAlarmRequest
extends IotEventsDataRequest
implements ToCopyableBuilder<Builder, DescribeAlarmRequest> {
    private static final SdkField<String> ALARM_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmModelName").getter(DescribeAlarmRequest.getter(DescribeAlarmRequest::alarmModelName)).setter(DescribeAlarmRequest.setter(Builder::alarmModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("alarmModelName").build()}).build();
    private static final SdkField<String> KEY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyValue").getter(DescribeAlarmRequest.getter(DescribeAlarmRequest::keyValue)).setter(DescribeAlarmRequest.setter(Builder::keyValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("keyValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_MODEL_NAME_FIELD, KEY_VALUE_FIELD));
    private final String alarmModelName;
    private final String keyValue;

    private DescribeAlarmRequest(BuilderImpl builder) {
        super(builder);
        this.alarmModelName = builder.alarmModelName;
        this.keyValue = builder.keyValue;
    }

    public final String alarmModelName() {
        return this.alarmModelName;
    }

    public final String keyValue() {
        return this.keyValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmRequest)) {
            return false;
        }
        DescribeAlarmRequest other = (DescribeAlarmRequest)((Object)obj);
        return Objects.equals(this.alarmModelName(), other.alarmModelName()) && Objects.equals(this.keyValue(), other.keyValue());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAlarmRequest").add("AlarmModelName", (Object)this.alarmModelName()).add("KeyValue", (Object)this.keyValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alarmModelName": {
                return Optional.ofNullable(clazz.cast(this.alarmModelName()));
            }
            case "keyValue": {
                return Optional.ofNullable(clazz.cast(this.keyValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAlarmRequest, T> g) {
        return obj -> g.apply((DescribeAlarmRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotEventsDataRequest.BuilderImpl
    implements Builder {
        private String alarmModelName;
        private String keyValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmRequest model) {
            super(model);
            this.alarmModelName(model.alarmModelName);
            this.keyValue(model.keyValue);
        }

        public final String getAlarmModelName() {
            return this.alarmModelName;
        }

        public final void setAlarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
        }

        @Override
        @Transient
        public final Builder alarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
            return this;
        }

        public final String getKeyValue() {
            return this.keyValue;
        }

        public final void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        @Override
        @Transient
        public final Builder keyValue(String keyValue) {
            this.keyValue = keyValue;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAlarmRequest build() {
            return new DescribeAlarmRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotEventsDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAlarmRequest> {
        public Builder alarmModelName(String var1);

        public Builder keyValue(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

