/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ioteventsdata.model.AlarmStateName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlarmSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlarmSummary> {
    private static final SdkField<String> ALARM_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmModelName").getter(AlarmSummary.getter(AlarmSummary::alarmModelName)).setter(AlarmSummary.setter(Builder::alarmModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelName").build()}).build();
    private static final SdkField<String> ALARM_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmModelVersion").getter(AlarmSummary.getter(AlarmSummary::alarmModelVersion)).setter(AlarmSummary.setter(Builder::alarmModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelVersion").build()}).build();
    private static final SdkField<String> KEY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyValue").getter(AlarmSummary.getter(AlarmSummary::keyValue)).setter(AlarmSummary.setter(Builder::keyValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyValue").build()}).build();
    private static final SdkField<String> STATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateName").getter(AlarmSummary.getter(AlarmSummary::stateNameAsString)).setter(AlarmSummary.setter(Builder::stateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(AlarmSummary.getter(AlarmSummary::creationTime)).setter(AlarmSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdateTime").getter(AlarmSummary.getter(AlarmSummary::lastUpdateTime)).setter(AlarmSummary.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_MODEL_NAME_FIELD, ALARM_MODEL_VERSION_FIELD, KEY_VALUE_FIELD, STATE_NAME_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String alarmModelName;
    private final String alarmModelVersion;
    private final String keyValue;
    private final String stateName;
    private final Instant creationTime;
    private final Instant lastUpdateTime;

    private AlarmSummary(BuilderImpl builder) {
        this.alarmModelName = builder.alarmModelName;
        this.alarmModelVersion = builder.alarmModelVersion;
        this.keyValue = builder.keyValue;
        this.stateName = builder.stateName;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    public final String alarmModelName() {
        return this.alarmModelName;
    }

    public final String alarmModelVersion() {
        return this.alarmModelVersion;
    }

    public final String keyValue() {
        return this.keyValue;
    }

    public final AlarmStateName stateName() {
        return AlarmStateName.fromValue(this.stateName);
    }

    public final String stateNameAsString() {
        return this.stateName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmSummary)) {
            return false;
        }
        AlarmSummary other = (AlarmSummary)obj;
        return Objects.equals(this.alarmModelName(), other.alarmModelName()) && Objects.equals(this.alarmModelVersion(), other.alarmModelVersion()) && Objects.equals(this.keyValue(), other.keyValue()) && Objects.equals(this.stateNameAsString(), other.stateNameAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime());
    }

    public final String toString() {
        return ToString.builder((String)"AlarmSummary").add("AlarmModelName", (Object)this.alarmModelName()).add("AlarmModelVersion", (Object)this.alarmModelVersion()).add("KeyValue", (Object)this.keyValue()).add("StateName", (Object)this.stateNameAsString()).add("CreationTime", (Object)this.creationTime()).add("LastUpdateTime", (Object)this.lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alarmModelName": {
                return Optional.ofNullable(clazz.cast(this.alarmModelName()));
            }
            case "alarmModelVersion": {
                return Optional.ofNullable(clazz.cast(this.alarmModelVersion()));
            }
            case "keyValue": {
                return Optional.ofNullable(clazz.cast(this.keyValue()));
            }
            case "stateName": {
                return Optional.ofNullable(clazz.cast(this.stateNameAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "lastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlarmSummary, T> g) {
        return obj -> g.apply((AlarmSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alarmModelName;
        private String alarmModelVersion;
        private String keyValue;
        private String stateName;
        private Instant creationTime;
        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmSummary model) {
            this.alarmModelName(model.alarmModelName);
            this.alarmModelVersion(model.alarmModelVersion);
            this.keyValue(model.keyValue);
            this.stateName(model.stateName);
            this.creationTime(model.creationTime);
            this.lastUpdateTime(model.lastUpdateTime);
        }

        public final String getAlarmModelName() {
            return this.alarmModelName;
        }

        @Override
        public final Builder alarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
            return this;
        }

        public final void setAlarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
        }

        public final String getAlarmModelVersion() {
            return this.alarmModelVersion;
        }

        @Override
        public final Builder alarmModelVersion(String alarmModelVersion) {
            this.alarmModelVersion = alarmModelVersion;
            return this;
        }

        public final void setAlarmModelVersion(String alarmModelVersion) {
            this.alarmModelVersion = alarmModelVersion;
        }

        public final String getKeyValue() {
            return this.keyValue;
        }

        @Override
        public final Builder keyValue(String keyValue) {
            this.keyValue = keyValue;
            return this;
        }

        public final void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        public final String getStateName() {
            return this.stateName;
        }

        @Override
        public final Builder stateName(String stateName) {
            this.stateName = stateName;
            return this;
        }

        @Override
        public final Builder stateName(AlarmStateName stateName) {
            this.stateName(stateName == null ? null : stateName.toString());
            return this;
        }

        public final void setStateName(String stateName) {
            this.stateName = stateName;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public AlarmSummary build() {
            return new AlarmSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlarmSummary> {
        public Builder alarmModelName(String var1);

        public Builder alarmModelVersion(String var1);

        public Builder keyValue(String var1);

        public Builder stateName(String var1);

        public Builder stateName(AlarmStateName var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdateTime(Instant var1);
    }
}

