/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information used to update the detector (instance).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDetectorRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateDetectorRequest.Builder, UpdateDetectorRequest> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageId").getter(getter(UpdateDetectorRequest::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageId").build()).build();

    private static final SdkField<String> DETECTOR_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("detectorModelName").getter(getter(UpdateDetectorRequest::detectorModelName))
            .setter(setter(Builder::detectorModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorModelName").build()).build();

    private static final SdkField<String> KEY_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("keyValue").getter(getter(UpdateDetectorRequest::keyValue)).setter(setter(Builder::keyValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyValue").build()).build();

    private static final SdkField<DetectorStateDefinition> STATE_FIELD = SdkField
            .<DetectorStateDefinition> builder(MarshallingType.SDK_POJO).memberName("state")
            .getter(getter(UpdateDetectorRequest::state)).setter(setter(Builder::state))
            .constructor(DetectorStateDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD,
            DETECTOR_MODEL_NAME_FIELD, KEY_VALUE_FIELD, STATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String messageId;

    private final String detectorModelName;

    private final String keyValue;

    private final DetectorStateDefinition state;

    private UpdateDetectorRequest(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.detectorModelName = builder.detectorModelName;
        this.keyValue = builder.keyValue;
        this.state = builder.state;
    }

    /**
     * <p>
     * The ID to assign to the detector update <code>"message"</code>. Each <code>"messageId"</code> must be unique
     * within each batch sent.
     * </p>
     * 
     * @return The ID to assign to the detector update <code>"message"</code>. Each <code>"messageId"</code> must be
     *         unique within each batch sent.
     */
    public final String messageId() {
        return messageId;
    }

    /**
     * <p>
     * The name of the detector model that created the detectors (instances).
     * </p>
     * 
     * @return The name of the detector model that created the detectors (instances).
     */
    public final String detectorModelName() {
        return detectorModelName;
    }

    /**
     * <p>
     * The value of the input key attribute (identifying the device or system) that caused the creation of this detector
     * (instance).
     * </p>
     * 
     * @return The value of the input key attribute (identifying the device or system) that caused the creation of this
     *         detector (instance).
     */
    public final String keyValue() {
        return keyValue;
    }

    /**
     * <p>
     * The new state, variable values, and timer settings of the detector (instance).
     * </p>
     * 
     * @return The new state, variable values, and timer settings of the detector (instance).
     */
    public final DetectorStateDefinition state() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(detectorModelName());
        hashCode = 31 * hashCode + Objects.hashCode(keyValue());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDetectorRequest)) {
            return false;
        }
        UpdateDetectorRequest other = (UpdateDetectorRequest) obj;
        return Objects.equals(messageId(), other.messageId()) && Objects.equals(detectorModelName(), other.detectorModelName())
                && Objects.equals(keyValue(), other.keyValue()) && Objects.equals(state(), other.state());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDetectorRequest").add("MessageId", messageId())
                .add("DetectorModelName", detectorModelName()).add("KeyValue", keyValue()).add("State", state()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "messageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "detectorModelName":
            return Optional.ofNullable(clazz.cast(detectorModelName()));
        case "keyValue":
            return Optional.ofNullable(clazz.cast(keyValue()));
        case "state":
            return Optional.ofNullable(clazz.cast(state()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDetectorRequest, T> g) {
        return obj -> g.apply((UpdateDetectorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateDetectorRequest> {
        /**
         * <p>
         * The ID to assign to the detector update <code>"message"</code>. Each <code>"messageId"</code> must be unique
         * within each batch sent.
         * </p>
         * 
         * @param messageId
         *        The ID to assign to the detector update <code>"message"</code>. Each <code>"messageId"</code> must be
         *        unique within each batch sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * The name of the detector model that created the detectors (instances).
         * </p>
         * 
         * @param detectorModelName
         *        The name of the detector model that created the detectors (instances).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectorModelName(String detectorModelName);

        /**
         * <p>
         * The value of the input key attribute (identifying the device or system) that caused the creation of this
         * detector (instance).
         * </p>
         * 
         * @param keyValue
         *        The value of the input key attribute (identifying the device or system) that caused the creation of
         *        this detector (instance).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyValue(String keyValue);

        /**
         * <p>
         * The new state, variable values, and timer settings of the detector (instance).
         * </p>
         * 
         * @param state
         *        The new state, variable values, and timer settings of the detector (instance).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(DetectorStateDefinition state);

        /**
         * <p>
         * The new state, variable values, and timer settings of the detector (instance).
         * </p>
         * This is a convenience that creates an instance of the {@link DetectorStateDefinition.Builder} avoiding the
         * need to create one manually via {@link DetectorStateDefinition#builder()}.
         *
         * When the {@link Consumer} completes, {@link DetectorStateDefinition.Builder#build()} is called immediately
         * and its result is passed to {@link #state(DetectorStateDefinition)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link DetectorStateDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(DetectorStateDefinition)
         */
        default Builder state(Consumer<DetectorStateDefinition.Builder> state) {
            return state(DetectorStateDefinition.builder().applyMutation(state).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String messageId;

        private String detectorModelName;

        private String keyValue;

        private DetectorStateDefinition state;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDetectorRequest model) {
            messageId(model.messageId);
            detectorModelName(model.detectorModelName);
            keyValue(model.keyValue);
            state(model.state);
        }

        public final String getMessageId() {
            return messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public final String getDetectorModelName() {
            return detectorModelName;
        }

        @Override
        public final Builder detectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
            return this;
        }

        public final void setDetectorModelName(String detectorModelName) {
            this.detectorModelName = detectorModelName;
        }

        public final String getKeyValue() {
            return keyValue;
        }

        @Override
        public final Builder keyValue(String keyValue) {
            this.keyValue = keyValue;
            return this;
        }

        public final void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        public final DetectorStateDefinition.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        @Override
        public final Builder state(DetectorStateDefinition state) {
            this.state = state;
            return this;
        }

        public final void setState(DetectorStateDefinition.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public UpdateDetectorRequest build() {
            return new UpdateDetectorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
