/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisableAlarmActionRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DisableAlarmActionRequest> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(DisableAlarmActionRequest.getter(DisableAlarmActionRequest::requestId)).setter(DisableAlarmActionRequest.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<String> ALARM_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmModelName").getter(DisableAlarmActionRequest.getter(DisableAlarmActionRequest::alarmModelName)).setter(DisableAlarmActionRequest.setter(Builder::alarmModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmModelName").build()}).build();
    private static final SdkField<String> KEY_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyValue").getter(DisableAlarmActionRequest.getter(DisableAlarmActionRequest::keyValue)).setter(DisableAlarmActionRequest.setter(Builder::keyValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyValue").build()}).build();
    private static final SdkField<String> NOTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("note").getter(DisableAlarmActionRequest.getter(DisableAlarmActionRequest::note)).setter(DisableAlarmActionRequest.setter(Builder::note)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("note").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, ALARM_MODEL_NAME_FIELD, KEY_VALUE_FIELD, NOTE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String requestIdValue;
    private final String alarmModelName;
    private final String keyValue;
    private final String note;

    private DisableAlarmActionRequest(BuilderImpl builder) {
        this.requestIdValue = builder.requestIdValue;
        this.alarmModelName = builder.alarmModelName;
        this.keyValue = builder.keyValue;
        this.note = builder.note;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final String alarmModelName() {
        return this.alarmModelName;
    }

    public final String keyValue() {
        return this.keyValue;
    }

    public final String note() {
        return this.note;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.note());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableAlarmActionRequest)) {
            return false;
        }
        DisableAlarmActionRequest other = (DisableAlarmActionRequest)obj;
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.alarmModelName(), other.alarmModelName()) && Objects.equals(this.keyValue(), other.keyValue()) && Objects.equals(this.note(), other.note());
    }

    public final String toString() {
        return ToString.builder((String)"DisableAlarmActionRequest").add("RequestId", (Object)this.requestId()).add("AlarmModelName", (Object)this.alarmModelName()).add("KeyValue", (Object)this.keyValue()).add("Note", (Object)this.note()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "alarmModelName": {
                return Optional.ofNullable(clazz.cast(this.alarmModelName()));
            }
            case "keyValue": {
                return Optional.ofNullable(clazz.cast(this.keyValue()));
            }
            case "note": {
                return Optional.ofNullable(clazz.cast(this.note()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisableAlarmActionRequest, T> g) {
        return obj -> g.apply((DisableAlarmActionRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String requestIdValue;
        private String alarmModelName;
        private String keyValue;
        private String note;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableAlarmActionRequest model) {
            this.requestId(model.requestIdValue);
            this.alarmModelName(model.alarmModelName);
            this.keyValue(model.keyValue);
            this.note(model.note);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        public final String getAlarmModelName() {
            return this.alarmModelName;
        }

        @Override
        public final Builder alarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
            return this;
        }

        public final void setAlarmModelName(String alarmModelName) {
            this.alarmModelName = alarmModelName;
        }

        public final String getKeyValue() {
            return this.keyValue;
        }

        @Override
        public final Builder keyValue(String keyValue) {
            this.keyValue = keyValue;
            return this;
        }

        public final void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        public final String getNote() {
            return this.note;
        }

        @Override
        public final Builder note(String note) {
            this.note = note;
            return this;
        }

        public final void setNote(String note) {
            this.note = note;
        }

        public DisableAlarmActionRequest build() {
            return new DisableAlarmActionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DisableAlarmActionRequest> {
        public Builder requestId(String var1);

        public Builder alarmModelName(String var1);

        public Builder keyValue(String var1);

        public Builder note(String var1);
    }
}

