/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateDetectorRequest extends IotEventsDataRequest implements
        ToCopyableBuilder<BatchUpdateDetectorRequest.Builder, BatchUpdateDetectorRequest> {
    private static final SdkField<List<UpdateDetectorRequest>> DETECTORS_FIELD = SdkField
            .<List<UpdateDetectorRequest>> builder(MarshallingType.LIST)
            .getter(getter(BatchUpdateDetectorRequest::detectors))
            .setter(setter(Builder::detectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpdateDetectorRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateDetectorRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTORS_FIELD));

    private final List<UpdateDetectorRequest> detectors;

    private BatchUpdateDetectorRequest(BuilderImpl builder) {
        super(builder);
        this.detectors = builder.detectors;
    }

    /**
     * Returns true if the Detectors property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDetectors() {
        return detectors != null && !(detectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of detectors (instances) to update, along with the values to update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDetectors()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of detectors (instances) to update, along with the values to update.
     */
    public List<UpdateDetectorRequest> detectors() {
        return detectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(detectors());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateDetectorRequest)) {
            return false;
        }
        BatchUpdateDetectorRequest other = (BatchUpdateDetectorRequest) obj;
        return Objects.equals(detectors(), other.detectors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchUpdateDetectorRequest").add("Detectors", detectors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "detectors":
            return Optional.ofNullable(clazz.cast(detectors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateDetectorRequest, T> g) {
        return obj -> g.apply((BatchUpdateDetectorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchUpdateDetectorRequest> {
        /**
         * <p>
         * The list of detectors (instances) to update, along with the values to update.
         * </p>
         * 
         * @param detectors
         *        The list of detectors (instances) to update, along with the values to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectors(Collection<UpdateDetectorRequest> detectors);

        /**
         * <p>
         * The list of detectors (instances) to update, along with the values to update.
         * </p>
         * 
         * @param detectors
         *        The list of detectors (instances) to update, along with the values to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectors(UpdateDetectorRequest... detectors);

        /**
         * <p>
         * The list of detectors (instances) to update, along with the values to update.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UpdateDetectorRequest>.Builder} avoiding
         * the need to create one manually via {@link List<UpdateDetectorRequest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UpdateDetectorRequest>.Builder#build()} is called
         * immediately and its result is passed to {@link #detectors(List<UpdateDetectorRequest>)}.
         * 
         * @param detectors
         *        a consumer that will call methods on {@link List<UpdateDetectorRequest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detectors(List<UpdateDetectorRequest>)
         */
        Builder detectors(Consumer<UpdateDetectorRequest.Builder>... detectors);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotEventsDataRequest.BuilderImpl implements Builder {
        private List<UpdateDetectorRequest> detectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateDetectorRequest model) {
            super(model);
            detectors(model.detectors);
        }

        public final Collection<UpdateDetectorRequest.Builder> getDetectors() {
            return detectors != null ? detectors.stream().map(UpdateDetectorRequest::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder detectors(Collection<UpdateDetectorRequest> detectors) {
            this.detectors = UpdateDetectorRequestsCopier.copy(detectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectors(UpdateDetectorRequest... detectors) {
            detectors(Arrays.asList(detectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectors(Consumer<UpdateDetectorRequest.Builder>... detectors) {
            detectors(Stream.of(detectors).map(c -> UpdateDetectorRequest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDetectors(Collection<UpdateDetectorRequest.BuilderImpl> detectors) {
            this.detectors = UpdateDetectorRequestsCopier.copyFromBuilder(detectors);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateDetectorRequest build() {
            return new BatchUpdateDetectorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
