/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ioteventsdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateDetectorResponse extends IotEventsDataResponse implements
        ToCopyableBuilder<BatchUpdateDetectorResponse.Builder, BatchUpdateDetectorResponse> {
    private static final SdkField<List<BatchUpdateDetectorErrorEntry>> BATCH_UPDATE_DETECTOR_ERROR_ENTRIES_FIELD = SdkField
            .<List<BatchUpdateDetectorErrorEntry>> builder(MarshallingType.LIST)
            .getter(getter(BatchUpdateDetectorResponse::batchUpdateDetectorErrorEntries))
            .setter(setter(Builder::batchUpdateDetectorErrorEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchUpdateDetectorErrorEntries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchUpdateDetectorErrorEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchUpdateDetectorErrorEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(BATCH_UPDATE_DETECTOR_ERROR_ENTRIES_FIELD));

    private final List<BatchUpdateDetectorErrorEntry> batchUpdateDetectorErrorEntries;

    private BatchUpdateDetectorResponse(BuilderImpl builder) {
        super(builder);
        this.batchUpdateDetectorErrorEntries = builder.batchUpdateDetectorErrorEntries;
    }

    /**
     * Returns true if the BatchUpdateDetectorErrorEntries property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasBatchUpdateDetectorErrorEntries() {
        return batchUpdateDetectorErrorEntries != null && !(batchUpdateDetectorErrorEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of those detector updates that resulted in errors. (If an error is listed here, the specific update did
     * not occur.)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasBatchUpdateDetectorErrorEntries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of those detector updates that resulted in errors. (If an error is listed here, the specific
     *         update did not occur.)
     */
    public List<BatchUpdateDetectorErrorEntry> batchUpdateDetectorErrorEntries() {
        return batchUpdateDetectorErrorEntries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(batchUpdateDetectorErrorEntries());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateDetectorResponse)) {
            return false;
        }
        BatchUpdateDetectorResponse other = (BatchUpdateDetectorResponse) obj;
        return Objects.equals(batchUpdateDetectorErrorEntries(), other.batchUpdateDetectorErrorEntries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchUpdateDetectorResponse")
                .add("BatchUpdateDetectorErrorEntries", batchUpdateDetectorErrorEntries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "batchUpdateDetectorErrorEntries":
            return Optional.ofNullable(clazz.cast(batchUpdateDetectorErrorEntries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateDetectorResponse, T> g) {
        return obj -> g.apply((BatchUpdateDetectorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotEventsDataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchUpdateDetectorResponse> {
        /**
         * <p>
         * A list of those detector updates that resulted in errors. (If an error is listed here, the specific update
         * did not occur.)
         * </p>
         * 
         * @param batchUpdateDetectorErrorEntries
         *        A list of those detector updates that resulted in errors. (If an error is listed here, the specific
         *        update did not occur.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchUpdateDetectorErrorEntries(Collection<BatchUpdateDetectorErrorEntry> batchUpdateDetectorErrorEntries);

        /**
         * <p>
         * A list of those detector updates that resulted in errors. (If an error is listed here, the specific update
         * did not occur.)
         * </p>
         * 
         * @param batchUpdateDetectorErrorEntries
         *        A list of those detector updates that resulted in errors. (If an error is listed here, the specific
         *        update did not occur.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchUpdateDetectorErrorEntries(BatchUpdateDetectorErrorEntry... batchUpdateDetectorErrorEntries);

        /**
         * <p>
         * A list of those detector updates that resulted in errors. (If an error is listed here, the specific update
         * did not occur.)
         * </p>
         * This is a convenience that creates an instance of the {@link List<BatchUpdateDetectorErrorEntry>.Builder}
         * avoiding the need to create one manually via {@link List<BatchUpdateDetectorErrorEntry>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BatchUpdateDetectorErrorEntry>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #batchUpdateDetectorErrorEntries(List<BatchUpdateDetectorErrorEntry>)}.
         * 
         * @param batchUpdateDetectorErrorEntries
         *        a consumer that will call methods on {@link List<BatchUpdateDetectorErrorEntry>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #batchUpdateDetectorErrorEntries(List<BatchUpdateDetectorErrorEntry>)
         */
        Builder batchUpdateDetectorErrorEntries(
                Consumer<BatchUpdateDetectorErrorEntry.Builder>... batchUpdateDetectorErrorEntries);
    }

    static final class BuilderImpl extends IotEventsDataResponse.BuilderImpl implements Builder {
        private List<BatchUpdateDetectorErrorEntry> batchUpdateDetectorErrorEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateDetectorResponse model) {
            super(model);
            batchUpdateDetectorErrorEntries(model.batchUpdateDetectorErrorEntries);
        }

        public final Collection<BatchUpdateDetectorErrorEntry.Builder> getBatchUpdateDetectorErrorEntries() {
            return batchUpdateDetectorErrorEntries != null ? batchUpdateDetectorErrorEntries.stream()
                    .map(BatchUpdateDetectorErrorEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder batchUpdateDetectorErrorEntries(
                Collection<BatchUpdateDetectorErrorEntry> batchUpdateDetectorErrorEntries) {
            this.batchUpdateDetectorErrorEntries = BatchUpdateDetectorErrorEntriesCopier.copy(batchUpdateDetectorErrorEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchUpdateDetectorErrorEntries(BatchUpdateDetectorErrorEntry... batchUpdateDetectorErrorEntries) {
            batchUpdateDetectorErrorEntries(Arrays.asList(batchUpdateDetectorErrorEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchUpdateDetectorErrorEntries(
                Consumer<BatchUpdateDetectorErrorEntry.Builder>... batchUpdateDetectorErrorEntries) {
            batchUpdateDetectorErrorEntries(Stream.of(batchUpdateDetectorErrorEntries)
                    .map(c -> BatchUpdateDetectorErrorEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBatchUpdateDetectorErrorEntries(
                Collection<BatchUpdateDetectorErrorEntry.BuilderImpl> batchUpdateDetectorErrorEntries) {
            this.batchUpdateDetectorErrorEntries = BatchUpdateDetectorErrorEntriesCopier
                    .copyFromBuilder(batchUpdateDetectorErrorEntries);
        }

        @Override
        public BatchUpdateDetectorResponse build() {
            return new BatchUpdateDetectorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
