/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotdeviceadvisor.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestCaseRun
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TestCaseRun> {
    private static final SdkField<String> TEST_CASE_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testCaseRunId").getter(TestCaseRun.getter(TestCaseRun::testCaseRunId)).setter(TestCaseRun.setter(Builder::testCaseRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseRunId").build()}).build();
    private static final SdkField<String> TEST_CASE_DEFINITION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testCaseDefinitionId").getter(TestCaseRun.getter(TestCaseRun::testCaseDefinitionId)).setter(TestCaseRun.setter(Builder::testCaseDefinitionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseDefinitionId").build()}).build();
    private static final SdkField<String> TEST_CASE_DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testCaseDefinitionName").getter(TestCaseRun.getter(TestCaseRun::testCaseDefinitionName)).setter(TestCaseRun.setter(Builder::testCaseDefinitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseDefinitionName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(TestCaseRun.getter(TestCaseRun::statusAsString)).setter(TestCaseRun.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(TestCaseRun.getter(TestCaseRun::startTime)).setter(TestCaseRun.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(TestCaseRun.getter(TestCaseRun::endTime)).setter(TestCaseRun.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> LOG_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logUrl").getter(TestCaseRun.getter(TestCaseRun::logUrl)).setter(TestCaseRun.setter(Builder::logUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logUrl").build()}).build();
    private static final SdkField<String> WARNINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("warnings").getter(TestCaseRun.getter(TestCaseRun::warnings)).setter(TestCaseRun.setter(Builder::warnings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warnings").build()}).build();
    private static final SdkField<String> FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failure").getter(TestCaseRun.getter(TestCaseRun::failure)).setter(TestCaseRun.setter(Builder::failure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failure").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CASE_RUN_ID_FIELD, TEST_CASE_DEFINITION_ID_FIELD, TEST_CASE_DEFINITION_NAME_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, LOG_URL_FIELD, WARNINGS_FIELD, FAILURE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String testCaseRunId;
    private final String testCaseDefinitionId;
    private final String testCaseDefinitionName;
    private final String status;
    private final Instant startTime;
    private final Instant endTime;
    private final String logUrl;
    private final String warnings;
    private final String failure;

    private TestCaseRun(BuilderImpl builder) {
        this.testCaseRunId = builder.testCaseRunId;
        this.testCaseDefinitionId = builder.testCaseDefinitionId;
        this.testCaseDefinitionName = builder.testCaseDefinitionName;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.logUrl = builder.logUrl;
        this.warnings = builder.warnings;
        this.failure = builder.failure;
    }

    public final String testCaseRunId() {
        return this.testCaseRunId;
    }

    public final String testCaseDefinitionId() {
        return this.testCaseDefinitionId;
    }

    public final String testCaseDefinitionName() {
        return this.testCaseDefinitionName;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String logUrl() {
        return this.logUrl;
    }

    public final String warnings() {
        return this.warnings;
    }

    public final String failure() {
        return this.failure;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.testCaseRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.testCaseDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.testCaseDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.logUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.warnings());
        hashCode = 31 * hashCode + Objects.hashCode(this.failure());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestCaseRun)) {
            return false;
        }
        TestCaseRun other = (TestCaseRun)obj;
        return Objects.equals(this.testCaseRunId(), other.testCaseRunId()) && Objects.equals(this.testCaseDefinitionId(), other.testCaseDefinitionId()) && Objects.equals(this.testCaseDefinitionName(), other.testCaseDefinitionName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.logUrl(), other.logUrl()) && Objects.equals(this.warnings(), other.warnings()) && Objects.equals(this.failure(), other.failure());
    }

    public final String toString() {
        return ToString.builder((String)"TestCaseRun").add("TestCaseRunId", (Object)this.testCaseRunId()).add("TestCaseDefinitionId", (Object)this.testCaseDefinitionId()).add("TestCaseDefinitionName", (Object)this.testCaseDefinitionName()).add("Status", (Object)this.statusAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("LogUrl", (Object)this.logUrl()).add("Warnings", (Object)this.warnings()).add("Failure", (Object)this.failure()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testCaseRunId": {
                return Optional.ofNullable(clazz.cast(this.testCaseRunId()));
            }
            case "testCaseDefinitionId": {
                return Optional.ofNullable(clazz.cast(this.testCaseDefinitionId()));
            }
            case "testCaseDefinitionName": {
                return Optional.ofNullable(clazz.cast(this.testCaseDefinitionName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "logUrl": {
                return Optional.ofNullable(clazz.cast(this.logUrl()));
            }
            case "warnings": {
                return Optional.ofNullable(clazz.cast(this.warnings()));
            }
            case "failure": {
                return Optional.ofNullable(clazz.cast(this.failure()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestCaseRun, T> g) {
        return obj -> g.apply((TestCaseRun)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String testCaseRunId;
        private String testCaseDefinitionId;
        private String testCaseDefinitionName;
        private String status;
        private Instant startTime;
        private Instant endTime;
        private String logUrl;
        private String warnings;
        private String failure;

        private BuilderImpl() {
        }

        private BuilderImpl(TestCaseRun model) {
            this.testCaseRunId(model.testCaseRunId);
            this.testCaseDefinitionId(model.testCaseDefinitionId);
            this.testCaseDefinitionName(model.testCaseDefinitionName);
            this.status(model.status);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.logUrl(model.logUrl);
            this.warnings(model.warnings);
            this.failure(model.failure);
        }

        public final String getTestCaseRunId() {
            return this.testCaseRunId;
        }

        public final void setTestCaseRunId(String testCaseRunId) {
            this.testCaseRunId = testCaseRunId;
        }

        @Override
        public final Builder testCaseRunId(String testCaseRunId) {
            this.testCaseRunId = testCaseRunId;
            return this;
        }

        public final String getTestCaseDefinitionId() {
            return this.testCaseDefinitionId;
        }

        public final void setTestCaseDefinitionId(String testCaseDefinitionId) {
            this.testCaseDefinitionId = testCaseDefinitionId;
        }

        @Override
        public final Builder testCaseDefinitionId(String testCaseDefinitionId) {
            this.testCaseDefinitionId = testCaseDefinitionId;
            return this;
        }

        public final String getTestCaseDefinitionName() {
            return this.testCaseDefinitionName;
        }

        public final void setTestCaseDefinitionName(String testCaseDefinitionName) {
            this.testCaseDefinitionName = testCaseDefinitionName;
        }

        @Override
        public final Builder testCaseDefinitionName(String testCaseDefinitionName) {
            this.testCaseDefinitionName = testCaseDefinitionName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getLogUrl() {
            return this.logUrl;
        }

        public final void setLogUrl(String logUrl) {
            this.logUrl = logUrl;
        }

        @Override
        public final Builder logUrl(String logUrl) {
            this.logUrl = logUrl;
            return this;
        }

        public final String getWarnings() {
            return this.warnings;
        }

        public final void setWarnings(String warnings) {
            this.warnings = warnings;
        }

        @Override
        public final Builder warnings(String warnings) {
            this.warnings = warnings;
            return this;
        }

        public final String getFailure() {
            return this.failure;
        }

        public final void setFailure(String failure) {
            this.failure = failure;
        }

        @Override
        public final Builder failure(String failure) {
            this.failure = failure;
            return this;
        }

        public TestCaseRun build() {
            return new TestCaseRun(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TestCaseRun> {
        public Builder testCaseRunId(String var1);

        public Builder testCaseDefinitionId(String var1);

        public Builder testCaseDefinitionName(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder logUrl(String var1);

        public Builder warnings(String var1);

        public Builder failure(String var1);
    }
}

