/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotdeviceadvisor.model.TestCase;
import software.amazon.awssdk.services.iotdeviceadvisor.model.TestCaseListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestCaseCategory
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TestCaseCategory> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(TestCaseCategory.getter(TestCaseCategory::name)).setter(TestCaseCategory.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<TestCase>> TESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tests").getter(TestCaseCategory.getter(TestCaseCategory::tests)).setter(TestCaseCategory.setter(Builder::tests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TestCase::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TESTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<TestCase> tests;

    private TestCaseCategory(BuilderImpl builder) {
        this.name = builder.name;
        this.tests = builder.tests;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTests() {
        return this.tests != null && !(this.tests instanceof SdkAutoConstructList);
    }

    public final List<TestCase> tests() {
        return this.tests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTests() ? this.tests() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestCaseCategory)) {
            return false;
        }
        TestCaseCategory other = (TestCaseCategory)obj;
        return Objects.equals(this.name(), other.name()) && this.hasTests() == other.hasTests() && Objects.equals(this.tests(), other.tests());
    }

    public final String toString() {
        return ToString.builder((String)"TestCaseCategory").add("Name", (Object)this.name()).add("Tests", this.hasTests() ? this.tests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "tests": {
                return Optional.ofNullable(clazz.cast(this.tests()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestCaseCategory, T> g) {
        return obj -> g.apply((TestCaseCategory)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<TestCase> tests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestCaseCategory model) {
            this.name(model.name);
            this.tests(model.tests);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<TestCase.Builder> getTests() {
            if (this.tests instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tests != null ? (Collection)this.tests.stream().map(TestCase::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tests(Collection<TestCase> tests) {
            this.tests = TestCaseListCopier.copy(tests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tests(TestCase ... tests) {
            this.tests(Arrays.asList(tests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tests(Consumer<TestCase.Builder> ... tests) {
            this.tests(Stream.of(tests).map(c -> (TestCase)((TestCase.Builder)TestCase.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTests(Collection<TestCase.BuilderImpl> tests) {
            this.tests = TestCaseListCopier.copyFromBuilder(tests);
        }

        public TestCaseCategory build() {
            return new TestCaseCategory(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TestCaseCategory> {
        public Builder name(String var1);

        public Builder tests(Collection<TestCase> var1);

        public Builder tests(TestCase ... var1);

        public Builder tests(Consumer<TestCase.Builder> ... var1);
    }
}

