/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdataplane.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotdataplane.model.IotDataPlaneResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRetainedMessageResponse
extends IotDataPlaneResponse
implements ToCopyableBuilder<Builder, GetRetainedMessageResponse> {
    private static final SdkField<String> TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("topic").getter(GetRetainedMessageResponse.getter(GetRetainedMessageResponse::topic)).setter(GetRetainedMessageResponse.setter(Builder::topic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topic").build()}).build();
    private static final SdkField<SdkBytes> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("payload").getter(GetRetainedMessageResponse.getter(GetRetainedMessageResponse::payload)).setter(GetRetainedMessageResponse.setter(Builder::payload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()}).build();
    private static final SdkField<Integer> QOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("qos").getter(GetRetainedMessageResponse.getter(GetRetainedMessageResponse::qos)).setter(GetRetainedMessageResponse.setter(Builder::qos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qos").build()}).build();
    private static final SdkField<Long> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastModifiedTime").getter(GetRetainedMessageResponse.getter(GetRetainedMessageResponse::lastModifiedTime)).setter(GetRetainedMessageResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build()}).build();
    private static final SdkField<SdkBytes> USER_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("userProperties").getter(GetRetainedMessageResponse.getter(GetRetainedMessageResponse::userProperties)).setter(GetRetainedMessageResponse.setter(Builder::userProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_FIELD, PAYLOAD_FIELD, QOS_FIELD, LAST_MODIFIED_TIME_FIELD, USER_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetRetainedMessageResponse.memberNameToFieldInitializer();
    private final String topic;
    private final SdkBytes payload;
    private final Integer qos;
    private final Long lastModifiedTime;
    private final SdkBytes userProperties;

    private GetRetainedMessageResponse(BuilderImpl builder) {
        super(builder);
        this.topic = builder.topic;
        this.payload = builder.payload;
        this.qos = builder.qos;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.userProperties = builder.userProperties;
    }

    public final String topic() {
        return this.topic;
    }

    public final SdkBytes payload() {
        return this.payload;
    }

    public final Integer qos() {
        return this.qos;
    }

    public final Long lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final SdkBytes userProperties() {
        return this.userProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.topic());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        hashCode = 31 * hashCode + Objects.hashCode(this.qos());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.userProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRetainedMessageResponse)) {
            return false;
        }
        GetRetainedMessageResponse other = (GetRetainedMessageResponse)((Object)obj);
        return Objects.equals(this.topic(), other.topic()) && Objects.equals(this.payload(), other.payload()) && Objects.equals(this.qos(), other.qos()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.userProperties(), other.userProperties());
    }

    public final String toString() {
        return ToString.builder((String)"GetRetainedMessageResponse").add("Topic", (Object)this.topic()).add("Payload", (Object)this.payload()).add("Qos", (Object)this.qos()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("UserProperties", (Object)this.userProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "topic": {
                return Optional.ofNullable(clazz.cast(this.topic()));
            }
            case "payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
            case "qos": {
                return Optional.ofNullable(clazz.cast(this.qos()));
            }
            case "lastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "userProperties": {
                return Optional.ofNullable(clazz.cast(this.userProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("topic", TOPIC_FIELD);
        map.put("payload", PAYLOAD_FIELD);
        map.put("qos", QOS_FIELD);
        map.put("lastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("userProperties", USER_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRetainedMessageResponse, T> g) {
        return obj -> g.apply((GetRetainedMessageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotDataPlaneResponse.BuilderImpl
    implements Builder {
        private String topic;
        private SdkBytes payload;
        private Integer qos;
        private Long lastModifiedTime;
        private SdkBytes userProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRetainedMessageResponse model) {
            super(model);
            this.topic(model.topic);
            this.payload(model.payload);
            this.qos(model.qos);
            this.lastModifiedTime(model.lastModifiedTime);
            this.userProperties(model.userProperties);
        }

        public final String getTopic() {
            return this.topic;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final ByteBuffer getPayload() {
            return this.payload == null ? null : this.payload.asByteBuffer();
        }

        public final void setPayload(ByteBuffer payload) {
            this.payload(payload == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)payload));
        }

        @Override
        public final Builder payload(SdkBytes payload) {
            this.payload = payload;
            return this;
        }

        public final Integer getQos() {
            return this.qos;
        }

        public final void setQos(Integer qos) {
            this.qos = qos;
        }

        @Override
        public final Builder qos(Integer qos) {
            this.qos = qos;
            return this;
        }

        public final Long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final ByteBuffer getUserProperties() {
            return this.userProperties == null ? null : this.userProperties.asByteBuffer();
        }

        public final void setUserProperties(ByteBuffer userProperties) {
            this.userProperties(userProperties == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)userProperties));
        }

        @Override
        public final Builder userProperties(SdkBytes userProperties) {
            this.userProperties = userProperties;
            return this;
        }

        @Override
        public GetRetainedMessageResponse build() {
            return new GetRetainedMessageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotDataPlaneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRetainedMessageResponse> {
        public Builder topic(String var1);

        public Builder payload(SdkBytes var1);

        public Builder qos(Integer var1);

        public Builder lastModifiedTime(Long var1);

        public Builder userProperties(SdkBytes var1);
    }
}

