/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdataplane.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.services.iotdataplane.model.IotDataPlaneRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateThingShadowRequest
extends IotDataPlaneRequest
implements ToCopyableBuilder<Builder, UpdateThingShadowRequest> {
    private final String thingName;
    private final SdkBytes payload;

    private UpdateThingShadowRequest(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.payload = builder.payload;
    }

    public String thingName() {
        return this.thingName;
    }

    public SdkBytes payload() {
        return this.payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThingShadowRequest)) {
            return false;
        }
        UpdateThingShadowRequest other = (UpdateThingShadowRequest)((Object)obj);
        return Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.payload(), other.payload());
    }

    public String toString() {
        return ToString.builder((String)"UpdateThingShadowRequest").add("ThingName", (Object)this.thingName()).add("Payload", (Object)this.payload()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IotDataPlaneRequest.BuilderImpl
    implements Builder {
        private String thingName;
        private SdkBytes payload;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThingShadowRequest model) {
            super(model);
            this.thingName(model.thingName);
            this.payload(model.payload);
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final ByteBuffer getPayload() {
            return this.payload == null ? null : this.payload.asByteBuffer();
        }

        @Override
        public final Builder payload(SdkBytes payload) {
            this.payload = StandardMemberCopier.copy((SdkBytes)payload);
            return this;
        }

        public final void setPayload(ByteBuffer payload) {
            this.payload(payload == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)payload));
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateThingShadowRequest build() {
            return new UpdateThingShadowRequest(this);
        }
    }

    public static interface Builder
    extends IotDataPlaneRequest.Builder,
    CopyableBuilder<Builder, UpdateThingShadowRequest> {
        public Builder thingName(String var1);

        public Builder payload(SdkBytes var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

