/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An activity that filters a message based on its attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterActivity implements SdkPojo, Serializable, ToCopyableBuilder<FilterActivity.Builder, FilterActivity> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(FilterActivity::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("filter")
            .getter(getter(FilterActivity::filter)).setter(setter(Builder::filter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<String> NEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("next")
            .getter(getter(FilterActivity::next)).setter(setter(Builder::next))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FILTER_FIELD,
            NEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String filter;

    private final String next;

    private FilterActivity(BuilderImpl builder) {
        this.name = builder.name;
        this.filter = builder.filter;
        this.next = builder.next;
    }

    /**
     * <p>
     * The name of the filter activity.
     * </p>
     * 
     * @return The name of the filter activity.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An expression that looks like a SQL WHERE clause that must return a Boolean value. Messages that satisfy the
     * condition are passed to the next activity.
     * </p>
     * 
     * @return An expression that looks like a SQL WHERE clause that must return a Boolean value. Messages that satisfy
     *         the condition are passed to the next activity.
     */
    public final String filter() {
        return filter;
    }

    /**
     * <p>
     * The next activity in the pipeline.
     * </p>
     * 
     * @return The next activity in the pipeline.
     */
    public final String next() {
        return next;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(next());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterActivity)) {
            return false;
        }
        FilterActivity other = (FilterActivity) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(filter(), other.filter())
                && Objects.equals(next(), other.next());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterActivity").add("Name", name()).add("Filter", filter()).add("Next", next()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "next":
            return Optional.ofNullable(clazz.cast(next()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("filter", FILTER_FIELD);
        map.put("next", NEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FilterActivity, T> g) {
        return obj -> g.apply((FilterActivity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterActivity> {
        /**
         * <p>
         * The name of the filter activity.
         * </p>
         * 
         * @param name
         *        The name of the filter activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An expression that looks like a SQL WHERE clause that must return a Boolean value. Messages that satisfy the
         * condition are passed to the next activity.
         * </p>
         * 
         * @param filter
         *        An expression that looks like a SQL WHERE clause that must return a Boolean value. Messages that
         *        satisfy the condition are passed to the next activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(String filter);

        /**
         * <p>
         * The next activity in the pipeline.
         * </p>
         * 
         * @param next
         *        The next activity in the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder next(String next);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String filter;

        private String next;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterActivity model) {
            name(model.name);
            filter(model.filter);
            next(model.next);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getFilter() {
            return filter;
        }

        public final void setFilter(String filter) {
            this.filter = filter;
        }

        @Override
        public final Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public final String getNext() {
            return next;
        }

        public final void setNext(String next) {
            this.next = next;
        }

        @Override
        public final Builder next(String next) {
            this.next = next;
            return this;
        }

        @Override
        public FilterActivity build() {
            return new FilterActivity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
