/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchPutMessageRequest extends IoTAnalyticsRequest implements
        ToCopyableBuilder<BatchPutMessageRequest.Builder, BatchPutMessageRequest> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelName").getter(getter(BatchPutMessageRequest::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelName").build()).build();

    private static final SdkField<List<Message>> MESSAGES_FIELD = SdkField
            .<List<Message>> builder(MarshallingType.LIST)
            .memberName("messages")
            .getter(getter(BatchPutMessageRequest::messages))
            .setter(setter(Builder::messages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Message> builder(MarshallingType.SDK_POJO)
                                            .constructor(Message::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD,
            MESSAGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String channelName;

    private final List<Message> messages;

    private BatchPutMessageRequest(BuilderImpl builder) {
        super(builder);
        this.channelName = builder.channelName;
        this.messages = builder.messages;
    }

    /**
     * <p>
     * The name of the channel where the messages are sent.
     * </p>
     * 
     * @return The name of the channel where the messages are sent.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Messages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMessages() {
        return messages != null && !(messages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of messages to be sent. Each message has the format: { "messageId": "string", "payload": "string"}.
     * </p>
     * <p>
     * The field names of message payloads (data) that you send to IoT Analytics:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain only alphanumeric characters and undescores (_). No other special characters are allowed.
     * </p>
     * </li>
     * <li>
     * <p>
     * Must begin with an alphabetic character or single underscore (_).
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot contain hyphens (-).
     * </p>
     * </li>
     * <li>
     * <p>
     * In regular expression terms: "^[A-Za-z_]([A-Za-z0-9]*|[A-Za-z0-9][A-Za-z0-9_]*)$".
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot be more than 255 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Are case insensitive. (Fields named foo and FOO in the same payload are considered duplicates.)
     * </p>
     * </li>
     * </ul>
     * <p>
     * For example, {"temp_01": 29} or {"_temp_01": 29} are valid, but {"temp-01": 29}, {"01_temp": 29} or {"__temp_01":
     * 29} are invalid in message payloads.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessages} method.
     * </p>
     * 
     * @return The list of messages to be sent. Each message has the format: { "messageId": "string", "payload":
     *         "string"}.</p>
     *         <p>
     *         The field names of message payloads (data) that you send to IoT Analytics:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain only alphanumeric characters and undescores (_). No other special characters are allowed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Must begin with an alphabetic character or single underscore (_).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot contain hyphens (-).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In regular expression terms: "^[A-Za-z_]([A-Za-z0-9]*|[A-Za-z0-9][A-Za-z0-9_]*)$".
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot be more than 255 characters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Are case insensitive. (Fields named foo and FOO in the same payload are considered duplicates.)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For example, {"temp_01": 29} or {"_temp_01": 29} are valid, but {"temp-01": 29}, {"01_temp": 29} or
     *         {"__temp_01": 29} are invalid in message payloads.
     */
    public final List<Message> messages() {
        return messages;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(hasMessages() ? messages() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchPutMessageRequest)) {
            return false;
        }
        BatchPutMessageRequest other = (BatchPutMessageRequest) obj;
        return Objects.equals(channelName(), other.channelName()) && hasMessages() == other.hasMessages()
                && Objects.equals(messages(), other.messages());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchPutMessageRequest").add("ChannelName", channelName())
                .add("Messages", hasMessages() ? messages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "messages":
            return Optional.ofNullable(clazz.cast(messages()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("channelName", CHANNEL_NAME_FIELD);
        map.put("messages", MESSAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchPutMessageRequest, T> g) {
        return obj -> g.apply((BatchPutMessageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTAnalyticsRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchPutMessageRequest> {
        /**
         * <p>
         * The name of the channel where the messages are sent.
         * </p>
         * 
         * @param channelName
         *        The name of the channel where the messages are sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The list of messages to be sent. Each message has the format: { "messageId": "string", "payload": "string"}.
         * </p>
         * <p>
         * The field names of message payloads (data) that you send to IoT Analytics:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain only alphanumeric characters and undescores (_). No other special characters are allowed.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must begin with an alphabetic character or single underscore (_).
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot contain hyphens (-).
         * </p>
         * </li>
         * <li>
         * <p>
         * In regular expression terms: "^[A-Za-z_]([A-Za-z0-9]*|[A-Za-z0-9][A-Za-z0-9_]*)$".
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot be more than 255 characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * Are case insensitive. (Fields named foo and FOO in the same payload are considered duplicates.)
         * </p>
         * </li>
         * </ul>
         * <p>
         * For example, {"temp_01": 29} or {"_temp_01": 29} are valid, but {"temp-01": 29}, {"01_temp": 29} or
         * {"__temp_01": 29} are invalid in message payloads.
         * </p>
         * 
         * @param messages
         *        The list of messages to be sent. Each message has the format: { "messageId": "string", "payload":
         *        "string"}.</p>
         *        <p>
         *        The field names of message payloads (data) that you send to IoT Analytics:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain only alphanumeric characters and undescores (_). No other special characters are allowed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must begin with an alphabetic character or single underscore (_).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot contain hyphens (-).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In regular expression terms: "^[A-Za-z_]([A-Za-z0-9]*|[A-Za-z0-9][A-Za-z0-9_]*)$".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot be more than 255 characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Are case insensitive. (Fields named foo and FOO in the same payload are considered duplicates.)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For example, {"temp_01": 29} or {"_temp_01": 29} are valid, but {"temp-01": 29}, {"01_temp": 29} or
         *        {"__temp_01": 29} are invalid in message payloads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Collection<Message> messages);

        /**
         * <p>
         * The list of messages to be sent. Each message has the format: { "messageId": "string", "payload": "string"}.
         * </p>
         * <p>
         * The field names of message payloads (data) that you send to IoT Analytics:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain only alphanumeric characters and undescores (_). No other special characters are allowed.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must begin with an alphabetic character or single underscore (_).
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot contain hyphens (-).
         * </p>
         * </li>
         * <li>
         * <p>
         * In regular expression terms: "^[A-Za-z_]([A-Za-z0-9]*|[A-Za-z0-9][A-Za-z0-9_]*)$".
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot be more than 255 characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * Are case insensitive. (Fields named foo and FOO in the same payload are considered duplicates.)
         * </p>
         * </li>
         * </ul>
         * <p>
         * For example, {"temp_01": 29} or {"_temp_01": 29} are valid, but {"temp-01": 29}, {"01_temp": 29} or
         * {"__temp_01": 29} are invalid in message payloads.
         * </p>
         * 
         * @param messages
         *        The list of messages to be sent. Each message has the format: { "messageId": "string", "payload":
         *        "string"}.</p>
         *        <p>
         *        The field names of message payloads (data) that you send to IoT Analytics:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain only alphanumeric characters and undescores (_). No other special characters are allowed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Must begin with an alphabetic character or single underscore (_).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot contain hyphens (-).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In regular expression terms: "^[A-Za-z_]([A-Za-z0-9]*|[A-Za-z0-9][A-Za-z0-9_]*)$".
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot be more than 255 characters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Are case insensitive. (Fields named foo and FOO in the same payload are considered duplicates.)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For example, {"temp_01": 29} or {"_temp_01": 29} are valid, but {"temp-01": 29}, {"01_temp": 29} or
         *        {"__temp_01": 29} are invalid in message payloads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Message... messages);

        /**
         * <p>
         * The list of messages to be sent. Each message has the format: { "messageId": "string", "payload": "string"}.
         * </p>
         * <p>
         * The field names of message payloads (data) that you send to IoT Analytics:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain only alphanumeric characters and undescores (_). No other special characters are allowed.
         * </p>
         * </li>
         * <li>
         * <p>
         * Must begin with an alphabetic character or single underscore (_).
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot contain hyphens (-).
         * </p>
         * </li>
         * <li>
         * <p>
         * In regular expression terms: "^[A-Za-z_]([A-Za-z0-9]*|[A-Za-z0-9][A-Za-z0-9_]*)$".
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot be more than 255 characters.
         * </p>
         * </li>
         * <li>
         * <p>
         * Are case insensitive. (Fields named foo and FOO in the same payload are considered duplicates.)
         * </p>
         * </li>
         * </ul>
         * <p>
         * For example, {"temp_01": 29} or {"_temp_01": 29} are valid, but {"temp-01": 29}, {"01_temp": 29} or
         * {"__temp_01": 29} are invalid in message payloads.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotanalytics.model.Message.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotanalytics.model.Message#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotanalytics.model.Message.Builder#build()} is called immediately and
         * its result is passed to {@link #messages(List<Message>)}.
         * 
         * @param messages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotanalytics.model.Message.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messages(java.util.Collection<Message>)
         */
        Builder messages(Consumer<Message.Builder>... messages);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTAnalyticsRequest.BuilderImpl implements Builder {
        private String channelName;

        private List<Message> messages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchPutMessageRequest model) {
            super(model);
            channelName(model.channelName);
            messages(model.messages);
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final List<Message.Builder> getMessages() {
            List<Message.Builder> result = MessagesCopier.copyToBuilder(this.messages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessages(Collection<Message.BuilderImpl> messages) {
            this.messages = MessagesCopier.copyFromBuilder(messages);
        }

        @Override
        public final Builder messages(Collection<Message> messages) {
            this.messages = MessagesCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Message... messages) {
            messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<Message.Builder>... messages) {
            messages(Stream.of(messages).map(c -> Message.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchPutMessageRequest build() {
            return new BatchPutMessageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
