/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.LateDataRuleConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LateDataRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LateDataRule> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleName").getter(LateDataRule.getter(LateDataRule::ruleName)).setter(LateDataRule.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleName").build()}).build();
    private static final SdkField<LateDataRuleConfiguration> RULE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ruleConfiguration").getter(LateDataRule.getter(LateDataRule::ruleConfiguration)).setter(LateDataRule.setter(Builder::ruleConfiguration)).constructor(LateDataRuleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD, RULE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ruleName", RULE_NAME_FIELD);
            this.put("ruleConfiguration", RULE_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String ruleName;
    private final LateDataRuleConfiguration ruleConfiguration;

    private LateDataRule(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.ruleConfiguration = builder.ruleConfiguration;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    public final LateDataRuleConfiguration ruleConfiguration() {
        return this.ruleConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LateDataRule)) {
            return false;
        }
        LateDataRule other = (LateDataRule)obj;
        return Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.ruleConfiguration(), other.ruleConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"LateDataRule").add("RuleName", (Object)this.ruleName()).add("RuleConfiguration", (Object)this.ruleConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ruleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "ruleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.ruleConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LateDataRule, T> g) {
        return obj -> g.apply((LateDataRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleName;
        private LateDataRuleConfiguration ruleConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(LateDataRule model) {
            this.ruleName(model.ruleName);
            this.ruleConfiguration(model.ruleConfiguration);
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final LateDataRuleConfiguration.Builder getRuleConfiguration() {
            return this.ruleConfiguration != null ? this.ruleConfiguration.toBuilder() : null;
        }

        public final void setRuleConfiguration(LateDataRuleConfiguration.BuilderImpl ruleConfiguration) {
            this.ruleConfiguration = ruleConfiguration != null ? ruleConfiguration.build() : null;
        }

        @Override
        public final Builder ruleConfiguration(LateDataRuleConfiguration ruleConfiguration) {
            this.ruleConfiguration = ruleConfiguration;
            return this;
        }

        public LateDataRule build() {
            return new LateDataRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LateDataRule> {
        public Builder ruleName(String var1);

        public Builder ruleConfiguration(LateDataRuleConfiguration var1);

        default public Builder ruleConfiguration(Consumer<LateDataRuleConfiguration.Builder> ruleConfiguration) {
            return this.ruleConfiguration((LateDataRuleConfiguration)((LateDataRuleConfiguration.Builder)LateDataRuleConfiguration.builder().applyMutation(ruleConfiguration)).build());
        }
    }
}

