/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * How long, in days, message data is kept.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetentionPeriod implements SdkPojo, Serializable, ToCopyableBuilder<RetentionPeriod.Builder, RetentionPeriod> {
    private static final SdkField<Boolean> UNLIMITED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("unlimited").getter(getter(RetentionPeriod::unlimited)).setter(setter(Builder::unlimited))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unlimited").build()).build();

    private static final SdkField<Integer> NUMBER_OF_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfDays").getter(getter(RetentionPeriod::numberOfDays)).setter(setter(Builder::numberOfDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfDays").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNLIMITED_FIELD,
            NUMBER_OF_DAYS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean unlimited;

    private final Integer numberOfDays;

    private RetentionPeriod(BuilderImpl builder) {
        this.unlimited = builder.unlimited;
        this.numberOfDays = builder.numberOfDays;
    }

    /**
     * <p>
     * If true, message data is kept indefinitely.
     * </p>
     * 
     * @return If true, message data is kept indefinitely.
     */
    public final Boolean unlimited() {
        return unlimited;
    }

    /**
     * <p>
     * The number of days that message data is kept. The <code>unlimited</code> parameter must be false.
     * </p>
     * 
     * @return The number of days that message data is kept. The <code>unlimited</code> parameter must be false.
     */
    public final Integer numberOfDays() {
        return numberOfDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unlimited());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDays());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetentionPeriod)) {
            return false;
        }
        RetentionPeriod other = (RetentionPeriod) obj;
        return Objects.equals(unlimited(), other.unlimited()) && Objects.equals(numberOfDays(), other.numberOfDays());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetentionPeriod").add("Unlimited", unlimited()).add("NumberOfDays", numberOfDays()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "unlimited":
            return Optional.ofNullable(clazz.cast(unlimited()));
        case "numberOfDays":
            return Optional.ofNullable(clazz.cast(numberOfDays()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RetentionPeriod, T> g) {
        return obj -> g.apply((RetentionPeriod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetentionPeriod> {
        /**
         * <p>
         * If true, message data is kept indefinitely.
         * </p>
         * 
         * @param unlimited
         *        If true, message data is kept indefinitely.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unlimited(Boolean unlimited);

        /**
         * <p>
         * The number of days that message data is kept. The <code>unlimited</code> parameter must be false.
         * </p>
         * 
         * @param numberOfDays
         *        The number of days that message data is kept. The <code>unlimited</code> parameter must be false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDays(Integer numberOfDays);
    }

    static final class BuilderImpl implements Builder {
        private Boolean unlimited;

        private Integer numberOfDays;

        private BuilderImpl() {
        }

        private BuilderImpl(RetentionPeriod model) {
            unlimited(model.unlimited);
            numberOfDays(model.numberOfDays);
        }

        public final Boolean getUnlimited() {
            return unlimited;
        }

        @Override
        public final Builder unlimited(Boolean unlimited) {
            this.unlimited = unlimited;
            return this;
        }

        public final void setUnlimited(Boolean unlimited) {
            this.unlimited = unlimited;
        }

        public final Integer getNumberOfDays() {
            return numberOfDays;
        }

        @Override
        public final Builder numberOfDays(Integer numberOfDays) {
            this.numberOfDays = numberOfDays;
            return this;
        }

        public final void setNumberOfDays(Integer numberOfDays) {
            this.numberOfDays = numberOfDays;
        }

        @Override
        public RetentionPeriod build() {
            return new RetentionPeriod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
